//////////////////////////////////////
//  Program Name: SNAKOPNT.CPP
//  Programmer: Charlie Calvert
//  Description: Draw playing field and the snake
//  Date: 08/05/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "snako.h"
#include "snakutil.h"

extern PGAMEINFO G;
extern TSNAKEMAP SMap;
enum Bmps {EHead, EBody, EGrass, ERoad, ERoad2};

// -----------------------------------------
//  The Paint Section
// -----------------------------------------

//////////////////////////////////////
// The Drawing of the snake
//////////////////////////////////////
int PaintTheSnake(HDC PaintDC, HDC HeadDC, HDC BodyDC)
{
  BitBlt(PaintDC,
        (G->SectInfo[0].Col - G->Dat.XPos) * G->Dat.SizeX,
        (G->SectInfo[0].Row + G->Dat.MenuSpace) * G->Dat.SizeY,
         G->Dat.SizeX, G->Dat.SizeY, HeadDC, 0, 0, SRCCOPY);

  for (int i = 1; i <= G->Dat.Sections; i++)
    BitBlt(PaintDC,
        (G->SectInfo[i].Col - G->Dat.XPos) * G->Dat.SizeX,
        (G->SectInfo[i].Row + G->Dat.MenuSpace) * G->Dat.SizeY,
         G->Dat.SizeX, G->Dat.SizeY, BodyDC, 0, 0, SRCCOPY);
  return --i;
}

//////////////////////////////////////
// After snake has been somewhere, get rid of prize
// bitmap and just put in regular road.
//////////////////////////////////////
void FillInWhereSnakeHasBeen(HDC PaintDC, int i)
{
  TSAVEBITMAPARY SaveBmp;
  HDC RoadDC;

  RoadDC = GetScaledDC(PaintDC, SaveBmp, SMap.Road, ERoad);	

  BitBlt(PaintDC,
   (G->SectInfo[i].OldCol - G->Dat.XPos) * G->Dat.SizeX,
   (G->SectInfo[i].OldRow + G->Dat.MenuSpace) * G->Dat.SizeY,
    G->Dat.SizeX, G->Dat.SizeY, RoadDC, 0, 0, SRCCOPY);

  DisposeScaledDC(SaveBmp, ERoad);
}

//////////////////////////////////////
// Command central for painting the snake
// GetScaledDC in SnakUtils
//////////////////////////////////////
void DoSnakePainting(HWND hwnd)
{
  TSAVEBITMAPARY SB;
  HDC DC = GetDC(hwnd);

  HDC HeadDC = GetScaledDC(DC, SB, SMap.Head, EHead);
  HDC BodyDC = GetScaledDC(DC, SB, SMap.Body, EBody);	

  int i = PaintTheSnake(DC, HeadDC, BodyDC);

  DisposeScaledDC(SB, EHead);
  DisposeScaledDC(SB, EBody);

  if ((G->SectInfo[i].OldRow > -1) &&
      (G->SectInfo[i].OldCol > -1))
    FillInWhereSnakeHasBeen(DC, i);

  ReleaseDC(hwnd, DC);
}

//////////////////////////////////////
// Used with PaintBitmaps below
//////////////////////////////////////
void BlitIt(HDC PaintDC, HDC BmpDC, int i, int j)
{
  BitBlt(PaintDC, (j - G->Dat.XPos) * G->Dat.GrassX,
      (i * G->Dat.GrassY) + (G->Dat.GrassY * G->Dat.MenuSpace),
       G->Dat.GrassX, G->Dat.GrassY, BmpDC, 0, 0, SRCCOPY);
}

//////////////////////////////////////
// This is used to paint the background
// not to paint the snake.
//////////////////////////////////////
void PaintBitmaps(HDC PaintDC, HDC GrassDC,
                  HDC RoadDC, HDC Road2DC)
{
  G->ScoreRep.NumPrizes = 0;
  for (int i = 0; i < MAXY; i++)
    for (int j = G->Dat.MinCols; j < G->Dat.MaxCols; j++)
    {
      switch (G->Map[i][j])
      {
        case ROADMAP:
          BlitIt(PaintDC, RoadDC, i, j);
          break;

        case GRASSMAP:
          BlitIt(PaintDC, GrassDC, i, j);
          break;

        case PRIZEMAP:
          BlitIt(PaintDC, Road2DC, i, j);
          G->ScoreRep.NumPrizes++;
          break;
      }
    }
}

//////////////////////////////////////
// Paint The Field of Play
//////////////////////////////////////
void PaintPlayingField(HDC PaintDC)
{
  TSAVEBITMAPARY SB;

  HDC GrassDC = GetScaledDC(PaintDC, SB, SMap.Grass, EGrass);
  HDC RoadDC = GetScaledDC(PaintDC, SB, SMap.Road, ERoad);
  HDC Road2DC = GetScaledDC(PaintDC, SB, SMap.Road2, ERoad2);

  PaintBitmaps(PaintDC, GrassDC, RoadDC, Road2DC);

  DisposeScaledDC(SB, EGrass);
  DisposeScaledDC(SB, ERoad);
  DisposeScaledDC(SB, ERoad2);
}

//////////////////////////////////////
// Draw the actual bridge to next screen
//////////////////////////////////////
void MakeAndPaintBridge(HWND hwnd)
{
  TSAVEBITMAPARY SB;

  G->Map[BRIDGEX1][G->Dat.MaxCols - 1] = ROADMAP;
  G->Map[BRIDGEX2][G->Dat.MaxCols - 1] = ROADMAP;

  HDC PaintDC = GetDC(hwnd);
  HDC RoadDC = GetScaledDC(PaintDC, SB, SMap.Road, ERoad);

  BitBlt(PaintDC, (JUMPSPACE - 1) * G->Dat.GrassX,
        (BRIDGEX1 * G->Dat.GrassY) +
        (G->Dat.GrassY * G->Dat.MenuSpace),
         G->Dat.GrassX, G->Dat.GrassY, RoadDC, 0, 0, SRCCOPY);
  BitBlt(PaintDC, (JUMPSPACE - 1) * G->Dat.GrassX,
        (BRIDGEX2 * G->Dat.GrassY) +
        (G->Dat.GrassY * G->Dat.MenuSpace),
         G->Dat.GrassX, G->Dat.GrassY, RoadDC, 0, 0, SRCCOPY);

  DisposeScaledDC(SB, ERoad);
  ReleaseDC(hwnd, PaintDC);
}
