//////////////////////////////////////
//  Module Name: SYSCLASS.CPP
//  Programmer: Charlie Calvert
//  Description: Part of SysInfo Application
//  Date: 08/09/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "sysinfo.h"
#pragma warning (disable: 4068)

static int TotalStyles = 13;

TCLASSSTYLE ClassStyle[] =
{
  CS_VREDRAW, "CS_VREDRAW",
  CS_HREDRAW, "CS_HREDRAW",
  CS_OWNDC, "CS_OWNDC",
  CS_CLASSDC, "CS_CLASSDC",
  CS_PARENTDC, "CS_PARENTDC",
  CS_SAVEBITS, "CS_SAVEBITS",
  CS_DBLCLKS, "CS_DBLCLKS",
  CS_BYTEALIGNCLIENT, "CS_BYTEALIGNCLIENT",
  CS_BYTEALIGNWINDOW, "CS_BYTEALIGNWINDOW",
  CS_NOCLOSE, "CS_NOCLOSE",
  CS_KEYCVTWINDOW, "CS_KEYCVTWINDOW",
  CS_NOKEYCVT, "CS_NOKEYCVT",
  CS_GLOBALCLASS, "CS_GLOBALCLASS",
};

//////////////////////////////////////
// SetClassContents
//////////////////////////////////////
BOOL SetClassContents(HWND hDlg)
{
  CLASSENTRY Class;
  char S[100];
  BOOL Result = TRUE;

  HWND hClassBox = GetDlgItem(hDlg, ID_CLASSLISTBOX);
  SetWindowFont(hClassBox, GetStockFont(ANSI_FIXED_FONT), 0);
  Class.dwSize = sizeof(CLASSENTRY);
  ClassFirst(&Class);
  while (Result)
  {
    sprintf(S, "%s", Class.szClassName, Class.hInst);
    ListBox_AddString(hClassBox, S);
    Result = ClassNext(&Class);
  }
  return TRUE;
}

//////////////////////////////////////
// GetClass Instance
//////////////////////////////////////
HINSTANCE GetClassInstance(LPSTR S)
{
  CLASSENTRY Class;
  BOOL Result = TRUE;

  Class.dwSize = sizeof(CLASSENTRY);
  ClassFirst(&Class);
  while (Result)
  {
    if (!strcmp(S, Class.szClassName))
      return Class.hInst;
    Result = ClassNext(&Class);
  }
  return NULL;
}

//////////////////////////////////////
// SetClassStyles
//////////////////////////////////////
void SetClassStyles(HWND hDlg, UINT style)
{
  HWND hLBWnd = GetDlgItem(hDlg, ID_CLASSSTYLE);
  ListBox_ResetContent(hLBWnd);

  for (int i = 0; i < TotalStyles; i++)
    if((style & ClassStyle[i].Style) == ClassStyle[i].Style)
      ListBox_AddString(hLBWnd, ClassStyle[i].StyleStr);
}

//////////////////////////////////////
// SpecifyAppsUsingClass
//////////////////////////////////////
BOOL SpecifyAppsUsingClass(HWND hDlg, HINSTANCE hTempInst)
{
  TASKENTRY Task;
  BOOL Result = TRUE;

  HWND hLBWnd = GetDlgItem(hDlg, ID_CLASSWINSTYLE);
  ListBox_ResetContent(hLBWnd);
  Task.dwSize = sizeof(TASKENTRY);
  TaskFirst(&Task);
  while (Result)
  {
    if (hTempInst == Task.hModule)
      ListBox_AddString(hLBWnd, Task.szModule);
    Result = TaskNext(&Task);
  }
  return TRUE;
}

//////////////////////////////////////
// FillClassBox
//////////////////////////////////////
BOOL FillClassBox(HWND hDlg, LPSTR S)
{
  WNDCLASS WndClass;
  HINSTANCE hTempInst;
  hTempInst = GetClassInstance(S);
  GetClassInfo(hTempInst, S, &WndClass);
  SetClassStyles(hDlg,  WndClass.style);
  SpecifyAppsUsingClass(hDlg, hTempInst);
  return TRUE;
}

//////////////////////////////////////
// The SysInfo Class Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK ClassDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  int Index;
  char S[100];


  switch(Message)
  {
    case WM_INITDIALOG:
    {
      SetClassContents(hDlg);
      ListBox_SetCurSel(GetDlgItem(hDlg, ID_CLASSLISTBOX), 0);
      HWND hLBWnd = GetDlgItem(hDlg, ID_CLASSWINSTYLE);
      SetWindowFont(hLBWnd, GetStockFont(ANSI_FIXED_FONT), 0);
      hLBWnd = GetDlgItem(hDlg, ID_CLASSSTYLE);
      SetWindowFont(hLBWnd, GetStockFont(ANSI_FIXED_FONT), 0);
      return TRUE;
    }

    case WM_CTLCOLOR:
      return HandleSysColor(wParam, lParam);

    case WM_COMMAND:
      switch (wParam)
      {
        case IDOK:
        case IDCANCEL:
          EndDialog(hDlg, TRUE);
          return TRUE;

        case
          ID_CLASSLISTBOX:
          {
            if (HIWORD(lParam) == LBN_SELCHANGE)
            {
              HWND hListBox = (HWND)LOWORD(lParam);
              Index = ListBox_GetCurSel(hListBox);

              strcpy(S, "Trouble");
              if (Index != LB_ERR)
              {
                ListBox_GetText(hListBox, Index, S);
                FillClassBox(hDlg, S);
              }
            }
            return TRUE;
          }
      }

      break;
  }
  return FALSE;
}
