//////////////////////////////////////
//  Program Name: SYSINFO.CPP
//  Programmer: Charlie Calvert
//  Description: What I did on my system's vacation
//  Date: 08/09/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <toolhelp.h>
#include <stdio.h>
#include <string.h>
#include "SysInfo.h"

#pragma warning (disable: 4068)
#pragma warning (disable: 4100)

// ----------------------------------------
// Interface
// ----------------------------------------

static char szAppName[] = "SysInfo";
static HWND MainWindow;
static HINSTANCE hInstance;
HBRUSH BlueBrush;

// ----------------------------------------
// Initialization
// ----------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR  lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style           = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc     = WndProc;
  WndClass.cbClsExtra     = 0;
  WndClass.cbWndExtra     = 0;
  WndClass.hInstance      = hInst;
  WndClass.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor        = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground  = GetStockBrush(LTGRAY_BRUSH);
  WndClass.lpszMenuName    = "MENU_1";
  WndClass.lpszClassName  = szAppName;

  return RegisterClass (&WndClass);
}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
#pragma argsused
HWND Create(HINSTANCE hInst, int nCmdShow)
{
  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_OVERLAPPEDWINDOW,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInstance, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// ---------------------------------------
// WndProc and Implementation
// ---------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hWindow, UINT Message,
                                 WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hWindow, WM_CREATE, SysInfo_OnCreate);
    HANDLE_MSG(hWindow, WM_DESTROY, SysInfo_OnDestroy);
    HANDLE_MSG(hWindow, WM_COMMAND, SysInfo_OnCommand);
    HANDLE_MSG(hWindow, WM_PAINT, SysInfo_OnPaint);
    default: return SysInfo_DefProc(hWindow, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_CREATE
//////////////////////////////////////
#pragma argsused
BOOL SysInfo_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{
  BlueBrush = CreateSolidBrush(RGB(0, 0, 255));
  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void SysInfo_OnDestroy(HWND hwnd)
{
  DeleteBrush(BlueBrush);
  PostQuitMessage(0);
}

#pragma argsused
void SysInfo_OnCommand(HWND hwnd, int id,
                       HWND hwndCtl, UINT codeNotify)
{
  switch(id)
  {
    case CM_ABOUT:
    {
      FARPROC AboutBox = MakeProcInstance((FARPROC)AboutDlgProc, hInstance);
      DialogBox(hInstance, "About", hwnd, (DLGPROC)AboutBox);
      FreeProcInstance(AboutBox);
      break;
    }

    case CM_CLASS:
    {
      FARPROC ClassBox = MakeProcInstance((FARPROC)ClassDlgProc, hInstance);
      DialogBox(hInstance, "ClassList", hwnd, (DLGPROC)ClassBox);
      FreeProcInstance(ClassBox);
      break;
    }

    case CM_GDIWALK:
    {
      FARPROC LocalWalk = MakeProcInstance((FARPROC)LocalDlgProc, hInstance);
      DialogBox(hInstance, "LocalWalk", hwnd, (DLGPROC)LocalWalk);
      FreeProcInstance(LocalWalk);
      break;
    }

    case CM_MODULE:
    {
      FARPROC ModuleBox = MakeProcInstance((FARPROC)ModuleDlgProc, hInstance);
      DialogBox(hInstance, "ModuleList", hwnd, (DLGPROC)ModuleBox);
      FreeProcInstance(ModuleBox);
      break;
    }

    case CM_TASK:
    {
      FARPROC TaskBox = MakeProcInstance((FARPROC)TaskDlgProc,
                                           hInstance);
      DialogBox(hInstance, "TaskList", hwnd, (DLGPROC)TaskBox);
      FreeProcInstance(TaskBox);
      break;
    }
  }
}

void SystemOutLine(HDC PaintDC, int Y)
{
  int len;
  int YInc = 25;
  char S[100];
  DWORD dwFlags;

  dwFlags = GetWinFlags();

  len = sprintf(S, "This is an %s system.",
    (dwFlags & WF_CPU286) ? "80286" :
    (dwFlags & WF_CPU386) ? "80386" :
    (dwFlags & WF_CPU486) ? "80486" : "unknown");
  TextOut(PaintDC, 10, Y + YInc, S, len);

  len = sprintf(S, "A coprocessor is %s ",
    (dwFlags & WF_80x87) ? "present" : "not present");
  TextOut(PaintDC, 10, Y + 2 * YInc, S, len);

  len = sprintf(S, "Mode: %s",
    (dwFlags & WF_ENHANCED) ? "Enhanced" : "Standard");
  TextOut(PaintDC, 10, Y + 3 * YInc, S, len);

  len = sprintf(S, "Paging is %s",
     (dwFlags & WF_PAGING) ? "available" : "unavailable");
  TextOut(PaintDC, 10, Y +  4 * YInc, S, len);
}

//////////////////////////////////////
// Handle WM_PAINT
//////////////////////////////////////
void SysInfo_OnPaint(HWND hwnd)
{
  HDC PaintDC;
  PAINTSTRUCT PaintStruct;
  SYSHEAPINFO Info;
  char S[100];

  Info.dwSize = sizeof(SYSHEAPINFO);
  SystemHeapInfo(&Info);
  DWORD FreeSpace = GetFreeSpace(0) / 1024;

  PaintDC = BeginPaint(hwnd, &PaintStruct);
  SetBkMode(PaintDC, TRANSPARENT);
  sprintf(S, "Percent free in the USER heap: %d",
          Info.wUserFreePercent);
  TextOut(PaintDC, 10, 10, S, strlen(S));
  sprintf(S, "Percent free in the GDI heap: %d",
          Info.wGDIFreePercent);
  TextOut(PaintDC, 10, 35, S, strlen(S));
  sprintf(S, "Kilobytes free on Global heap: %ld", FreeSpace);
  TextOut(PaintDC, 10, 60, S, strlen(S));

  SystemOutLine(PaintDC, 60);

  EndPaint(hwnd, &PaintStruct);
}

// -----------------------------------------------
// SysInfo Dialog
// -----------------------------------------------

//////////////////////////////////////
// The SysInfo Dialog Procedure
//////////////////////////////////////
#pragma argsused
BOOL CALLBACK AboutDlgProc(HWND hDlg, WORD Message,
                           WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    case WM_INITDIALOG:
      return TRUE;

    case WM_COMMAND:
      if (wParam == IDOK || wParam == IDCANCEL)
      {
        EndDialog(hDlg, TRUE);
        return TRUE;
      }
      break;
  }
  return FALSE;
}
