//////////////////////////////////////
//  Program Name: WINSTYLE.CPP
//  Programmer: Charlie Calvert
//  Description: WinStyle windows program
//  Date: 04/03/93
//////////////////////////////////////

#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma warning (disable: 4068)
#pragma hdrstop
#include <string.h>
#include <stdlib.h>
#include "winstyle.h"
// -------------------------------------------------------
// Interface
// -------------------------------------------------------

static char szAppName[] = "WinStyle";
static char szChildName[] = "StyleChild";
static HWND MainWindow;
static HINSTANCE hInstance;


// -------------------------------------------------------
// Initialization
// -------------------------------------------------------

//////////////////////////////////////
// Program entry point
//////////////////////////////////////
#pragma argsused
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
                   LPSTR lpszCmdParam, int nCmdShow)
{
  MSG  Msg;

  if (!hPrevInstance)
    if (!Register(hInst))
      return FALSE;

  MainWindow = Create(hInst, nCmdShow);
  if (!MainWindow)
    return FALSE;

  while (GetMessage(&Msg, NULL, 0, 0))
  {
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
  }

  return Msg.wParam;
}

//////////////////////////////////////
// Register the window
//////////////////////////////////////
BOOL Register(HINSTANCE hInst)
{
  WNDCLASS WndClass;

  WndClass.style          = CS_HREDRAW | CS_VREDRAW;
  WndClass.lpfnWndProc    = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = hInst;
  WndClass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
  WndClass.hbrBackground = NULL;
  WndClass.lpszMenuName   = "MENU_1";
  WndClass.lpszClassName = szAppName;

  BOOL Result = RegisterClass (&WndClass);

  if (!Result)
    return FALSE;

  WndClass.lpfnWndProc    = ChildWndProc;
  WndClass.cbWndExtra    = sizeof(WORD);
  WndClass.hIcon         = NULL;
  WndClass.hCursor       = LoadCursor(NULL, IDC_IBEAM);
  WndClass.lpszMenuName   = NULL;
  WndClass.lpszClassName = szChildName;

  return RegisterClass (&WndClass);

}

//////////////////////////////////////
// Create the window
//////////////////////////////////////
HWND Create(HINSTANCE hInst, int nCmdShow)
{

  hInstance = hInst;

  HWND hWindow = CreateWindow(szAppName, szAppName,
                    WS_CAPTION | WS_MINIMIZEBOX | WS_THICKFRAME,
                    10, 150, CW_USEDEFAULT, CW_USEDEFAULT,
                    NULL, NULL, hInst, NULL);

  if (hWindow == NULL)
    return hWindow;

  ShowWindow(hWindow, nCmdShow);
  UpdateWindow(hWindow);

  return hWindow;
}

// ------------------------------------------------------
// WndProc and Implementation
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export WndProc(HWND hwnd, UINT Message,
                         WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_CREATE, WinStyle_OnCreate);
    HANDLE_MSG(hwnd, WM_DESTROY, WinStyle_OnDestroy);
    HANDLE_MSG(hwnd, WM_COMMAND, WinStyle_OnCommand);
    default:
      return WinStyle_DefProc(hwnd, Message, wParam, lParam);
  }
}


//////////////////////////////////////
// ArrangeWinds
//////////////////////////////////////
void ArrangeWinds(HWND hwnd)
{
  RECT R;

  int j = 0;

  for (int i = 0; i < 9; i++)
  {
    MoveWindow(ChildWindows[i], 10 + (j * 100),
               10, 100, 100, TRUE);
    if (i == 4)
      j = 0;
    else
      j++;
  }

  GetWindowRect(hwnd, &R);

  MoveWindow(ChildWindows[i],
             R.left + 10 +
             GetSystemMetrics(SM_CXFRAME) + (j * 100),
             R.top + GetSystemMetrics(SM_CYCAPTION) +
             GetSystemMetrics(SM_CYFRAME) +
             GetSystemMetrics(SM_CYMENU) +
             10, 100, 100, TRUE);
}

//////////////////////////////////////
// Handle WM_Create
//////////////////////////////////////
#pragma argsused
BOOL WinStyle_OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
{

   Pattern1 = LoadBitmap(hInstance, "PATTERN1");
   if (!Pattern1)
     MessageBox(hwnd, "No Pattern", "Error", MB_OK);

   Pattern2 = LoadBitmap(hInstance, "PATTERN2");
   if (!Pattern2)
     MessageBox(hwnd, "No Pattern", "Error", MB_OK);

   Pattern3 = LoadBitmap(hInstance, "PATTERN3");
   if (!Pattern2)
     MessageBox(hwnd, "No Pattern", "Error", MB_OK);

   hPurpleHaze = CreateSolidBrush(RGB(127, 255, 255));

   SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);


   for (WORD i = 0; i < 9; i ++)
   {
     ChildWindows[i] = CreateWindow(szChildName, NULL, Styles[i],
                        0,0,0,0, hwnd, NULL, hInstance, NULL);
   }

   ChildWindows[i] = CreateWindow(szChildName, NULL, Styles[i],
                       0, 0, 0, 0, NULL, NULL, hInstance, NULL);


   hPurpleHaze = CreateSolidBrush(RGB(255, 255, 127));

   SetClassWord(ChildWindows[0], GCW_HBRBACKGROUND,
                (WORD)hPurpleHaze);

  for (i = 0; i < 10; i++)
    SetWindowWord(ChildWindows[i], 0, i);

  ArrangeWinds(hwnd);

  SetWindowText(ChildWindows[8], "Inactive");
  return TRUE;
}

//////////////////////////////////////
// Handle WM_DESTROY
//////////////////////////////////////
#pragma argsused
void WinStyle_OnDestroy(HWND hwnd)
{
  HBRUSH OldBrush;

  DeleteObject(Pattern1);
  DeleteObject(Pattern2);
  DeleteObject(Pattern3);

  OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
  SetClassWord(hwnd, GCW_HBRBACKGROUND,
              (WORD)GetStockObject(WHITE_BRUSH));
  DeleteBrush(OldBrush);

  PostQuitMessage(0);
}

//////////////////////////////////////
// Handle WM_COMMAND
//////////////////////////////////////
#pragma argsused;
void WinStyle_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT 
codeNotify)
{
  HBRUSH OldBrush;

  switch (id)
  {
    case CM_ARRANGE:
      ArrangeWinds(hwnd);

    case CM_WHISTLE:
      SetFocus(ChildWindows[9]);
      break;

    case CM_RED:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreateSolidBrush(RGB(255, 127, 127));
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_GREEN:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreateSolidBrush(RGB(127, 255, 127));
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_BLUE:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreateSolidBrush(RGB(127, 127, 255));
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SPECIAL1:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreatePatternBrush(Pattern1);
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SPECIAL2:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreatePatternBrush(Pattern2);
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_SPECIAL3:
      OldBrush = (HBRUSH)GetClassWord(hwnd, GCW_HBRBACKGROUND);
      hPurpleHaze = CreatePatternBrush(Pattern3);
      SetClassWord(hwnd, GCW_HBRBACKGROUND, (WORD)hPurpleHaze);
      DeleteBrush(OldBrush);
      InvalidateRect(hwnd, NULL, TRUE);
      break;

    case CM_EXIT:
      SendMessage(ChildWindows[9], WM_CLOSE, 0, 0);

      OldBrush = (HBRUSH)GetClassWord(ChildWindows[0],
                                      GCW_HBRBACKGROUND);
      SetClassWord(ChildWindows[0], GCW_HBRBACKGROUND,
                   (WORD)GetStockObject(WHITE_BRUSH));
      DeleteBrush(OldBrush);

      DestroyWindow(hwnd);
      break;

    case CM_HELP:
      MessageBox(hwnd,
                "Click on child windows to see their style",
                "Help", MB_OK | MB_ICONASTERISK);
      break;
  }
}


// ------------------------------------------------------
// The StyleChild
// ------------------------------------------------------

//////////////////////////////////////
// The Window Procedure
//////////////////////////////////////
LRESULT CALLBACK _export ChildWndProc(HWND hwnd, UINT Message, 
                                      WPARAM wParam, LPARAM lParam)
{
  switch(Message)
  {
    HANDLE_MSG(hwnd, WM_LBUTTONDOWN, StyleChild_OnLButtonDown);
    HANDLE_MSG(hwnd, WM_PAINT, StyleChild_OnPaint);
    default:
      return StyleChild_DefProc(hwnd, Message, wParam, lParam);
  }
}

//////////////////////////////////////
// Handle WM_LBUTTONDOWN
//////////////////////////////////////
#pragma argsused
void StyleChild_OnLButtonDown(HWND hwnd, BOOL fDoubleClick,
                              int x, int y, UINT keyFlags)
{
  char szNum[100];

  WORD i = GetWindowWord(hwnd, 0);
  wsprintf(szNum, "Number: %d", i);
  MessageBox(hwnd, szStyles[i], szNum,
             MB_OK | MB_ICONINFORMATION);
}

//////////////////////////////////////
// Respond WM_PAINT
//////////////////////////////////////
void StyleChild_OnPaint(HWND hwnd)
{
  PAINTSTRUCT PaintStruct;
  HDC PaintDC;
  char lpszBuffer[100];
  RECT R;

  WORD i = GetWindowWord(hwnd, 0);
  wsprintf(lpszBuffer, "%d", i);

  PaintDC = BeginPaint(hwnd, &PaintStruct);

  SetTextColor(PaintDC, RGB(0, 0, 255));
  SetBkMode(PaintDC, TRANSPARENT);
  GetClientRect(hwnd, &R);
  DrawText(PaintDC, lpszBuffer, -1, &R,
           DT_SINGLELINE | DT_CENTER | DT_VCENTER);

  EndPaint(hwnd, &PaintStruct);
}
