//*******************************************************************
//
// program - Dinfo.c
// purpose - a Windows program to display directory utilization of a drive.
//
//*******************************************************************

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include <alloc.h>


#include "wdinfo.h"


// Data that can be referenced throughout the
// program but not passed to other instances

HWND      hwndMainDialog ;
HWND      hwndMainWin ;
HWND      hMain ;           // main window handle
HWND      hWnd ;
HMENU     hMenu ;
HWND hAbout ;

HANDLE    hdlgr ;       // i think it is handle of dialog like hMain
HANDLE    hInst ;                             // hInstance of application
HANDLE    hAccel ;
static HWND hList ;
static HWND hDirs ;
static WORD W_ItemCnt ;

LOGFONT   cursfont;                           // font structure
HANDLE    holdsfont;                          // handle of original font
HANDLE    hnewsfont;                          // handle of new fixed font

FARPROC   lpMainDlgProc ;

char      DriveId[30] ;
char      DriveSel ;
int       driveln ;

int       baselo, basehi ;

int       xChar, yChar, yCharnl;              // character size
int       hMainWin, wMainWin ;                // height and width of Main Win
static int Num_Dir ;

// function prototypes

long FAR PASCAL MainWndProc(HWND hWnd, WORD message,
                             WORD wParam, LONG lParam);

BOOL FAR PASCAL MainDlgProc(HWND hDlg, WORD message,
                               WORD wParam, LONG lParam);

void DinfoMain (void) ;

void MsgListAdd (void) ;

int logic(char *) ;

void CheckButton(char) ;

//*******************************************************************
// WinMain - Dinfo main
//
// paramaters:
//             hInstance     - The instance of this instance of this
//                             application.
//             hPrevInstance - The instance of the previous instance
//                             of this application. This will be 0
//                             if this is the first instance.
//             lpszCmdLine   - A long pointer to the command line that
//                             started this application.
//             cmdShow       - Indicates how the window is to be shown
//                             initially. ie. SW_SHOWNORMAL, SW_HIDE,
//                             SW_MIMIMIZE.
//
// returns:
//             wParam from last message.
//
//*******************************************************************
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpszCmdLine, int cmdShow)
{

    MSG   msg ;
    WNDCLASS wndclass ;
    HDC   hdc ;

    int  hght, width ;
    LONG baseunit ;


    typedef struct tagDLGTEMPLATE
    {
        long dtStyle ;
        BYTE dtItemCount ;
        int  dtX ;
        int  dtY ;
        int  dtCX ;
        int  dtCY ;
        char dtMenuName[] ;
        char dtClassName[] ;
        char dtCaptionText[] ;
    }   DLGTEMPLATE;
    DLGTEMPLATE FAR *dltp;

    // Define the window class for this application.
    if (!hPrevInstance)
     {
        wndclass.lpszClassName = "Dinfo:Main" ;
        wndclass.hInstance     = hInstance;
        wndclass.lpfnWndProc   = MainWndProc;
        wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
        wndclass.hIcon         = LoadIcon(hInstance, "SNAPSHOT");
        wndclass.lpszMenuName  = "WD_Menu" ;  // NULL ;
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
        wndclass.cbClsExtra    = 0;
        wndclass.cbWndExtra    = 0;

        // Register the class
        RegisterClass(&wndclass);
       }

    hInst = hInstance;       // save for use by window procs

    baseunit = GetDialogBaseUnits() ;
    baselo = LOWORD(baseunit) ;     // get x value for width
    basehi = HIWORD(baseunit) ;     // get y value for height
    width = ((262*baselo) / 4) ;
    hght = ((184*basehi) /8) ;

    // Create applications main window.
    hWnd = CreateWindow(
                  "Dinfo:Main",            // window class name
                  "Directory Information", // window title
                  WS_CAPTION |
                   WS_SYSMENU |
                   WS_VISIBLE |
                   WS_MINIMIZEBOX,
                  CW_USEDEFAULT,
                  0,
                  width,                   // CW_USEDEFAULT,
                  hght,                    // 0,
                  NULL,                    // no parent for this window
                  NULL,                    // use the class menu
                  hInstance,               // who created this window
                  NULL                     // no parms to pass on
                  );

    hwndMainWin = hWnd ;


    hAccel = LoadAccelerators(hInst, "WD_ACC") ;

    ShowWindow(hWnd, cmdShow) ;
    UpdateWindow(hWnd) ;

    while(GetMessage(&msg, NULL, 0, 0))
      {
       if (!TranslateAccelerator(hMain, hAccel, &msg))
         {
          TranslateMessage(&msg) ;
          DispatchMessage(&msg) ;
          }
       }
    return 0 ;

}


//*******************************************************************

//*******************************************************************
// MainWndProc - handles messages for this application
//
// paramaters:
//             hWnd          - The window handle for this message
//             message       - The message number
//             wParam        - The WORD parmater for this message
//             lParam        - The LONG parmater for this message
//
// returns:
//             depends on message.
//
//*******************************************************************
long FAR PASCAL MainWndProc(HWND hwnd, WORD wMsg,
                             WORD wParam, LONG lParam)
{
    HDC  hdc ;
    HWND thWnd ;
    TEXTMETRIC tm ;

    char drvchk ;
    char drv[5] ;
    int i, Xorig, Yorig, hght, width ;
    static HANDLE lhInst ;

    HANDLE hCursor ;

    switch (wMsg)
    {
        case WM_CREATE:
            hMain = hwnd ;


            // Get the display context.
            hdc = GetDC(hwnd);

            // Build fixed screen font. Needed to display columinar report.
            cursfont.lfHeight         =  0 ;
            cursfont.lfWidth          =  0 ;
            cursfont.lfEscapement     =  0 ;
            cursfont.lfOrientation    =  0 ;
            cursfont.lfWeight         =  FW_NORMAL;
            cursfont.lfItalic         =  FALSE;
            cursfont.lfUnderline      =  FALSE;
            cursfont.lfStrikeOut      =  FALSE;
            cursfont.lfCharSet        =  OEM_CHARSET;
            cursfont.lfOutPrecision   =  OUT_DEFAULT_PRECIS;
            cursfont.lfClipPrecision  =  CLIP_DEFAULT_PRECIS;
            cursfont.lfQuality        =  DEFAULT_QUALITY;
            cursfont.lfPitchAndFamily =  FIXED_PITCH | FF_DONTCARE ;
            strcpy(cursfont.lfFaceName, "Terminal");

            hnewsfont = CreateFontIndirect((LPLOGFONT) &cursfont);

            // Install the font in the current display context.
            holdsfont = SelectObject(hdc, hnewsfont);

            // get text metrics for paint
            GetTextMetrics(hdc, &tm);
            xChar = tm.tmAveCharWidth;
            yChar = tm.tmHeight + tm.tmExternalLeading;
            yCharnl = tm.tmHeight;

            // Release the display context.
            ReleaseDC(hwnd, hdc);

            lhInst = ((LPCREATESTRUCT) lParam) -> hInstance ;
            lpMainDlgProc = MakeProcInstance(MainDlgProc, lhInst);

            Xorig = ((66*baselo) / 4) ;
            Yorig = ((3*basehi) /8) ;
            width = ((40*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Accept Button
            thWnd = CreateWindow(
                                "BUTTON",         // window class name
                                "&Accept",         // window title
                                 WS_VISIBLE    |
                                  WS_CHILD     |
                                  WS_TABSTOP   |
                                  BS_DEFPUSHBUTTON,
                                 Xorig,
                                 Yorig,
                                 width,
                                 hght,
                                 hwnd,            // parent for this window
                                 102,            // id for this window
                                 lhInst,          // who created this window
                                 NULL             // no parms to pass on
                                 );

            Xorig = ((111*baselo) / 4) ;
            Yorig = ((3*basehi) /8) ;
            width = ((40*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Clear Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "&Clear",           // window title
                                WS_VISIBLE    |
                                 WS_CHILD     |
                                 WS_TABSTOP,
                                Xorig,
                                Yorig,
                                width,
                                hght,
                                hwnd,              // parent for this window
                                103,               // id of window
                                lhInst,            // who created this window
                                NULL                     // no parms to pass on
                                );

            Xorig = ((156*baselo) / 4) ;
            Yorig = ((3*basehi) /8) ;
            width = ((40*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Cancel Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "E&Xit",          // window title
                                WS_VISIBLE    |
                                 WS_CHILD     |
                                 WS_TABSTOP,
                                Xorig,
                                Yorig,
                                width,
                                hght,
                                hwnd,              // parent for this window
                                104,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((1*baselo) / 4) ;
            Yorig = ((46*basehi) /8) ;
            width = ((256*baselo) / 4) ;
            hght =  ((113*basehi) /8) ;

            // Create Cancel Button
            thWnd = CreateWindow(
                                "LISTBOX",         // window class name
                                NULL,              // window title
                                WS_VISIBLE    |
                                 WS_CHILD     |
                                 WS_VSCROLL   |
                                 WS_HSCROLL   |
                                 WS_BORDER,
                                Xorig,
                                Yorig,
                                width,
                                hght,
                                hwnd,              // parent for this window
                                101,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );
            hList = thWnd ;

            Xorig = ((4*baselo) / 4) ;
            Yorig = ((24*basehi) /8) ;
            width = ((33*baselo) / 4) ;
            hght =  ((11*basehi) /8) ;

            // Create Drv Button
            thWnd = CreateWindow(
                                "STATIC",          // window class name
                                "Drives:",         // window title
                                WS_VISIBLE | WS_CHILD,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                105,            // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((32*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Drv Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                W_Drv1,            // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((56*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                107,            // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((80*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                108,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((104*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                109,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((128*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                110,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((152*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                111,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((176*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                112,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((200*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                113,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((224*baselo) / 4) ;
            Yorig = ((22*basehi) /8) ;
            width = ((18*baselo) / 4) ;
            hght =  ((12*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "BUTTON",          // window class name
                                "  ",              // window title
                                WS_CHILD | WS_TABSTOP |
                                 BS_AUTORADIOBUTTON,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                114,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((63*baselo) / 4) ;
            Yorig = ((34*basehi) /8) ;
            width = ((104*baselo) / 4) ;
            hght =  ((9*basehi) /8) ;

            // Create Cancel Button
            thWnd = CreateWindow(
                                "STATIC",          // window class name
                                "Directories Processed:",  // window title
                                WS_VISIBLE | WS_CHILD,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                115,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

            Xorig = ((148*baselo) / 4) ;
            Yorig = ((34*basehi) /8) ;
            width = ((27*baselo) / 4) ;
            hght =  ((9*basehi) /8) ;

            // Create Button
            thWnd = CreateWindow(
                                "STATIC",          // window class name
                                "",                // window title
                                WS_VISIBLE | WS_CHILD,
                                Xorig, Yorig,
                                width, hght,
                                hwnd,              // parent for this window
                                116,               // id of window
                                lhInst,            // who created this window
                                NULL               // no parms to pass on
                                );

//        hList = GetDlgItem(hwnd, W_List) ;  // get handle of list window

            SendMessage(hList, WM_SETFONT,
                        hnewsfont, FALSE);

            driveln = logic(DriveId) ;
            if (DriveId[0] != 0x00)
              {
               drv[2] = 0x00 ;

               if (driveln > 9)
                 {
                  driveln = 9 ;
                  DriveId[9] = 0x00 ;
                  }
               DriveSel = DriveId[0] ; // set default drive id to first
               for (i=0; i<driveln; i++)
                 {
                  sprintf(drv, "%c:", DriveId[i]) ;

                  thWnd = GetDlgItem(hwnd, W_Drv1 + i) ;
                  EnableWindow(thWnd, TRUE) ;
                  ShowWindow(thWnd, SW_SHOWNORMAL) ;

                  SetDlgItemText(hwnd, W_Drv1 + i, drv) ;
                  if (DriveId[i] == 'C')
                    {
                     DriveSel = DriveId[i] ;  // set default drive to C
                     CheckRadioButton(hwnd, W_Drv1, W_Drv9, W_Drv1 + i) ;
                     }
                  }
               }
              else
                {
                 MessageBox(NULL,"No Drives Found",NULL,MB_OK) ;
                 }

            break ;


        case WM_CLOSE:
            // Tell windows to destroy our window.
            DestroyWindow(hwnd);
            break;

        case WM_QUERYENDSESSION:
            // If we return TRUE we are saying it's ok with us to end the
            // windows session.
            return((long) TRUE);  // we agree to end session.

        case WM_DESTROY:
            // This is the end if we were closed by a DestroyWindow call.
            PostQuitMessage(0);
            break;

        case WM_COMMAND:
            switch(wParam)
            {
             case W_Accept:
                 W_ItemCnt = 0 ;
                 Num_Dir = 0 ;
                 SetDlgItemInt(hwnd, W_Dirs, Num_Dir, FALSE) ;

                 SendMessage(hList, LB_RESETCONTENT, 0, 0L) ;
                 UpdateWindow(hList) ;
                 InvalidateRect(hList, NULL, TRUE) ;

                 SendMessage(hList,WM_SETREDRAW, FALSE, 0L) ;
                 InvalidateRect(hList, NULL, TRUE) ;
                 UpdateWindow(hList) ;

//                 hCursor = LoadCursor(NULL, IDC_WAIT) ;
                 hCursor = LoadCursor(lhInst, "CLOCK") ;
                 SetCursor(hCursor) ;

                 DinfoMain() ;

                 hCursor = LoadCursor(NULL, IDC_ARROW) ;
                 SetCursor(hCursor) ;

                 SendMessage(hList,WM_SETREDRAW, TRUE, 0L) ;
                 InvalidateRect(hList, NULL, TRUE) ;
                 UpdateWindow(hList) ;

                 return TRUE ;

             case W_Clear:
                 W_ItemCnt = 0 ;
                 Num_Dir = 0 ;
                 SetDlgItemInt(hwnd, W_Dirs, Num_Dir, FALSE) ;
                 SendMessage(hList, LB_RESETCONTENT, 0, 0L) ;
                 InvalidateRect(hList, NULL, TRUE) ;
                 UpdateWindow(hList) ;
                 return TRUE ;


             case W_Cancel:
                 SendMessage(hwndMainWin, WM_CLOSE, 0, 0l) ;
                 break ;

             case W_Drv1:
             case W_Drv2:
             case W_Drv3:
             case W_Drv4:
             case W_Drv5:
             case W_Drv6:
             case W_Drv7:
             case W_Drv8:
             case W_Drv9:
                 i = wParam - W_Drv1 ;  // derive drive index
                 DriveSel = DriveId[i] ;  // derive drive id
                 CheckRadioButton(hwnd, W_Drv1, W_Drv9, wParam) ;
                 break ;

             case W_DrvA:
                 drvchk = 'A' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvB:
                 drvchk = 'B' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvC:
                 drvchk = 'C' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvD:
                 drvchk = 'D' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvE:
                 drvchk = 'E' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvF:
                 drvchk = 'F' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvG:
                 drvchk = 'G' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvH:
                 drvchk = 'H' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvI:
                 drvchk = 'I' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvJ:
                 drvchk = 'J' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvK:
                 drvchk = 'K' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvL:
                 drvchk = 'L' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvM:
                 drvchk = 'M' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvN:
                 drvchk = 'N' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvO:
                 drvchk = 'O' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvP:
                 drvchk = 'P' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvQ:
                 drvchk = 'Q' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvR:
                 drvchk = 'R' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvS:
                 drvchk = 'S' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvT:
                 drvchk = 'T' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvU:
                 drvchk = 'U' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvV:
                 drvchk = 'V' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvW:
                 drvchk = 'W' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvX:
                 drvchk = 'X' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvY:
                 drvchk = 'Y' ;
                 CheckButton(drvchk) ;
                 break ;
             case W_DrvZ:
                 drvchk = 'Z' ;
                 CheckButton(drvchk) ;
                 break ;

             case W_About:
                 DialogBox(lhInst, "About_Box", hwnd, lpMainDlgProc) ;
                 SetFocus(hAbout) ;
                 break ;
             }


        default:
            return(DefWindowProc(hwnd, wMsg, wParam, lParam));
    }

    return(0L);
}

//*******************************************************************

//*******************************************************************
// MainDlgProc - handle Main dialog messages (modeless)
//
// This is a modeless dialog box procedure that controls this
// entire application.
//
// paramaters:
//             hDlg          - The window handle for this message
//             message       - The message number
//             wParam        - The WORD parmater for this message
//             lParam        - The LONG parmater for this message
//
//*******************************************************************
BOOL FAR PASCAL MainDlgProc(HWND hDlg, WORD wMsg,
                               WORD wParam, LONG lParam)
{

    int  i, x, y, w, h ;
    char drv[5] ;



    static RECT   wrect;


    switch (wMsg)
    {
        case WM_INITDIALOG:
            hAbout = hDlg ;
            break ;

        case WM_MOVE:
            // Always keep this dialog box on top of main window.
            GetWindowRect(hwndMainWin, (LPRECT) &wrect);
            x = wrect.left;
            y = wrect.top;
            w = wrect.right - wrect.left;
            h = wrect.bottom - wrect.top;
            MoveWindow(hDlg, x, y, w, h, 1);
            break;

        case WM_COMMAND:
            switch(wParam)
            {
             case W_OK:                     // close out about box
                 EndDialog(hDlg, 0) ;
                 break ;
             }

        case WM_KEYDOWN:
            if (wParam == VK_RETURN)
              EndDialog(hDlg, 0) ;
            break ;


//        case WM_SYSCOMMAND:
           // send message out to window
//            SendMessage(hwndMainWin, wMsg, wParam, lParam) ;
//            break ;


        default:
            return FALSE;
    }

    return(TRUE);
}

//*******************************************************************

void CheckButton(char drv)
{
  int i ;
    for (i=0; i<driveln; i++)
       if (DriveId[i] == drv)
         {
          DriveSel = DriveId[i] ;  // set default drive to new drive
          CheckRadioButton(hMain, W_Drv1, W_Drv9, W_Drv1 + i) ;
          }
 }



int logic(char *buf)
{
  /*********************************************************
   *           VARIABLE DEFENITION                         *
   *********************************************************/

  char xchar;
  int save_current,i=0;

  /*********************************************************
   *           STUCTURE DEFENITION FOR REGISTERS           *
   *********************************************************/

  union REGS reg;
  struct SREGS sregs;


  /* Start of logic function */

  reg.h.ah = 0x19;                           /* DOS INT21 Function 0x19     */
  int86(0X21,&reg,&reg);                     /* Getting default drive       */
  save_current = reg.h.al;                   /* Save default drive          */

  for (xchar = 'A'; xchar <= 'Z'; xchar++){  /* For loop to locate valid    */
     reg.h.ah = 0x0E;                        /* logic parations using DOS   */
     reg.h.dl = xchar - 'A';                 /* INT21 function 0x0E & 0x19  */
     int86(0X21,&reg,&reg);
     reg.h.ah = 0X19;

//     intdosx(&reg,&reg,&sregs);
     int86(0x21,&reg,&reg) ;

     if(reg.h.al == reg.h.dl)              /* If register AL is the same as */
       buf[i++]=reg.h.al+'A';              /* requested drive, then logic   */
    } /* For loop end */                   /* drive exist, hence assign     */
                /* drive letter to buffer */

   buf[i]='\0';                            /* Termeniate buffer with nul  */
   reg.h.ah = 0x0E;                        /* Restore original default    */
   reg.h.dl = save_current;                /* drive                       */
   int86(0x21,&reg,&reg);
   return i;                               /* Return length of buf        */

 }  /* End of function logic */

/*********************************************************************/
/***********                                                **********/
/*********************************************************************/

/***************************************************************/
/*                                                             */
/*             written by: George Hulse  11/90                 */
/*                                                             */
/***************************************************************/
/*             compile with the COMPACT option                 */
/***************************************************************/

struct ffblk finfo;
#define dattr FA_DIREC ;
#define fattr FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_ARCH ;

typedef struct direntry {
                           char  name[13] ;
                           long  size ;
                           long  subsize ;
                           int   nest ;
                           GLOBALHANDLE subdirh ;
                           DWORD FAR subdir ;
                           GLOBALHANDLE parenth ;
                           DWORD FAR parent ;
                          } ;
typedef struct ptrelist {
                           GLOBALHANDLE ptrenth[100] ;
                           DWORD far ptrent[100] ;
                          } ;


void ParseSubs (struct direntry FAR *, GLOBALHANDLE) ;
void DrawTree (struct direntry FAR *, GLOBALHANDLE, int) ;
//void ParseSubs (struct direntry far *) ;
//void DrawTree (struct direntry far *, int) ;
void PlaceStr (char *, char *, int ) ;
void Nbrfmt(char *) ;
void Dir_Proc(void) ;


static long tot ;
static float pct, subpct, size, memalc ;
static char prtline[80] ;
static char workprt[30] ;
static int nestbar[100], busychr ;

static char Tree[3] ;

char bar[2], ltbar[2], hbar[2], lcorn[2], lucorn[2] ;

struct direntry  FAR *rootptr ;
GLOBALHANDLE roothndl ;

GLOBALHANDLE hGlobalMem ;


void DinfoMain ()
{     /*  start main code */
   int ptrindx, drive, maxdrv ;
   long d_avail, d_cap ;

   time_t t ;
   struct dfree free ;
   struct direntry far *parent ;
   struct ptrelist far *subdir ;

   GLOBALHANDLE parenth ;

//   char dirname[101] ;
//   char RESET[] = { 0x1b, 0x45, 0x00 } ;
//   char PC_8[]  = { 0x1b, 0x28, 0x31, 0x30, 0x55, 0x00 } ;
//   char FFeed[]  = { 0x0c, 0x00 } ;

   int i, j; //, HPLJ ;

//   HPLJ = 0 ;
   bar[0] = 0xb3 ;
   bar[1] = 0x00 ;

   ltbar[0] = 0xc3 ;
   ltbar[1] = 0x00 ;

   hbar[0] = 0xc4 ;
   hbar[1] = 0x00 ;

   lcorn[0] = 0xc0 ;
   lcorn[1] = 0x00 ;

   lucorn[0] = 0xda ;
   lucorn[1] = 0x00 ;

   busychr = 1 ;

   for (i = 0; i < 79; i++)
       prtline[i] = ' ' ;
   prtline[79] = 0x00 ;

/*********/
   Tree[0] = DriveSel ;
   Tree[1] = ':' ;
   Tree[2] = 0x00 ;
/*********/

//   if ( (rootptr = farmalloc(sizeof(struct direntry)) ) == NULL )

   hGlobalMem = GlobalAlloc(GMEM_MOVEABLE, sizeof(struct direntry)) ;
   roothndl = hGlobalMem ;
   if (hGlobalMem == NULL)
     {
       MessageBox(NULL,"Insufficient memory available for processing",
                 NULL,MB_OK) ;
       exit(1) ;
      }
   memalc = 0 ;
   memalc = memalc + sizeof(struct direntry) ;

   (DWORD FAR *) rootptr = (DWORD FAR *) GlobalLock(hGlobalMem) ;

   rootptr->name[0] = 0x00 ;
   rootptr->size = 0 ;
   rootptr->subsize = 0 ;
   rootptr->nest = 0 ;
   rootptr->subdir = NULL ;
   rootptr->subdirh = NULL ;
   rootptr->parent = NULL ;
   rootptr->parenth = NULL ;


   tot = 0 ;

   ParseSubs(rootptr,roothndl) ; /* start processing subdirs, including root*/

   busychr = 9 ;


   PlaceStr(prtline,"Bytes used on    disk: ",1) ;
   prtline[15] = DriveSel ;
   prtline[16] = ':' ;
   ltoa(tot,workprt,10) ;
   Nbrfmt(workprt) ;
   PlaceStr(prtline,workprt,24) ;
   t = time(NULL) ;
   strcpy(workprt,ctime(&t)) ;
   workprt[24] = 0x00 ;
   PlaceStr(prtline,workprt,40) ;
//   fprintf(fptr, "%s\n",prtline) ;

   MsgListAdd() ;

   MsgListAdd() ;

   getdfree((DriveSel-'A')+1, &free) ;
   if (free.df_sclus != 0xFFFF)
    {
       PlaceStr(prtline,"Bytes free on disk:    ",1) ;
       d_avail = (long) free.df_avail * (long) free.df_bsec *
                (long) free.df_sclus ;
       ltoa(d_avail,workprt,10) ;
         Nbrfmt(workprt) ;
       PlaceStr(prtline,workprt,24) ;

   //    fprintf(fptr, "%s\n",prtline) ;

       MsgListAdd() ;

       PlaceStr(prtline,"Disk capacity (bytes): ",1) ;
       d_cap = (long) free.df_total * (long) free.df_bsec *
                (long) free.df_sclus ;
       ltoa(d_cap,workprt,10) ;
         Nbrfmt(workprt) ;
       PlaceStr(prtline,workprt,24) ;

   //    fprintf(fptr, "%s\n",prtline) ;

       MsgListAdd() ;
      }

//   fprintf(fptr, "%s\n",prtline) ;

   MsgListAdd() ;

   strcpy(rootptr->name, "(root)" );
   size = rootptr->size ;
   pct = size / tot ;  /* get sub-dirs percentage of total */
   pct = pct* 100 ;    /* make percentage real */
   ltoa(rootptr->size,workprt,10) ;
   Nbrfmt(workprt) ;
   j = 2 ;
   PlaceStr(prtline,lucorn,j) ;
   PlaceStr(prtline,hbar,j+1) ;
   PlaceStr(prtline,rootptr->name,j+2) ;
   PlaceStr(prtline,workprt,j+12) ;
   sprintf(workprt,"%3.2f %%",pct) ;
   PlaceStr(prtline,workprt,j+29) ;

//   fprintf(fptr, "%s\n",prtline) ;

   MsgListAdd() ;


   ptrindx = 0 ;
   if (rootptr->subdir != NULL)
    {
      (DWORD FAR *)subdir = (DWORD FAR *) rootptr->subdir ;
      while (subdir->ptrent[ptrindx] != NULL)
       {
          (DWORD FAR *) parent = (DWORD FAR *) subdir->ptrent[ptrindx] ;
          parenth = subdir->ptrenth[ptrindx] ;
          if (subdir->ptrent[ptrindx+1] != NULL)
            {
             nestbar[0] = 1 ;
             DrawTree(parent,parenth,0) ;
             }
            else
            {
             nestbar[0] = 0 ;
             DrawTree(parent,parenth,1) ;
             }
          ptrindx = ptrindx + 1 ;
       }
    }

//   fprintf(fptr, "\n") ;
//   fprintf(fptr, "  (C) Copyright George Hulse, 1991\n") ;

//   farfree(rootptr) ;
   GlobalUnlock(roothndl) ;
   GlobalFree(roothndl) ;

   memalc = memalc / 1024 ;
//   printf("\n") ;
//   printf("%5.2f k bytes used for directory tree",memalc) ;

}     /*  end main code */

void ParseSubs(struct direntry FAR *parentd, GLOBALHANDLE parenth)
{
   struct direntry FAR *dirptr ;
   struct ptrelist FAR *subdir ;
   struct direntry FAR *parent ;

   GLOBALHANDLE parenth2 ;
   GLOBALHANDLE dirptrh ;

   char dirname[100], dirhold[100] ;
   int done, attr, i, j, ptrindx, attr2 ;

   Dir_Proc() ;

//  if ( (parentd->subdir = farmalloc(sizeof(struct ptrelist)) ) == NULL )

   hGlobalMem = GlobalAlloc(GMEM_MOVEABLE, sizeof(struct ptrelist)) ;
   parentd->subdirh = hGlobalMem ;
   if (hGlobalMem == NULL)
     {
       MessageBox(NULL,"Insufficient memory available for processing",
                 NULL,MB_OK) ;
//       exit(1) ;
      }

   (DWORD FAR *) parentd->subdir = (DWORD FAR *) GlobalLock(hGlobalMem) ;

   memalc = memalc + sizeof(struct ptrelist) ;
   dirname[0] = 0x00 ;
   dirhold[0] = 0x00 ;

   strcpy(dirname,parentd->name) ;
   (DWORD FAR *) parent = (DWORD FAR *) parentd->parent ;


   while (parent != NULL)
    {
      strcpy(dirhold,parent->name) ;
      if (parent->name[0] != 0x00)
        strcat(dirhold,"\\") ;
      strcat(dirhold,dirname) ;
      strcpy(dirname,dirhold) ;
      dirhold[0] = 0x00 ;
      (DWORD FAR *) dirptr = (DWORD FAR *) parent->parent ;
      parent = dirptr ;
     }

   strcpy(dirhold,Tree) ;
   strcat(dirhold,"\\") ;
   strcat(dirhold,dirname) ;
   if (strlen(dirhold) > 3)
     strcat(dirhold,"\\") ;
   strcat(dirhold,"*.*") ;
   strcpy(dirname,dirhold) ;

   ptrindx = 0 ;
   (DWORD FAR *) subdir = (DWORD FAR *) parentd->subdir ;
   subdir->ptrent[0] = NULL ;
   subdir->ptrenth[0] = NULL ;
   attr = dattr ;

   done = findfirst(dirname,&finfo,attr) ;
   while (!done)
    {
       if (finfo.ff_attrib == attr)
         {
          if (finfo.ff_name[0] != '.')
             {
//            if ( (dirptr = farmalloc(sizeof(struct direntry)) ) == NULL )

               hGlobalMem =
                     GlobalAlloc(GMEM_MOVEABLE, sizeof(struct direntry)) ;
               dirptrh = hGlobalMem ;
               if (hGlobalMem == NULL)
                 {
                   MessageBox(NULL,
                              "Insufficient memory available for processing",
                              NULL,MB_OK) ;
//                   exit(1) ;
                  }
                else
                {
                  (DWORD FAR *) dirptr = (DWORD FAR *) GlobalLock(hGlobalMem);
                  memalc = memalc + sizeof(struct direntry) ;
                  strcpy(dirptr->name,finfo.ff_name) ;
                  dirptr->size = 0 ;
                  dirptr->subsize = 0 ;
                  dirptr->nest = parentd->nest + 1 ;
                  (DWORD FAR *) dirptr->parent = (DWORD FAR *) parentd ;
                  dirptr->parenth = parenth ;
                  dirptr->subdir = NULL ;
                  dirptr->subdirh = NULL ;

                  subdir->ptrenth[ptrindx] = dirptrh ;
                  (DWORD FAR *) subdir->ptrent[ptrindx] =
                       (DWORD FAR *) dirptr ;

                  ptrindx = ptrindx + 1 ;
                  subdir->ptrent[ptrindx] = NULL ;
                  subdir->ptrenth[ptrindx] = NULL ;
                  }
            }
          }
       done = findnext(&finfo) ;
      }
   attr2 = fattr ;
   done = findfirst(dirname,&finfo,attr2) ;
   while (!done)
    {
       parentd->size = parentd->size + finfo.ff_fsize ;
       done = findnext(&finfo) ;
      }

   tot = tot + parentd->size ;

   ptrindx = 0 ;
   if (parentd->subdir != NULL)
    {
      (DWORD FAR *) subdir = (DWORD FAR *) parentd->subdir ;
      while (subdir->ptrent[ptrindx] != NULL)
       {
          (DWORD FAR *) parent = (DWORD FAR *) subdir->ptrent[ptrindx] ;
          parenth2 = subdir->ptrenth[ptrindx] ;
          ParseSubs(parent,parenth2) ;
          ptrindx = ptrindx + 1 ;
         }
   }

   (DWORD FAR *) parent = (DWORD FAR *) parentd->parent ;
   if (parent != NULL)
    parent->subsize = parent->subsize + parentd->size + parentd->subsize ;

}

void DrawTree(struct direntry FAR *parentd,
               GLOBALHANDLE parenth, int last)
{
   int i, j, ptrindx ;

   struct direntry FAR *parent ;
   struct ptrelist FAR *subdir ;

   GLOBALHANDLE parenth2 ;
   GLOBALHANDLE subdirh2 ;

   subpct = 0 ;
   size = parentd->size ;
   pct = size / tot ;  /* get sub-dirs percentage of total */
   pct = pct* 100 ;    /* make percentage real */
   if (parentd->subsize > 0)
      {
       size = size + parentd->subsize ;
       subpct = size / tot ; /* get sub-sub-dirs percentage of total */
       subpct = subpct* 100 ;  /* make percentage real */
       }
   ltoa(parentd->size,workprt,10) ;
   Nbrfmt(workprt) ;

   j = 2 ;     // starting position of bars
     for (i=1; i < parentd->nest ; i++)
    {
       if (nestbar[i] == 1)
       PlaceStr(prtline,bar,j) ;
       j = j + 2 ;
      }
   if (last == 0)
     {
      nestbar[parentd->nest] = 1 ;
    PlaceStr(prtline,ltbar,j) ;
     }
   else
     {
      nestbar[parentd->nest] = 0 ;
      PlaceStr(prtline,lcorn,j) ;
      }
   PlaceStr(prtline,hbar,j+1) ;
   PlaceStr(prtline,parentd->name,j+2) ;
   PlaceStr(prtline,workprt,j+12) ;
   sprintf(workprt,"%3.2f %%",pct) ;
   PlaceStr(prtline,workprt,j+27) ;    // was 29
   if (subpct > 0)
      {
       sprintf(workprt,"(%3.2f %%)",subpct) ;
       PlaceStr(prtline,workprt,j+37) ;   // was 39
       }

//   fprintf(fptr, "%s\n",prtline) ;

   MsgListAdd() ;

   ptrindx = 0 ;
   if (parentd->subdir != NULL)
     {
      (DWORD FAR *)subdir = (DWORD FAR *) parentd->subdir ;
      while (subdir->ptrent[ptrindx] != NULL)
        {
          (DWORD FAR *) parent = (DWORD FAR *) subdir->ptrent[ptrindx] ;
          parenth2 = subdir->ptrenth[ptrindx] ;
          if (subdir->ptrent[ptrindx+1] != NULL)
             DrawTree(parent,parenth,0) ;
            else
             DrawTree(parent,parenth2,1) ;

          hGlobalMem = parent->subdirh ;
          GlobalUnlock(hGlobalMem) ;
          GlobalFree(hGlobalMem) ;
          hGlobalMem = parenth2 ;
          GlobalUnlock(hGlobalMem) ;
          GlobalFree(hGlobalMem) ;

//          farfree(parent->subdir) ;
//          farfree(parent) ;
          ptrindx = ptrindx + 1 ;
         }
   }
}

void PlaceStr(char *dest, char *src, int ptr)
{
   int i, len ;

   i = 0 ;
   len = strlen(src) ;
   for (i = 0; i < len; i++)
    {
      dest[ptr] = src[i] ;
      ptr = ptr + 1 ;
      }
}

void Nbrfmt(char *src)
{
   int i, j, k, len ;
   char fmt[14] ;

   j = 13 ;
   for (i = 0; i <14; i++)
      fmt[i] = ' ' ;
   fmt[14] = 0x00 ;
   k = 0 ;
   len = strlen(src) ;
   for (i = len-1; i > -1; i--)
    {
      if (k == 3)
        {
         fmt[j] = ',' ;
         j = j - 1 ;
         k = 0 ;
         }
      fmt[j] = src[i] ;
      j = j - 1 ;
      k = k + 1 ;
      }
   for (i=0; i<14; i++)
      src[i] = fmt[i] ;
   src[14] = 0x00 ;
}

void MsgListAdd()
{
   int i ;
   long rc ;

   MSG msg ;

   for (i = 78; i > -1; i--)
     if (prtline[i] > ' ')
       {
        prtline[i+1] = 0x00 ;
        i = -1 ;
        }

//   rc = SendDlgItemMessage(hMain, W_List, LB_ADDSTRING, W_ItemCnt,
//                        (LONG) ((LPSTR) prtline)) ;

   rc = SendMessage(hList, LB_ADDSTRING, W_ItemCnt,
                        (LONG) ((LPSTR) prtline)) ;

   if (rc == LB_ERR || rc == LB_ERRSPACE)
     {
      MessageBox(NULL,"Insufficient memory available for processing",
                "* ERROR *",MB_ICONEXCLAMATION | MB_OK) ;
      }


   W_ItemCnt++ ;
   for (i = 0; i < 79; i++)
      prtline[i] = ' ' ;
   prtline[79] = 0x00 ;


}

void Dir_Proc()
{
   Num_Dir++ ;


     SetDlgItemInt(hMain, W_Dirs, Num_Dir, FALSE) ;

}
