
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL - Windows Enhanced Dialog Library                           */
/*          Copyright (c) 1991, Mike Smedley                                 */
/*          All Rights Reserved                                              */
/*          Module:  DEMO.C                                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wedl.h"
#include "demo.h"

/*---------------------------------------------------------------------------*/

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
                    int nCmdShow );
long FAR PASCAL MainWndProc( HWND hWnd, unsigned message, WORD wParam,
                             LONG lParam );
int FAR PASCAL AboutDlgProc( HWND hDlg, unsigned message, WORD wParam,
                             LONG lParam );
static BOOL okay_to_quit( void );

/*---------------------------------------------------------------------------*/

static HANDLE hInst;
static char szClassName[] = "WEDL_DEMO";
int (FAR PASCAL *pcheck_date) (LPSTR);
int (FAR PASCAL *pcheck_state) (LPSTR);
int (FAR PASCAL *pcheck_zip_code) (LPSTR);
int (FAR PASCAL *pcheck_file_name) (LPSTR);
char tbuf[512];

/*---------------------------------------------------------------------------*/

#if defined(__BORLANDC__)
#pragma warn -par
#endif

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine,
                    int nCmdShow )
{
    HWND hWnd;
    WNDCLASS wc;
    MSG msg;

    hInst = hInstance;

    if( !hPrevInstance ) {

        wc.style         = NULL;
        wc.lpfnWndProc   = ( LONG (FAR PASCAL *)() ) MainWndProc;
        wc.cbClsExtra    = 0;
        wc.cbWndExtra    = 0;
        wc.hInstance     = hInstance;
        wc.hIcon         = LoadIcon( hInstance, "WEDLIcon" );
        wc.hCursor       = LoadCursor( NULL, IDC_ARROW );
        wc.hbrBackground = GetStockObject( WHITE_BRUSH );
        wc.lpszMenuName  = "MainMenu";
        wc.lpszClassName = szClassName;

        if( !RegisterClass( &wc ) ) return( FALSE );

    }

    hWnd = CreateWindow( szClassName, "WEDL Demonstration Program",
                         WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                         CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance,
                         NULL );

    ShowWindow( hWnd, nCmdShow );
    UpdateWindow( hWnd );

    while( GetMessage( &msg, NULL, 0, 0 ) ) {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }

    return( msg.wParam );
}

#if defined(__BORLANDC__)
#pragma warn +par
#endif

/*---------------------------------------------------------------------------*/

long FAR PASCAL MainWndProc( HWND hWnd, unsigned message, WORD wParam,
                             LONG lParam )
{
    FARPROC pdialog_proc;

    switch( message ) {

        case WM_COMMAND:
            switch( wParam ) {
                case IDM_DIALOG1:
                    pdialog_proc    = MakeProcInstance( DialogProc1,    hInst );
                    pcheck_date     = MakeProcInstance( check_date,     hInst );
                    pcheck_state    = MakeProcInstance( check_state,    hInst );
                    pcheck_zip_code = MakeProcInstance( check_zip_code, hInst );
                    DialogBox( hInst, "DIALOG_1", hWnd, pdialog_proc );
                    FreeProcInstance( pcheck_zip_code );
                    FreeProcInstance( pcheck_state    );
                    FreeProcInstance( pcheck_date     );
                    FreeProcInstance( pdialog_proc    );
                    break;
                case IDM_DIALOG2:
                    pdialog_proc = MakeProcInstance( DialogProc2, hInst );
                    DialogBox( hInst, "DIALOG_2", hWnd, pdialog_proc );
                    FreeProcInstance( pdialog_proc );
                    break;
                case IDM_DIALOG3:
                    pdialog_proc     = MakeProcInstance( DialogProc3,     hInst );
                    pcheck_file_name = MakeProcInstance( check_file_name, hInst );
                    DialogBox( hInst, "DIALOG_3", hWnd, pdialog_proc );
                    FreeProcInstance( pcheck_file_name );
                    FreeProcInstance( pdialog_proc     );
                    break;
                case IDM_DIALOG4:
                    pdialog_proc = MakeProcInstance( DialogProc4, hInst );
                    DialogBox( hInst, "DIALOG_4", hWnd, pdialog_proc );
                    FreeProcInstance( pdialog_proc );
                    break;
                case IDM_EXIT:
                    SendMessage( hWnd, WM_CLOSE, 0, 0L );
                    break;
                case IDM_ABOUT:
                    pdialog_proc = MakeProcInstance( AboutDlgProc, hInst );
                    DialogBox( hInst, "AboutWEDL", hWnd, pdialog_proc );
                    FreeProcInstance( pdialog_proc );
                    break;
            }
            break;

        case WM_QUERYENDSESSION:
            return( okay_to_quit() );

        case WM_CLOSE:
            if( !okay_to_quit() ) break;
            /* fall through to default */

        default:
            return( DefWindowProc( hWnd, message, wParam, lParam ) );
    }
    return( 0L );
}

/*---------------------------------------------------------------------------*/

#if defined(__BORLANDC__)
#pragma warn -par
#endif

int FAR PASCAL AboutDlgProc( HWND hDlg, unsigned message, WORD wParam,
                             LONG lParam )
{
    switch( message ) {
        case WM_INITDIALOG:
            return( TRUE );
        case WM_COMMAND:
            if( wParam == IDOK || wParam == IDCANCEL ) {
                EndDialog( hDlg, TRUE );
                return( TRUE );
            }
            break;
    }
    return( FALSE );
}

#if defined(__BORLANDC__)
#pragma warn +par
#endif

/*---------------------------------------------------------------------------*/

static BOOL okay_to_quit( void )
{
    return( MessageBox( NULL, "Quit, are you sure?", "WEDL Demo",
                        MB_ICONQUESTION | MB_YESNO ) == IDYES );
}

