
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL - Windows Enhanced Dialog Library                           */
/*          Copyright (c) 1991, Mike Smedley                                 */
/*          All Rights Reserved                                              */
/*          Module:  DEMO1.C                                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "wedl.h"
#include "demo.h"
#include "demohelp.h"

/*---------------------------------------------------------------------------*/

static void update_date_text( HFORM hform );

/*---------------------------------------------------------------------------*/

struct states_t {
    PSTR state_code;
    int zip_low;
    int zip_high;
};

static struct states_t states[] = {
    { "AK", 995, 999 },     /* Alaska               */
    { "AL", 350, 369 },     /* Alabama              */
    { "AR", 716, 729 },     /* Arkansas             */
    { "AZ", 850, 865 },     /* Arizona              */
    { "CA", 900, 961 },     /* California           */
    { "CO", 800, 816 },     /* Colorado             */
    { "CT",  60,  69 },     /* Connecticut          */
    { "DE", 197, 199 },     /* Delaware             */
    { "FL", 320, 349 },     /* Florida              */
    { "GA", 300, 319 },     /* Georgia              */
    { "HI", 967, 968 },     /* Hawaii               */
    { "IA", 500, 528 },     /* Iowa                 */
    { "ID", 832, 847 },     /* Idaho                */
    { "IL", 600, 629 },     /* Illinois             */
    { "IN", 460, 479 },     /* Indiana              */
    { "KS", 641, 679 },     /* Kansas               */
    { "KY", 400, 427 },     /* Kentucky             */
    { "LA", 700, 714 },     /* Louisiana            */
    { "MA",  10,  27 },     /* Massachusetts        */
    { "MD", 206, 219 },     /* Maryland             */
    { "ME",  39,  49 },     /* Maine                */
    { "MI", 480, 499 },     /* Michigan             */
    { "MN", 550, 567 },     /* Minnesota            */
    { "MO", 630, 658 },     /* Missouri             */
    { "MS", 386, 397 },     /* Mississippi          */
    { "MT", 590, 599 },     /* Montana              */
    { "NC", 270, 289 },     /* North Carolina       */
    { "ND", 580, 588 },     /* North Dakota         */
    { "NE", 680, 693 },     /* Nebraska             */
    { "NH",  30,  38 },     /* New Hampshire        */
    { "NJ",  70,  89 },     /* New Jersey           */
    { "NM", 870, 884 },     /* New Mexico           */
    { "NV", 889, 898 },     /* Nevada               */
    { "NY", 100, 149 },     /* New York             */
    { "OH", 430, 458 },     /* Ohio                 */
    { "OK", 730, 749 },     /* Oklahoma             */
    { "OR", 970, 979 },     /* Oregon               */
    { "PA", 150, 196 },     /* Pennsylvania         */
    { "RI",  27,  29 },     /* Rhode Island         */
    { "SC", 290, 299 },     /* South Carolina       */
    { "SD", 570, 577 },     /* South Dakota         */
    { "TN", 370, 385 },     /* Tennessee            */
    { "TX", 750, 885 },     /* Texas                */
    { "UT", 840, 847 },     /* Utah                 */
    { "VA", 220, 246 },     /* Virginia             */
    { "VT",  50,  59 },     /* Vermont              */
    { "WA", 980, 994 },     /* Washington           */
    { "WI", 530, 549 },     /* Wisconsin            */
    { "WV", 247, 268 },     /* West Virginia        */
    { "WY", 820, 831 },     /* Wyoming              */
    { "DC", 200, 205 },     /* District of Columbia */
    { "GU",   0, 999 },     /* Guam                 */
    { "PR",   0, 999 },     /* Puerto Rico          */
    { "VI",   0, 999 },     /* Virgin Islands       */
    { "ON",   0, 999 },     /* Ontario              */
    { "PQ",   0, 999 },     /* Quebec               */
    { "BC",   0, 999 },     /* British Columbia     */
    { "AB",   0, 999 },     /* Alberta              */
    { "SK",   0, 999 },     /* Saskatchewan         */
    { "MB",   0, 999 },     /* Manitoba             */
    { "NS",   0, 999 },     /* Nova Scotia          */
    { "NB",   0, 999 },     /* New Brunswick        */
    { "NF",   0, 999 },     /* Newfoundland         */
    { "PE",   0, 999 },     /* Prince Edward Island */
    { NULL,   0,   0 }      /* --- end of table --- */
};

char zip_error_msg1[] = "Zip Code is incomplete";
char zip_error_msg2[] = "Zip Code is invalid for given State";
PSTR pzip_error_msg;

/*---------------------------------------------------------------------------*/

static PSTR months[] = {
    NULL, "January", "February", "March", "April", "May", "June", "July",
    "August", "September", "October", "November", "December"
};

/*---------------------------------------------------------------------------*/

int FAR PASCAL DialogProc1( HWND hDlg, unsigned message, WORD wParam,
                            LONG lParam )
{
    static HFORM hform = NULL;
    static char first_name[16]="", mid_init[2]="", last_name[21]="";
    static char address[31]="", city[16]="", state[3]="", zip_code[10]="";
    static char soc_sec_no[10]="", phone_num[11]="", hire_date[9]="  /  /  ";

    switch( message ) {
        case WM_INITDIALOG:
            hform = form_begin( hDlg );
            form_set_help( hform, "demohelp.hlp" );
            field_define( hform, ID_SSN, soc_sec_no, DT_STRING,
                          "<0..7>99'-'99'-'9(4)",
                          FDF_NOTBLANK | FDF_UPDATE | FDF_COMPLETE,
                          NULL, 0, HELPID_SSN );
            field_define( hform, ID_FNAME, first_name, DT_STRING,
                          "A(15)", FDF_CONDUPD | FDF_MIXED,
                          NULL, 0, HELPID_FNAME );
            field_define( hform, ID_MIDINIT, mid_init, DT_STRING,
                          "A(1)'.'", FDF_UPDATE | FDF_UPPER,
                          NULL, 0, HELPID_MIDINIT );
            field_define( hform, ID_LNAME, last_name, DT_STRING,
                          "<A..Z>A(19)", FDF_CONDUPD | FDF_MIXED,
                          NULL, 0, HELPID_LNAME );
            field_define( hform, ID_ADDRESS, address, DT_STRING,
                          "?(30)", FDF_UPDATE | FDF_MIXED,
                          NULL, 0, HELPID_ADDRESS );
            field_define( hform, ID_CITY, city, DT_STRING,
                          "?(15)", FDF_CONDUPD | FDF_MIXED,
                          NULL, 0, HELPID_CITY );
            field_define( hform, ID_STATE, state, DT_STRING,
                          "A(2)", FDF_COMPLETE | FDF_UPDATE | FDF_UPPER,
                          pcheck_state, BAD_STATE, HELPID_STATE );
            field_define( hform, ID_ZIP, zip_code, DT_STRING,
                          "<0..9>(5)'-'9(4)", FDF_UPDATE,
                          pcheck_zip_code, BAD_ZIP, HELPID_ZIP );
            field_define( hform, ID_PHONE, phone_num, DT_STRING,
                          "'('999') '999'-'9999", FDF_UPDATE | FDF_COMPLETE,
                          NULL, 0, HELPID_PHONE );
            field_define( hform, ID_HIREDATE, hire_date, DT_STRING,
                          " <01> 9 '/' <0123> 9 '/' <89> 9 ",
                          FDF_UPDATE | FDF_COMPLETE | FDF_RDPHYS | FDF_WRPHYS,
                          pcheck_date, BAD_DATE, HELPID_HIREDATE );
            statmsg_define( hform, ID_INSERT, SM_INSERT, "Insert: On", "Insert: Off" );
            form_end( hform );
            return( TRUE );

        case WM_COMMAND:
            dproc_enter_wm_command( hform, wParam, lParam );
            switch( wParam ) {
                case BAD_DATE:
                    dproc_enter_error( hform );
                    MessageBox( hDlg, "Date Is Invalid", NULL, MB_OK );
                    dproc_exit_error( hform, lParam );
                    return( TRUE );
                case BAD_STATE:
                    dproc_enter_error( hform );
                    MessageBox( hDlg, "Invalid State Code", NULL, MB_OK );
                    dproc_exit_error( hform, lParam );
                    return( TRUE );
                case BAD_ZIP:
                    dproc_enter_error( hform );
                    MessageBox( hDlg, pzip_error_msg, NULL, MB_OK );
                    dproc_exit_error( hform, lParam );
                    return( TRUE );
                case ID_HIREDATE:
                    if( HIWORD( lParam ) ==  EN_KILLFOCUS
                     && !form_in_error_cond( hform )
                     && !form_is_cancelled( hform ) ) {
                        update_date_text( hform );
                        return( TRUE );
                    }
                    break;
                case IDOK:
                    dproc_enter_idok( hform );
                    if( !form_in_error_cond( hform ) ) {
                        if( form_validate( hform ) != NULL ) break;
                        form_process( hform );
                        EndDialog( hDlg, TRUE );
                        form_terminate( hform );
                        wsprintf( tbuf,
                                  "Soc Sec No.\t= %s\n"
                                  "Name\t\t= %s %s. %s\n"
                                  "Address\t\t= %s\n"
                                  "\t\t= %s, %s %.5s-%s\n"
                                  "Phone No.\t= %s\n"
                                  "Hire Date\t= %s",
                                  (LPSTR) soc_sec_no,
                                  (LPSTR) first_name,
                                  (LPSTR) mid_init, (LPSTR) last_name,
                                  (LPSTR) address, (LPSTR) city,
                                  (LPSTR) state, (LPSTR) zip_code,
                                  (LPSTR) zip_code+5, (LPSTR) phone_num,
                                  (LPSTR) hire_date );
                        MessageBox( NULL, tbuf, "Field Contents", MB_OK );
                    }
                    return( TRUE );
                case IDCANCEL:
                    dproc_enter_idcancel( hform );
                    EndDialog( hDlg, TRUE );
                    form_terminate( hform );
                    return( TRUE );
            }
            break;
    }
    return( FALSE );
}

/*---------------------------------------------------------------------------*/

int FAR PASCAL check_date( LPSTR pbuf )
{
    char date[10];
    int month, day, year;

    if( !str_is_blank( pbuf ) ) {

        /* parse year, day, and month from buffer */
        lstrcpy( date, pbuf );
        year = 1900 + atoi( date+4 );
        *( date+4 ) = '\0';
        day = atoi( date+2 );
        *( date+2 ) = '\0';
        month = atoi( date );

        /* validate month */
        if( month > 12 ) return( 1 );

        /* validate day and month */
        if( day < 1 ) return( 3 );
        switch( month ) {
            case 2:
                if( year%4 )
                    if( day > 29 ) return( 3 );
                else
                    if( day > 28 ) return( 3 );
                break;
            case 1:
            case 3:
            case 5:
            case 7:
            case 8:
            case 10:
            case 12:
                if( day > 31 ) return( 3 );
                break;
            case 4:
            case 6:
            case 9:
            case 11:
                if( day > 30 ) return( 3 );
                break;
            default:
                return( 1 );
        }
    }

    /* return zero indicating no error */
    return( 0 );
}

/*---------------------------------------------------------------------------*/

int FAR PASCAL check_state( LPSTR pbuf )
{
    int i;

    /* allow state to be blank */
    if( str_is_blank( pbuf ) ) return( 0 );

    /* do for all state codes in the table */
    for( i = 0 ; states[i].state_code != NULL ; i++ )

        /* if state code was found, then no error */
        if( !lstrcmp( states[i].state_code, pbuf ) ) return( 0 );

    /* not a legal 2-letter state code */
    return( 1 );
}

/*---------------------------------------------------------------------------*/

int FAR PASCAL check_zip_code( LPSTR pbuf )
{
    HFORM hform;
    HFIELD hfield;
    LPSTR p;
    int i, num_spaces;
    long zip, zip_low, zip_high;

    /* allow zip code to be blank */
    if( str_is_blank( pbuf ) ) return( 0 );

    /* count spaces in the extended portion of the 9-digit zip code */
    num_spaces = 0;
    for( p = pbuf + 5 ; *p != '\0' ; p++ ) if( *p == ' ' ) num_spaces++;

    /* if zip code isn't exactly 5 or 9 digits, then there's an error */
    if( num_spaces != 0 && num_spaces != 4 ) {
        pzip_error_msg = zip_error_msg1;
        return( 6 );
    }

    *( pbuf+5 ) = '\0';
    hform = form_get_active();
    hfield = field_get_from_ctrl_id( hform, ID_ZIP );
    field_log_to_data( hfield, pbuf, &zip, DT_LONG );

    /* find matching state */
    hfield = field_get_from_ctrl_id( hform, ID_STATE );
    field_get_text( hfield, tbuf, FALSE );
    for( i = 0 ; states[i].state_code != NULL ; i++ ) {
        if( !lstrcmp( tbuf, states[i].state_code ) ) break;
    }
    if( states[i].state_code == NULL ) return( 0 );

    /* test zip code */
    zip_low  = ( (long) ( states[i].zip_low ) ) * 100L;
    zip_high = ( (long) ( states[i].zip_high ) ) * 100L;
    if( zip >= zip_low && zip <= zip_high ) return( 0 );
    pzip_error_msg = zip_error_msg2;
    return( 1 );
}

/*---------------------------------------------------------------------------*/

static void update_date_text( HFORM hform )
{
    LPFORM lpform;
    int day, month, year;
    char text[128], buf[9], date[10];

    field_get_text( field_get_from_ctrl_id( hform, ID_HIREDATE ), date, TRUE );

    lstrcpy( buf, date );
    year = 1900 + atoi( buf+6 );
    *( buf+5 ) = '\0';
    day = atoi( buf+3 );
    *( buf+2 ) = '\0';
    month = atoi( buf );

    if( month >= 1 && month <= 12 )
        wsprintf( text, "(%s %d, %d)", (LPSTR) months[ month ], day, year );
    else
        *text = '\0';

    lpform = form_lock( hform );
    SetDlgItemText( lpform->hdlg, ID_HIRETEXT, text );
    form_unlock( hform );
}

