
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL - Windows Enhanced Dialog Library                           */
/*          Copyright (c) 1991, Mike Smedley                                 */
/*          All Rights Reserved                                              */
/*          Module:  DEMO3.C                                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include "wedl.h"
#include "demo.h"
#include "demohelp.h"

/*---------------------------------------------------------------------------*/

static void fill_list_boxes( HWND hDlg, PSTR pathspec );

/*---------------------------------------------------------------------------*/

static PSTR protocols[] = { "Xmodem", "Ymodem", "Zmodem" };

/*---------------------------------------------------------------------------*/

int FAR PASCAL DialogProc3( HWND hDlg, unsigned message, WORD wParam,
                            LONG lParam )
{
    static HFORM hform = NULL;
    static int protocol = 0, hangup;
    static char path_spec[81], file_name[13];

    switch( message ) {
        case WM_INITDIALOG:
            hform = form_begin( hDlg );
            form_set_help( hform, "demohelp.hlp" );
            field_define( hform, ID_FILENAME, file_name, DT_STRING,
                          "F(12)", FDF_VAFFRM | FDF_NOTBLANK,
                          pcheck_file_name, BAD_FILENAME, HELPID_FILENAME );
            genctrl_define( hform, ID_FILEBOX, HELPID_FILEBOX );
            genctrl_define( hform, ID_DIRBOX, HELPID_DIRBOX );
            button_define( hform, ID_XMODEM, &protocol, 1, 0, 0,
                           BS_USEDATA, HELPID_XMODEM );
            button_define( hform, ID_YMODEM, &protocol, 1, 1, 0,
                           BS_USEDATA, HELPID_YMODEM );
            button_define( hform, ID_ZMODEM, &protocol, 1, 2, 0,
                           BS_USEDATA, HELPID_ZMODEM );
            button_define( hform, ID_HANGUP, &hangup, 0, TRUE, FALSE,
                           BS_OFF, HELPID_HANGUP );
            form_end( hform );
            fill_list_boxes( hDlg, "*.*" );
            return( TRUE );

        case WM_COMMAND:
            dproc_enter_wm_command( hform, wParam, lParam );
            switch( wParam ) {

                case IDOK:
                    dproc_enter_idok( hform );
                    if( !form_in_error_cond( hform ) ) {
                        if( form_validate( hform ) != NULL ) break;
                        form_process( hform );
                        GetDlgItemText( hDlg, ID_PATHSPEC, path_spec, 80 );
                        EndDialog( hDlg, TRUE );
                        form_terminate( hform );
                        wsprintf( tbuf, "Uploading the file:  %s%s%s\n"
                                  "Using the %s protocol.\n"
                                  "Will %shang up after transfer.",
                                  (LPSTR) path_spec,
                                  *( path_spec + lstrlen( path_spec ) - 1 )
                                  == '\\' ? (LPSTR) "" : (LPSTR) "\\",
                                  (LPSTR) file_name,
                                  (LPSTR) protocols[protocol],
                                  hangup ? (LPSTR) "" : (LPSTR) "not " );
                        MessageBox( NULL, tbuf, "Upload File", MB_OK );
                    }
                    return( TRUE );

                case IDCANCEL:
                    dproc_enter_idcancel( hform );
                    EndDialog( hDlg, TRUE );
                    form_terminate( hform );
                    return( TRUE );

                case BAD_FILENAME:
                    dproc_enter_error( hform );
                    MessageBox( hDlg, "File Not In Directory", NULL, MB_OK );
                    dproc_exit_error( hform, lParam );
                    return( TRUE );

                case ID_FILEBOX:
                    if( HIWORD( lParam ) == LBN_SELCHANGE ) {
                        SendDlgItemMessage( hDlg, ID_FILEBOX, LB_GETTEXT,
                                            (int) SendDlgItemMessage( hDlg,
                                            ID_FILEBOX, LB_GETCURSEL, 0, 0 ),
                                            (LONG) ( (LPSTR) tbuf ) );
                        SetDlgItemText( hDlg, ID_FILENAME, tbuf );
                        return( TRUE );
                    }
                    if( HIWORD( lParam ) == LBN_DBLCLK ) {
                        PostMessage( hDlg, WM_COMMAND, IDOK,
                                     (LONG) GetDlgItem( hDlg, IDOK ) );
                        return( TRUE );
                    }
                    break;

                case ID_DIRBOX:
                    if( HIWORD( lParam ) == LBN_DBLCLK ) {
                        DlgDirSelect( hDlg, path_spec, ID_DIRBOX );
                        SetDlgItemText( hDlg, ID_FILENAME, "" );
                        lstrcat( path_spec, "*.*" );
                        fill_list_boxes( hDlg, path_spec );
                        return( TRUE );
                    }
                    break;
            }
            break;
    }
    return( FALSE );
}

/*---------------------------------------------------------------------------*/

int FAR PASCAL check_file_name( LPSTR pbuf )
{
    char file_name[13];

    lstrcpy( file_name, pbuf );
    str_trim_spaces( file_name );
    return( ( SendDlgItemMessage( GetParent( GetFocus() ), ID_FILEBOX,
            LB_FINDSTRING, -1, (LONG) ( (LPSTR) file_name ) ) == LB_ERR )
            ? 1 : 0 );
}

/*---------------------------------------------------------------------------*/

static void fill_list_boxes( HWND hDlg, PSTR pathspec )
{
    DlgDirList( hDlg, pathspec, ID_FILEBOX, 0, 0x0001 | 0x0020 );
    DlgDirList( hDlg, pathspec, ID_DIRBOX, ID_PATHSPEC, 0x0010 | 0x4000 |
                0x8000 );
}

