
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL - Windows Enhanced Dialog Library                           */
/*          Copyright (c) 1991, Mike Smedley                                 */
/*          All Rights Reserved                                              */
/*          Module:  DEMO4.C                                                 */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include "wedl.h"
#include "demo.h"

/*---------------------------------------------------------------------------*/

int FAR PASCAL DialogProc4( HWND hDlg, unsigned message, WORD wParam,
                            LONG lParam )
{
    static HFORM hform = NULL;
    static char name[26]="", address[31]="", csz[36]="";
    static unsigned long ssn=0L;
    static double fitw=0.0, wages=0.0, sstax=0.0;

    switch( message ) {
        case WM_INITDIALOG:
            hform = form_begin( hDlg );
            field_define( hform, ID_NAME, name, DT_STRING, "?(25)",
                          FDF_NOTBLANK | FDF_UPDATE | FDF_MIXED, NULL, 0, 0 );
            field_define( hform, ID_ADDRESS, address, DT_STRING, "?(30)",
                          FDF_NOTBLANK | FDF_UPDATE | FDF_MIXED, NULL, 0, 0 );
            field_define( hform, ID_CSZ, csz, DT_STRING, "?(35)",
                          FDF_NOTBLANK | FDF_UPDATE | FDF_MIXED, NULL, 0, 0 );
            field_define( hform, ID_SSN, &ssn, DT_ULONG, "999'-'99'-'9999",
                          FDF_NOTBLANK | FDF_ZEROFILL | FDF_BLNKZERO |
                          FDF_UPDATE | FDF_NUMERIC, NULL, 0, 0 );
            field_define( hform, ID_FITW, &fitw, DT_DOUBLE, "'$ '9,999,999.99",
                          FDF_CALCNUM | FDF_UPDATE | FDF_MUSTEDIT, NULL, 0, 0 );
            field_define( hform, ID_WAGES, &wages, DT_DOUBLE, "'$ '9,999,999.99",
                          FDF_CALCNUM | FDF_UPDATE | FDF_MUSTEDIT, NULL, 0, 0 );
            field_define( hform, ID_SSTAX, &sstax, DT_DOUBLE, "'$ '9,999,999.99",
                          FDF_CALCNUM | FDF_UPDATE | FDF_MUSTEDIT, NULL, 0, 0 );
            statmsg_define( hform, ID_INSERT, SM_INSERT, "(Ins)", "(Ovr)" );
            form_end( hform );
            return( TRUE );

        case WM_COMMAND:
            dproc_enter_wm_command( hform, wParam, lParam );
            switch( wParam ) {

                case IDOK:
                    dproc_enter_idok( hform );
                    if( !form_in_error_cond( hform ) ) {
                        if( form_validate( hform ) != NULL ) break;
                        form_process( hform );
                        EndDialog( hDlg, TRUE );
                        form_terminate( hform );
                        sprintf( tbuf,
                                 "Name:\t= %s\nAddress\t= %s\n"
                                 "City, St\t= %s\n"
                                 "SSN:\t= %09lu\nFITW:\t= %.2lf\n"
                                 "Wages:\t= %.2lf\nSS Tax:\t= %.2lf\n",
                                 name, address, csz, ssn, fitw, wages, sstax );
                        MessageBox( NULL, tbuf, "Field Contents", MB_OK );
                    }
                    return( TRUE );

                case IDCANCEL:
                    dproc_enter_idcancel( hform );
                    EndDialog( hDlg, TRUE );
                    form_terminate( hform );
                    return( TRUE );

            }
            break;
    }
    return( FALSE );
}

