
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*          WEDL - Windows Enhanced Dialog Library                           */
/*          Copyright (c) 1991, Mike Smedley                                 */
/*          All Rights Reserved                                              */
/*          Module:  WEDL.H                                                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/

/* field feature definitions */

#define FDF_NONE        0L      /* no features specified                  */
#define FDF_COMPLETE    1L      /* field must be complete                 */
#define FDF_NOTBLANK    2L      /* field cannot be blank                  */
#define FDF_NOTZERO     4L      /* field cannot be zero                   */
#define FDF_NOTEDIT     8L      /* field cannot be edited                 */
#define FDF_MUSTEDIT    16L     /* field must be edited                   */
#define FDF_UPDATE      32L     /* update existing data                   */
#define FDF_CONDUPD     64L     /* conditionally update existing data     */
#define FDF_SPCFILL     128L    /* space-fill field from right            */
#define FDF_ZEROFILL    256L    /* zero-fill numeric field from left      */
#define FDF_BLNKZERO    512L    /* blank numeric field if equal to zero   */
#define FDF_RDPHYS      1024L   /* read 'pdata' in physical field format  */
#define FDF_WRPHYS      2048L   /* write 'pdata' in physical field format */
#define FDF_UPPER       4096L   /* convert characters to UPPERCASE        */
#define FDF_LOWER       8192L   /* convert characters to lowercase        */
#define FDF_MIXED       16384L  /* convert characters to Mixed Case       */
#define FDF_NUMERIC     32768L  /* standard numeric field                 */
#define FDF_CALCNUM     65536L  /* calculator-style numeric field         */
#define FDF_VAFFLD      131072L /* don't validate until user leaves field */
#define FDF_VAFFRM      262144L /* don't validate until user selects "OK" */
#define FDF_COMBO       524288L /* field belongs to a combo box           */

/*---------------------------------------------------------------------------*/

/* data type definitions */

#define DT_NULL         0       /* 'pdata' pointer == NULL      */
#define DT_STRING       1       /* character string             */
#define DT_INTEGER      2       /* signed integer               */
#define DT_UNSIGNED     3       /* unsigned integer             */
#define DT_LONG         4       /* signed long integer          */
#define DT_ULONG        5       /* unsigned long integer        */
#define DT_DOUBLE       6       /* double precision real number */

/*---------------------------------------------------------------------------*/

/* button state definitions */

#define BS_OFF          0       /* button is off (not checked)             */
#define BS_ON           1       /* button is on (checked)                  */
#define BS_GRAYED       2       /* a 3-state button is grayed (disabled)   */
#define BS_USEDATA      3       /* use value of data pointed to by 'pdata' */
#define BS_NOTSET       4       /* do not set state of button              */

/*---------------------------------------------------------------------------*/

/* status message definitions */

#define SM_INSERT       0       /* Insert key status message    */
#define SM_CAPSLOCK     1       /* CapsLock key status message  */
#define SM_NUMLOCK      2       /* NumLock key status message   */

/*---------------------------------------------------------------------------*/

typedef HANDLE  HFORM;          /* handle of a form's memory block     */
typedef HANDLE  HFIELD;         /* handle of a field's memory block    */
typedef HANDLE  HBUTTON;        /* handle of a button's memory block   */
typedef HBUTTON HGENCTRL;       /* handle of a generic control's block */

/*---------------------------------------------------------------------------*/

/* dialog control window procedure array info */

typedef struct {
    HWND hWnd;                  /* window handle of the dialog control   */
    FARPROC lpProc;             /* pointer to control's window procedure */
}  PROC_ARRAY_INFO;

/*---------------------------------------------------------------------------*/

/* definition of a field record */

typedef struct {
    HWND hwnd;                  /* field's window handle                     */
    HWND hcombo;                /* handle of combo box field belongs to      */
    HFIELD hfield;              /* field's memory handle                     */
    HFIELD hnext_field;         /* handle of next field in linked list       */
    int ctrl_id;                /* dialog control ID of edit control         */
    LPVOID pdata;               /* pointer to data type to write/update      */
    int data_type;              /* data type pointed to by 'data' parameter  */
    LPSTR picture_string;       /* pointer to the field picture string       */
    DWORD features;             /* field features                            */
    int (FAR PASCAL *pvalid_func) (LPSTR); /* procedure-instance address of  */
                                           /* field validation function      */
    int error_value;            /* error value to pass to dialog callback    */
    DWORD help_context;         /* help context ID of help topic for field   */
    BOOL has_changed;           /* flag - "field has changed"                */
    int logical_size;           /* logical size of field                     */
    int physical_size;          /* physical size of field                    */
    int decimal_position;       /* virtual logical position of decimal point */
} FIELD;

typedef FIELD *     PFIELD;
typedef FIELD FAR * LPFIELD;

/*---------------------------------------------------------------------------*/

/* field position information */

typedef struct {
    long selection;             /* selection                               */
    int physical_position;      /* physical position                       */
    int logical_position;       /* logical position                        */
    BOOL to_right_of_dec;       /* position is to the right of the decimal */
    LPSTR ppicture_str_pos;     /* pointer to picture string position      */
    int val_char_occ;           /* validation character occurrence         */
    char validation_char;       /* validation character for position       */
} FIELD_POS;

typedef FIELD_POS *     PFIELD_POS;
typedef FIELD_POS FAR * LPFIELD_POS;

/*---------------------------------------------------------------------------*/

/* definition of a form record */

typedef struct {
    HWND hdlg;                  /* form's dialog box window handle          */
    HFORM hform;                /* form's memory handle                     */
    HFORM hnext_form;           /* handle of next form in linked list       */
    HFIELD hhead_field;         /* handle of head node in field list        */
    HFIELD hcurr_field;         /* handle of current node in field list     */
    HBUTTON hhead_button;       /* handle of head node in button list       */
    HANDLE hproc_array;         /* handle of window procedure array         */
    int num_controls;           /* number of defined controls in form       */
    LPSTR help_file_name;       /* help file name                           */
    int insert_id;              /* control ID of Insert status message      */
    LPSTR insert_onmsg;         /* pointer to Insert "on" status message    */
    LPSTR insert_offmsg;        /* pointer to Insert "off" status message   */
    int capslock_id;            /* control ID of CapsLock status message    */
    LPSTR capslock_onmsg;       /* pointer to CapsLock "on" status message  */
    LPSTR capslock_offmsg;      /* pointer to CapsLock "off" status message */
    int numlock_id;             /* control ID of NumLock status message     */
    LPSTR numlock_onmsg;        /* pointer to NumLock "on" status message   */
    LPSTR numlock_offmsg;       /* pointer to NumLock "off" status message  */
    BOOL pressed_cancel;        /* flag - "Cancel was pressed"              */
    BOOL error_condition;       /* flag - "an error has occured"            */
    BOOL ignore_ok;             /* flag - "ignore the OK button"            */
    BOOL edit_key_pressed;      /* flag - "an editing key was pressed"      */
    BOOL just_passed_dec;       /* flag - "just passed decimal point"       */
    BOOL insert_mode;           /* flag - "insert mode on"                  */
    BOOL help_invoked;          /* flag - "Windows Help has been invoked"   */
} FORM;

typedef FORM *     PFORM;
typedef FORM FAR * LPFORM;

/*---------------------------------------------------------------------------*/

/* definition of a button record */

typedef struct {
    HWND hwnd;                  /* button's window handle                   */
    HBUTTON hbutton;            /* handle of button's window                */
    HBUTTON hnext_button;       /* handle of next button in linked list     */
    int ctrl_id;                /* dialog control ID of button              */
    LPINT pdata;                /* pointer to data to initialize/update     */
    int group_id;               /* group affiliation ID                     */
    int on_value;               /* value stored at 'pdata' if checked       */
    int off_value;              /* value stored at 'pdata' if not checked   */
    DWORD help_context;         /* help context ID of help topic for button */
    BOOL has_changed;           /* flag - "button has changed"              */
} BUTTON;

typedef BUTTON *     PBUTTON;
typedef BUTTON FAR * LPBUTTON;

/*---------------------------------------------------------------------------*/

/* function prototypes */

#if defined(__cplusplus)
    #define NOARGS
    extern "C" {
#else
    #define NOARGS void
#endif

/* button functions */

HBUTTON FAR PASCAL button_define( HFORM hform, int ctrl_id, LPINT pdata,
                                  int group_id, int on_value, int off_value,
                                  int init_state, DWORD help_context );
int      FAR PASCAL button_get_check( HBUTTON hbutton );
HBUTTON  FAR PASCAL button_get_from_ctrl_id( HFORM hform, int ctrl_id );
HBUTTON  FAR PASCAL button_get_from_group( HFORM hform, int group_id );
HBUTTON  FAR PASCAL button_get_from_hwnd( HFORM hform, HWND hWnd );
int      FAR PASCAL button_has_changed( HBUTTON hbutton );
LPBUTTON FAR PASCAL button_lock( HBUTTON hbutton );
int      FAR PASCAL button_set_check( HBUTTON hbutton, int state );
void     FAR PASCAL button_unlock( HBUTTON hbutton );

/* character manipulation functions */

BOOL FAR PASCAL char_is_printable( int ch );
int  FAR PASCAL char_to_lower( int ch );
int  FAR PASCAL char_to_upper( int ch );

/* dialog procedure control functions */

int FAR PASCAL dproc_enter_error( HFORM hform );
int FAR PASCAL dproc_enter_idcancel( HFORM hform );
int FAR PASCAL dproc_enter_idok( HFORM hform );
int FAR PASCAL dproc_enter_wm_command( HFORM hform, unsigned wParam,
                                       LONG lParam );
int FAR PASCAL dproc_exit_error( HFORM hform, LONG lParam );

/* field functions */

int     FAR PASCAL field_data_to_log( HFIELD hfield, LPSTR pbuf, LPVOID pdata,
                                      int data_type );
HFIELD  FAR PASCAL field_define( HFORM hform, int ctrl_id, LPVOID pdata,
                                 int data_type, LPSTR picture_string,
                                 DWORD features,
                                 int (FAR PASCAL *pvalid_func) (LPSTR),
                                 int error_value, DWORD help_context );
int     FAR PASCAL field_disable_feature( HFIELD hfield, DWORD feature );
int     FAR PASCAL field_enable_feature( HFIELD hfield, DWORD feature );
int     FAR PASCAL field_get_character( HFIELD hfield, int position,
                                        BOOL physical );
int     FAR PASCAL field_get_decimal_pos( HFIELD hfield );
HFIELD  FAR PASCAL field_get_from_ctrl_id( HFORM hform, int ctrl_id );
HFIELD  FAR PASCAL field_get_from_hwnd( HFORM hform, HWND hWnd );
int     FAR PASCAL field_get_pos_info( HFIELD hfield, int logical_position,
                                       LPFIELD_POS pfpos );
int     FAR PASCAL field_get_position( HFIELD hfield, LPFIELD_POS pfpos );
int     FAR PASCAL field_get_text( HFIELD hfield, LPSTR pbuf, BOOL physical );
int     FAR PASCAL field_has_changed( HFIELD hfield );
int     FAR PASCAL field_insert_dec( HFIELD hfield, LPSTR pbuf );
LPFIELD FAR PASCAL field_lock( HFIELD hfield );
int     FAR PASCAL field_log_to_data( HFIELD hfield, LPSTR pbuf, LPVOID pdata,
                                      int data_type );
int     FAR PASCAL field_log_to_phys( HFIELD hfield, LPSTR pbuf );
int     FAR PASCAL field_phys_to_log( HFIELD hfield, LPSTR pbuf );
int     FAR PASCAL field_set_text( HFIELD hfield, LPSTR pbuf, BOOL physical );
void    FAR PASCAL field_unlock( HFIELD hfield );

/* form functions */

HFORM  FAR PASCAL form_begin( HWND hDlg );
int    FAR PASCAL form_end( HFORM hform );
HFORM  FAR PASCAL form_get_active( NOARGS );
HFORM  FAR PASCAL form_get_from_hdlg( HWND hDlg );
int    FAR PASCAL form_has_changed( HFORM hform );
int    FAR PASCAL form_in_error_cond( HFORM hform );
int    FAR PASCAL form_is_cancelled( HFORM hform );
LPFORM FAR PASCAL form_lock( HFORM hform );
int    FAR PASCAL form_process( HFORM hform );
int    FAR PASCAL form_set_help( HFORM hform, LPSTR help_file_name );
int    FAR PASCAL form_terminate( HFORM hform );
void   FAR PASCAL form_unlock( HFORM hform );
HFIELD FAR PASCAL form_validate( HFORM hform );

/* generic control functions */

HGENCTRL FAR PASCAL genctrl_define( HFORM hform, int ctrl_id,
                                    DWORD help_context );

/* status message functions */

int FAR PASCAL statmsg_define( HFORM hform, int ctrl_id, int which,
                               LPSTR onmsg, LPSTR offmsg );

/* string manipulation functions */

int     FAR PASCAL str_delete_char( LPSTR pstr, int ch );
void    FAR PASCAL str_insert_char( LPSTR pstr, int ch, int offs );
BOOL    FAR PASCAL str_is_blank( LPSTR pstr );
BOOL    FAR PASCAL str_is_value_zero( LPSTR pstr );
void    FAR PASCAL str_trim_spaces( LPSTR pstr );

#if defined(__cplusplus)
    }
#endif

