//  WIDGET.H
//
//  David Stafford
//
//  11/25/91


#ifndef __WIDGET_H
#define __WIDGET_H

#ifdef CDIST
#undef CDIST
#define CDIST NEAR
#endif

#ifdef DDIST
#undef DDIST
#define DDIST NEAR
#endif

#ifndef LINKABLE
  #define CDIST FAR
  #define DDIST FAR
#else
  #ifndef CDIST
    #define CDIST FAR
  #endif

  #ifndef DDIST
    #define DDIST FAR
  #endif

  #define  GetWidgetExtra( Widget )         ((char *)(Widget) + sizeof(WIDGET))
  #define  GetWidgetRect( Widget, Rec )     ((*(Rec)) = (Widget)->Rect)
  #define  GetWidgetImage( Widget )         ((Widget)->Image)
  #define  GetWidgetMask( Widget )          ((Widget)->Mask)
  #define  GetWidgetSize( Widget )          ((Widget)->Size)
  #define  GetWidgetPoint( Widget )         (*(POINT *)&((Widget)->Rect.left))
  #define  IsWidgetVisible( Widget )        ((Widget)->Visible > 0)
#endif

typedef struct tagWIDGET
  {
  HWND              Wnd;              // Window which "owns" the widget
  POINT             Size;             // Width and height of the widget
  RECT              Rect;             // Location within the window
  HBITMAP           Image;            // The widget image
  HBITMAP           Mask;             // (Optional) 1-plane AND mask
  HBITMAP           Background;       // Behind the widget
  int               Visible;          // Widget is visible if > 0
  BOOL              Dirty;            // For repaint
  struct tagWIDGET *Next;             // You guessed it
  }
WIDGET;

typedef WIDGET NEAR * HWIDGET;


typedef struct
  {
  HDC     DC;
  HWIDGET Widget;
  int     Speed;
  DWORD   StartTime;
  int     Distance;
  int     Count;
  }
ANIM_DATA;


// Some handy general-purpose bitmap functions

HBITMAP      CDIST PASCAL CombineBitmaps( HBITMAP, HBITMAP , HBITMAP , DWORD  );
void         CDIST PASCAL DrawBitmap( HDC, int, int, HBITMAP, HBITMAP);

// The widget-works

HWIDGET      CDIST PASCAL CreateWidget( HWND , HBITMAP, HBITMAP, int);
void         CDIST PASCAL MoveWidget( HDC, HWIDGET, int, int);
void         CDIST PASCAL AnimateWidget( HDC, HWIDGET, int, int, int , HANDLE);
void         CDIST PASCAL DestroyWidget( HWIDGET);
void         CDIST PASCAL HideWidget( HDC, HWIDGET);
void         CDIST PASCAL AbsHideWidget( HDC, HWIDGET);
void         CDIST PASCAL ShowWidget( HDC, HWIDGET);
void         CDIST PASCAL AbsShowWidget( HDC, HWIDGET);
void         CDIST PASCAL RepaintWidgets( HDC, HWND  );
HWIDGET      CDIST PASCAL WidgetHitTest( HWND , int, int);
void         CDIST PASCAL InvalidateWidgetsForPaint( HWND  );
BOOL         CDIST PASCAL IsPointInWidget( HWIDGET, int, int);
HWIDGET      CDIST PASCAL GetNextWidget( HWND , HWIDGET);
int          CDIST PASCAL GetVersionNumber( void );
void         CDIST PASCAL DestroyAllWidgetsForTheWindow( HWND  );
int          CDIST PASCAL DistanceInPoints( int, int, int, int);
BOOL         CDIST PASCAL IntersectWidgetRect( HWIDGET, RECT DDIST *, RECT DDIST *);
BOOL         CDIST PASCAL WidgetsOverlap( HWIDGET, HWIDGET);

#ifndef LINKABLE
void DDIST * CDIST PASCAL GetWidgetExtra( HWIDGET);
void         CDIST PASCAL GetWidgetRect( HWIDGET, RECT DDIST *);
POINT        CDIST PASCAL GetWidgetSize( HWIDGET);
POINT        CDIST PASCAL GetWidgetPoint( HWIDGET);
BOOL         CDIST PASCAL IsWidgetVisible( HWIDGET);
#endif

#endif
