//  WTEST
//
//  David Stafford
//
//  11/25/91
//  01/05/92
//
//  Test program for the Widget library.


#include <windows.h>
#include <stdlib.h>
#include "widget.h"


HWND    MainWindow;                      // The main window
HANDLE  hInst;                           // The instance

HBITMAP PatternBits;                     // Background bitmap pattern
HCURSOR PatternBrush;                    // Background bitmap brush

HCURSOR Hand;

RECT    ButterflyBounds;
BOOL    MouseTracking;                   // Are we pulling the card around?
POINT   MouseLoc;

HBITMAP ButterflyBits, ButterflyMask;    // Butterfly data
HWIDGET ButterflyWidget;
POINT   ButterflyDir;
POINT   ButterflyLoc;

HBITMAP CardBits, CardMask;              // Card data
HWIDGET CardWidget;
POINT   CardOffset;


void Init( void )
  {
  ButterflyBits = LoadBitmap( hInst, MAKEINTRESOURCE( 100 ) );
  ButterflyMask = LoadBitmap( hInst, MAKEINTRESOURCE( 101 ) );
  CardBits      = LoadBitmap( hInst, MAKEINTRESOURCE( 110 ) );
  CardMask      = LoadBitmap( hInst, MAKEINTRESOURCE( 111 ) );
  PatternBits   = LoadBitmap( hInst, MAKEINTRESOURCE( 200 ) );
  Hand          = LoadCursor( hInst, MAKEINTRESOURCE( 300 ) );

  PatternBrush  = CreatePatternBrush( PatternBits );

  ButterflyWidget = CreateWidget( MainWindow, ButterflyBits, ButterflyMask, 0 );
  CardWidget      = CreateWidget( MainWindow, CardBits, CardMask, 0 );

  ShowWidget( NULL, CardWidget );
  ShowWidget( NULL, ButterflyWidget );
  }


void Cleanup( void )
  {
  DestroyAllWidgetsForTheWindow( MainWindow );

  DeleteObject( ButterflyBits );
  DeleteObject( ButterflyMask );
  DeleteObject( CardBits );
  DeleteObject( CardMask );
  DeleteObject( PatternBits );
  DeleteObject( PatternBrush );

  DestroyCursor( Hand );
  }


long SquRoot( long Val )
  {
  long Lo = 0, Hi = 32768, Mid, Mid2;

  while( Lo <= Hi )
    {
    Mid = (Lo + Hi) / 2;

    Mid2 = Mid * Mid;

    if( Mid2 == Val )  return( Mid );

    if( Mid2 < Val )  Lo = Mid + 1;
    else              Hi = Mid - 1;
    }

  return( Mid );
  }


void Animate( void )
  {
  POINT NewButterflyLoc, Bounce;
  LONG xDis, yDis, Total;
  int xPull, yPull;
  static int Count = 400;

  if( IsWidgetVisible( ButterflyWidget ) )
    {
    if( --Count == 0 )
      {
      Count = 400;

      ButterflyDir.x = (ButterflyDir.x * 20) / 19;
      ButterflyDir.y = (ButterflyDir.y * 20) / 19;
      }

    xDis = abs( MouseLoc.x - (ButterflyLoc.x / 8) );
    yDis = abs( MouseLoc.y - (ButterflyLoc.y / 8) );

    Total = SquRoot( xDis * xDis + yDis * yDis );

    if( Total != 0 )
      {
      xPull = ((Total * xDis) / (xDis + yDis)) / 32;
      yPull = ((Total * yDis) / (xDis + yDis)) / 32;

      if( xPull > 30 )  xPull = 30;
      if( yPull > 30 )  yPull = 30;

      if( MouseLoc.x < ButterflyLoc.x / 8 )  xPull *= -1;
      if( MouseLoc.y < ButterflyLoc.y / 8 )  yPull *= -1;

      ButterflyDir.x += xPull;
      ButterflyDir.y += yPull;
      }

    NewButterflyLoc.x = ButterflyLoc.x + ButterflyDir.x;
    NewButterflyLoc.y = ButterflyLoc.y + ButterflyDir.y;

    Bounce.x = Bounce.y = 0;

    if( NewButterflyLoc.x >= ButterflyBounds.right || NewButterflyLoc.x < ButterflyBounds.left )  Bounce.x = 1;
    if( NewButterflyLoc.y >= ButterflyBounds.bottom || NewButterflyLoc.y < ButterflyBounds.top )  Bounce.y = 1;

    if( Bounce.x )  ButterflyDir.x = (ButterflyDir.x * -4) / 5;
    if( Bounce.y )  ButterflyDir.y = (ButterflyDir.y * -4) / 5;

    ButterflyLoc.x += ButterflyDir.x;
    ButterflyLoc.y += ButterflyDir.y;

    MoveWidget( NULL, ButterflyWidget, ButterflyLoc.x / 8, ButterflyLoc.y / 8 );
    }
  }


long FAR PASCAL _export WndProc( HWND hWnd, unsigned iMessage, WORD wParam, LONG lParam )
  {
  HDC DC;
  PAINTSTRUCT Paint;
  POINT Pt;
  RECT Rect;

  switch( iMessage )
    {
    case WM_DESTROY:
      PostQuitMessage( 0 );
      break;

    case WM_MOUSEMOVE:
      MouseLoc.x = LOWORD( lParam );
      MouseLoc.y = HIWORD( lParam );

      if( MouseTracking || IsPointInWidget( CardWidget, MouseLoc.x, MouseLoc.y ) )
        {
        SetCursor( Hand );
        }
      else
        {
        SetCursor( LoadCursor( NULL, MAKEINTRESOURCE( IDC_ARROW ) ) );
        }

      if( MouseTracking )
        {
        ShowCursor( FALSE );
        MoveWidget( NULL, CardWidget, MouseLoc.x - CardOffset.x, MouseLoc.y - CardOffset.y );
        ShowCursor( TRUE );
        }
      break;

    case WM_LBUTTONDOWN:
      HideWidget( NULL, ButterflyWidget );
      SetCapture( hWnd );
      Pt = GetWidgetPoint( CardWidget );

      if( IsPointInWidget( CardWidget, LOWORD( lParam ), HIWORD( lParam ) ) )
        {
        MouseTracking = TRUE;

        CardOffset.x = LOWORD( lParam ) - Pt.x;
        CardOffset.y = HIWORD( lParam ) - Pt.y;
        }
      else
        {
        HideWidget( NULL, ButterflyWidget );

        AnimateWidget( NULL,
                       CardWidget,
                       LOWORD( lParam ) - GetWidgetSize( CardWidget ).x / 2,
                       HIWORD( lParam ) - GetWidgetSize( CardWidget ).y / 2,
                       DistanceInPoints( Pt.x, Pt.y, LOWORD( lParam ), HIWORD( lParam ) ),
                       NULL );

        ShowWidget( NULL, ButterflyWidget );
        }
      break;

    case WM_LBUTTONUP:
      MouseTracking = FALSE;

      if( !IsWidgetVisible( ButterflyWidget ) )  ShowWidget( NULL, ButterflyWidget );
      ReleaseCapture();
      break;

    case WM_SIZE:
      ButterflyDir.x = ButterflyDir.y = 1;
      ButterflyLoc.x = ButterflyLoc.y = 0;

      MoveWidget( NULL, ButterflyWidget, 0, 0 );
      MoveWidget( NULL, CardWidget, 0, 0 );

      ButterflyBounds.left   = GetWidgetSize( ButterflyWidget ).x * -8;
      ButterflyBounds.top    = GetWidgetSize( ButterflyWidget ).y * -8;
      ButterflyBounds.right  = LOWORD( lParam ) * 8;
      ButterflyBounds.bottom = HIWORD( lParam ) * 8;
      break;

    case WM_PAINT:
      GetClientRect( hWnd, &Rect );

      InvalidateWidgetsForPaint( hWnd );

      DC = BeginPaint( hWnd, &Paint );

      FillRect( DC, &Rect, PatternBrush );

      RepaintWidgets( DC, hWnd );

      EndPaint( hWnd, &Paint );
      break;

    default:
      return( DefWindowProc( hWnd, iMessage, wParam, lParam ) );
    }

  return( 0L );
  }


int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow )
  {
  MSG       msg;
  WNDCLASS  wndclass;

  hInst = hInstance;

  if( !hPrevInstance )
    {
    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = WndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = LoadIcon( NULL, IDI_EXCLAMATION );
    wndclass.hCursor       = NULL;
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = "XFIRE";

    if( !RegisterClass( &wndclass ) )  return( FALSE );
    }

  MainWindow = CreateWindow( "XFIRE",
                             "Widget Test Program",
                             WS_OVERLAPPEDWINDOW,
                             CW_USEDEFAULT,
                             0,
                             CW_USEDEFAULT,
                             0,
                             NULL,
                             NULL,
                             hInstance,
                             NULL );
  Init();

  ShowWindow( MainWindow, nCmdShow );
  UpdateWindow( MainWindow );

  do
    {
    while( !PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) )
      {
      Animate();
      }

    DispatchMessage( &msg );
    TranslateMessage( &msg );
    }
  while( msg.message != WM_QUIT );

  Cleanup();

  return( msg.wParam );
  }

