#include <windows.h>
#include "windxf.h"

HANDLE GBL_hInst;
extern char GBL_mfname[256];

void SeparateFile(HWND, LPSTR, LPSTR, LPSTR);
void UpdateListBox(HWND);
void AddExt(PSTR, PSTR);
void ChangeDefExt(PSTR, PSTR);

char  GBL_dbpath[256];
char  GBL_mfpath[256];

char FileName[128];
char PathName[128];
char OpenName[128];
char DefPath[128]="";
char DefSpec[13] = "*.dxf";
char DefExt[] = ".dxf";
char str[255];

BOOL FAR PASCAL
FILEDIALOGPROC(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
   HWND ChWnd;
   char fname[256];

   switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
       DlgDirList(hDlg, "*.dxf", IDC_LISTBOX, IDC_PATH, 0x4010);
       SendMessage(ChWnd,LB_DIR,0x37,(LONG) "*.dxf");
       SetDlgItemText(hDlg, IDC_FILENAME, "*.dxf");
       SetFocus(GetDlgItem(hDlg, IDC_FILENAME));
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
            switch (wParam) 
            {
                case IDC_LISTBOX:
                    switch (HIWORD(lParam)) {

                        case LBN_SELCHANGE:
                            /* If item is a directory name, append "*.*" */
                            if (DlgDirSelect(hDlg, str, IDC_LISTBOX)) 
                                lstrcat(str, DefSpec);

                            SetDlgItemText(hDlg, IDC_FILENAME, str);
                            SendDlgItemMessage(hDlg,
                                IDC_FILENAME,
                                EM_SETSEL,
                                NULL,
                                MAKELONG(0, 0x7fff));
                            break;

                       case LBN_DBLCLK:
                             goto openfile; 

                    } /* Switch hiword */
                    return (TRUE);
                    break;

                case IDM_FOPEN:
openfile:
                    GetDlgItemText(hDlg, IDC_FILENAME, OpenName, 128);
                    if (strchr(OpenName, '*') || strchr(OpenName, '?')) {
                        SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec,
                            (LPSTR) OpenName);
                        if (str[0])
                            lstrcpy(DefPath, str);
                        ChangeDefExt(DefExt, DefSpec);
                        UpdateListBox(hDlg);
                        return (TRUE);
                    }

                    if (!OpenName[0]) {
                        MessageBox(hDlg, "No filename specified.",
                            NULL, MB_OK | MB_ICONHAND);
                        return (TRUE);
                    }

                    AddExt(OpenName, DefExt);

                    GetDlgItemText(hDlg, IDC_PATH, GBL_dbpath, 256);
                    GetDlgItemText(hDlg, IDC_FILENAME, fname, 256);
                    lstrcat(GBL_dbpath,"/");
                    lstrcat(GBL_dbpath,fname);

                    EndDialog(hDlg, NULL);
                    return (TRUE);
                    break;

                case IDM_FCANCEL:
                    EndDialog(hDlg, NULL);
                    return (FALSE);
                    break;
             } /* end wparam */
             break;

	    } /* Switch message */
    return (FALSE);			      /* Didn't process a message    */
}

void SeparateFile(hDlg, lpDestPath, lpDestFileName, lpSrcFileName)
HWND hDlg;
LPSTR lpDestPath, lpDestFileName, lpSrcFileName;
{
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) strlen(lpSrcFileName);
    while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
        lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if (*lpTmp != ':' && *lpTmp != '\\') {
        lstrcpy(lpDestFileName, lpSrcFileName);
        lpDestPath[0] = 0;
        return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
     *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
}
void ChangeDefExt(Ext, Name)
PSTR Ext, Name;
{
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
        pTptr++;
    if (*pTptr)
        if (!strchr(pTptr, '*') && !strchr(pTptr, '?'))
            lstrcpy(Ext, pTptr);
}
void UpdateListBox(hDlg)
HWND hDlg;
{
    lstrcpy(str, DefPath);
    lstrcat(str, DefSpec);
    DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);
    SetDlgItemText(hDlg, IDC_FILENAME, DefSpec);
}
void AddExt(Name, Ext)
PSTR Name, Ext;
{
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
        pTptr++;
    if (*pTptr != '.')
        lstrcat(Name, Ext);
}

void GetDbPath( dbpath )
char * dbpath;
{
lstrcpy(dbpath, GBL_dbpath);
}

BOOL FAR PASCAL
MFNAMEPROC(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{

   switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
       SetDlgItemText(hDlg, IDM_MFNAME, GBL_mfname); 
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
            switch (wParam) 
            {
                case IDM_WRITEMF:
                    GetDlgItemText(hDlg, IDM_MFNAME, (LPSTR)GBL_mfname, 256);
                    EndDialog(hDlg, TRUE);
                    return (TRUE);
                    break;

                case IDM_CANCELMF:
                    EndDialog(hDlg, NULL);
                    return (FALSE);
                    break;

             } /* end wparam */
             break;
	    } /* Switch message */
    return (FALSE);			      /* Didn't process a message    */
}


BOOL FAR PASCAL
MFPROC(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
   HWND ChWnd;
   char fname[256];

   switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
       DlgDirList(hDlg, "*.wmf", IDC_LISTBOX, IDC_PATH, 0x4010);
       SendMessage(ChWnd,LB_DIR,0x37,(LONG) "*.wmf");
       SetDlgItemText(hDlg, IDC_FILENAME, "*.wmf");
       SetFocus(GetDlgItem(hDlg, IDC_FILENAME));
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
            switch (wParam) 
            {
                case IDC_LISTBOX:
                    switch (HIWORD(lParam)) {

                        case LBN_SELCHANGE:
                            /* If item is a directory name, append "*.*" */
                            if (DlgDirSelect(hDlg, str, IDC_LISTBOX)) 
                                lstrcat(str, DefSpec);

                            SetDlgItemText(hDlg, IDC_FILENAME, str);
                            SendDlgItemMessage(hDlg,
                                IDC_FILENAME,
                                EM_SETSEL,
                                NULL,
                                MAKELONG(0, 0x7fff));
                            break;

                       case LBN_DBLCLK:
                             goto openfile; 

                    } /* Switch hiword */
                    return (TRUE);
                    break;

                case IDM_FOPEN:
openfile:
                    GetDlgItemText(hDlg, IDC_FILENAME, OpenName, 128);
                    if (strchr(OpenName, '*') || strchr(OpenName, '?')) {
                        SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec,
                            (LPSTR) OpenName);
                        if (str[0])
                            lstrcpy(DefPath, str);
                        ChangeDefExt(DefExt, DefSpec);
                        UpdateListBox(hDlg);
                        return (TRUE);
                    }

                    if (!OpenName[0]) {
                        MessageBox(hDlg, "No filename specified.",
                            NULL, MB_OK | MB_ICONHAND);
                        return (TRUE);
                    }

                    AddExt(OpenName, DefExt);

                    GetDlgItemText(hDlg, IDC_PATH, GBL_mfpath, 256);
                    GetDlgItemText(hDlg, IDC_FILENAME, fname, 256);
                    lstrcat(GBL_mfpath,"/");
                    lstrcat(GBL_mfpath,fname);

                    EndDialog(hDlg, NULL);
                    return (TRUE);
                    break;

                case IDM_FCANCEL:
                    EndDialog(hDlg, NULL);
                    return (FALSE);
                    break;
             } /* end wparam */
             break;

	    } /* Switch message */
    return (FALSE);			      /* Didn't process a message    */
}

