/****************************************************************************

	PROGRAM: windxf.c

	PURPOSE: windxf template for Windows applications

	FUNCTIONS:

	WinMain() - calls initialization function, processes message loop
	windxfInit() - initializes window data and registers window
	windxfWndProc() - processes messages
	About() - processes messages for "About" dialog box

****************************************************************************/

#include "windows.h"			/* required for all Windows applications */
#include "windxf.h"			/* specific to this program			 */

HANDLE hInst;				/* current instance				 */
HANDLE hMenu; 			/* Handle to my new menu						*/
char   dbpath[256];
HWND   GBL_hwnd;
HDC    GBL_hdc;
BOOL   GBL_draw_flag=FALSE;
int    GBL_draw_mode=0;
HANDLE hmf=(HANDLE)NULL;
HDC    mfhdc;
char   GBL_mfname[256];
extern double wx1, wy1, wx2, wy2;
extern int logextx, logexty;
extern char GBL_mfpath[256];
/****************************************************************************

	FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

	PURPOSE: calls initialization function, processes message loop

	COMMENTS:

	This will initialize the window class if it is the first time this
	application is run.  It then creates the window, and processes the
	message loop until a PostQuitMessage is received.  It exits the
	application by returning the value passed by the PostQuitMessage.

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;				 /* current instance		 */
HANDLE hPrevInstance;				 /* previous instance		 */
LPSTR lpCmdLine;				 /* command line			 */
int nCmdShow;					 /* show-window type (open/icon) */
{
	HWND hWnd;					 /* window handle			 */
	MSG msg;					 /* message				 */


   if (!hPrevInstance)			/* Has application been initialized? */
	if (!windxfInit(hInstance))
		return (NULL);   		/* Exits if unable to initialize	 */

   hInst = hInstance;			/* Saves the current instance		 */

   hMenu = LoadMenu(hInstance, "windxfMenu");
   hWnd = CreateWindow("windxf",  /* window class		 */
	 "Windows DXF Viewer",         /* window name		 */
	WS_OVERLAPPEDWINDOW,			    /* window style		 */
	CW_USEDEFAULT,				  /* x position			 */
	CW_USEDEFAULT,				  /* y position			 */
	CW_USEDEFAULT,				  /* width			 */
	CW_USEDEFAULT,				  /* height			 */
	NULL,					  /* parent handle		 */
	hMenu,					  /* menu or child ID		 */
	hInstance,				  /* instance			 */
	NULL);					  /* additional info		 */

	if (!hWnd)					  /* Was the window created? */
	return (NULL);

	ShowWindow(hWnd, nCmdShow);			  /* Shows the window		 */
	UpdateWindow(hWnd);				  /* Sends WM_PAINT message  */

	while (GetMessage(&msg,	   /* message structure				 */
		NULL,		   /* handle of window receiving the message */
		NULL,		   /* lowest message to examine			 */
		NULL))		   /* highest message to examine		 */
	{
	TranslateMessage(&msg);	   /* Translates virtual key codes		 */
	DispatchMessage(&msg);	   /* Dispatches message to window		 */
	}
	return (msg.wParam);	   /* Returns the value from PostQuitMessage */
}


/****************************************************************************

	FUNCTION: windxfInit(HANDLE)

	PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL windxfInit(hInstance)
HANDLE hInstance;				   /* current instance		 */
{
	HANDLE hMemory;				   /* handle to allocated memory */
	PWNDCLASS pWndClass;			   /* structure pointer		 */
	BOOL bSuccess;				   /* RegisterClass() result	 */

	hMemory = LocalAlloc(LPTR, sizeof(WNDCLASS));
	pWndClass = (PWNDCLASS) LocalLock(hMemory);

	pWndClass->style = NULL;
	pWndClass->lpfnWndProc = windxfWndProc;
	pWndClass->hInstance = hInstance;
	pWndClass->hIcon = LoadIcon(NULL, IDI_APPLICATION);
	pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);
	pWndClass->hbrBackground = GetStockObject(WHITE_BRUSH);
	pWndClass->lpszMenuName = "windxfMenu";
	pWndClass->lpszClassName = (LPSTR) "windxf";

	bSuccess = RegisterClass(pWndClass);

	LocalUnlock(hMemory);				/* Unlocks the memory	*/
	LocalFree(hMemory);					/* Returns it to Windows */

	return (bSuccess);		 /* Returns result of registering the window */
}

/****************************************************************************

	FUNCTION: windxfWndProc(HWND, unsigned, WORD, LONG)

	PURPOSE:  Processes messages

	MESSAGES:

	WM_CREATE	- create window
	WM_DESTROY	- destroy window
	WM_COMMAND	- menu selections and others

	COMMENTS:


****************************************************************************/

long FAR PASCAL windxfWndProc(hWnd, message, wParam, lParam)
HWND hWnd;				  /* window handle			 */
unsigned message;			  /* type of message			 */
WORD wParam;				  /* additional information		 */
LONG lParam;				  /* additional information		 */
{

   static FARPROC  lpfnFILEDIALOGPROC;
   static FARPROC  lpfnMETADIALOGPROC;
   static FARPROC  lpfnMFPROC;
   static FARPROC lpProcAbout;		  /* pointer to the "About" function */
   PAINTSTRUCT     ps;
   static LOGPEN   lpBlack = {PS_SOLID, 1, 1, RGB(0,0,0)};
   HPEN            hPenBlack;
   RECT            rect;
   BOOL            result;
   GLOBALHANDLE    hGmem;
   LPMETAFILEPICT  lpMFP;

   GBL_hwnd = hWnd;
	switch (message) {

	case WM_CREATE:				/* message: window being created */
		break;

	case WM_DESTROY:		  /* message: window being destroyed */
      if (hmf != (HANDLE)NULL)
          DeleteMetaFile(hmf);
		PostQuitMessage(0);
		break;

	case WM_COMMAND:
		switch (wParam) {

		case IDM_OPEN:
         lpfnFILEDIALOGPROC = MakeProcInstance((FARPROC)FILEDIALOGPROC, hInst);
         DialogBox(hInst, "FILEDIALOG", hWnd, lpfnFILEDIALOGPROC);
         FreeProcInstance(lpfnFILEDIALOGPROC);
         InvalidateRect(hWnd, NULL, TRUE);
         GBL_draw_flag = TRUE;
         GBL_draw_mode = 0;
         break;

      case IDM_MFOPEN:
         lpfnMFPROC = MakeProcInstance((FARPROC)MFPROC, hInst);
         DialogBox(hInst, "MFDIALOG", hWnd, lpfnMFPROC);
         FreeProcInstance(lpfnMFPROC);
         InvalidateRect(hWnd, NULL, TRUE);
         GBL_draw_flag = TRUE;
         GBL_draw_mode = 4;
         break;

      case IDM_DRAW:
         InvalidateRect(hWnd, NULL, TRUE);
         GBL_draw_mode = 1;
         break;

      case IDM_DRMETA:
         lpfnMETADIALOGPROC = MakeProcInstance((FARPROC)MFNAMEPROC, hInst);
         result = DialogBox(hInst, "MFNAME", hWnd, lpfnMETADIALOGPROC);
         FreeProcInstance(lpfnMETADIALOGPROC);
         if (result)
            {
             GBL_draw_mode = 2;
             InvalidateRect(hWnd, NULL, TRUE);
            }
         break;

      case IDM_CLIP:

            /* Copy the current metafile to the clipboard */
            hGmem = GlobalAlloc(GHND, (DWORD)sizeof(METAFILEPICT) );
            lpMFP = (LPMETAFILEPICT) GlobalLock(hGmem);
            GetClientRect( hWnd, &rect);
            lpMFP->mm = MM_ISOTROPIC;
            lpMFP->xExt = rect.right;
            lpMFP->yExt = rect.bottom;
            lpMFP->hMF = hmf;
            GlobalUnlock(hGmem);
            OpenClipboard(hWnd);
            EmptyClipboard();
            SetClipboardData(CF_METAFILEPICT, hGmem);
            CloseClipboard();

            /* Redraw from the memory metafile */
            GBL_draw_mode = 3;
            InvalidateRect(hWnd, NULL, TRUE);
            break;

		case IDM_ABOUT:
   		lpProcAbout = MakeProcInstance(About, hInst);
	   	DialogBox(hInst, "AboutBox",  hWnd,  lpProcAbout);
		   FreeProcInstance(lpProcAbout);
   		break;

		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;

		}
		break;

   case WM_PAINT:
      if (GBL_draw_flag)
        {
         switch(GBL_draw_mode)
         {
         case 0: /* Draw to Screen from dxf */
            GetDbPath(dbpath);
            mfhdc = CreateMetaFile(NULL);
            GBL_hdc = BeginPaint(hWnd, &ps);
            SetMapMode(GBL_hdc, MM_ISOTROPIC);
            GetClientRect( hWnd, &rect);
            SetViewportExt(GBL_hdc, rect.right, rect.bottom);

            SetWindowExt(GBL_hdc, 1000, 1000);
            hPenBlack = CreatePenIndirect(&lpBlack);
            SelectObject(GBL_hdc, hPenBlack);

            ReadDXF(dbpath);

            EndPaint(hWnd, &ps);
            hmf = CloseMetaFile(mfhdc);
            DeleteObject(hPenBlack);
            break;
         case 1: /* Redraw Screen from memory metafile */
            GBL_hdc = BeginPaint(hWnd, &ps);
            SetMapMode(GBL_hdc, MM_ISOTROPIC);
            GetClientRect( hWnd, &rect);
            SetViewportExt(GBL_hdc, rect.right, rect.bottom);
            SetWindowExt(GBL_hdc, 1000, 1000);
            PlayMetaFile(GBL_hdc, hmf);
            EndPaint(hWnd, &ps);
            break;

         case 2: /* Draw to Metafile from screen */
            CopyMetaFile(hmf,GBL_mfname);
            GBL_draw_mode = 1;
            break;

         case 3: /* Copy contents of screen to clipboard */
            GBL_hdc = BeginPaint(hWnd, &ps);
            SetMapMode(GBL_hdc, MM_ISOTROPIC);
            GetClientRect( hWnd, &rect);
            SetViewportExt(GBL_hdc, rect.right, rect.bottom);
            SetWindowExt(GBL_hdc, 1000, 1000);
            PlayMetaFile(GBL_hdc, hmf);
            EndPaint(hWnd, &ps);
            break;

         case 4: /* Read from metafile */
            GBL_hdc = BeginPaint(hWnd, &ps);
            hmf = GetMetaFile(GBL_mfpath);
            SetMapMode(GBL_hdc, MM_ISOTROPIC);
            GetClientRect( hWnd, &rect);
            SetViewportExt(GBL_hdc, rect.right, rect.bottom);
            SetWindowExt(GBL_hdc, 1000, 1000);
            PlayMetaFile(GBL_hdc, hmf);
            EndPaint(hWnd, &ps);
            break;
       }
       GBL_draw_mode = 1;
       }
       else
        {
         GBL_hdc = BeginPaint(hWnd, &ps);
         EndPaint(hWnd, &ps);
        }
         break;

	default:			  /* Passes it on if unproccessed	*/
		return (DefWindowProc(hWnd, message, wParam, lParam));
	}
	return (NULL);
}

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;                                /* window handle of the dialog box */
unsigned message;                         /* type of message                 */
WORD wParam;                              /* message-specific information    */
LONG lParam;
{
    switch (message) {
	case WM_INITDIALOG:		   /* message: initialize dialog box */
	    return (TRUE);

	case WM_COMMAND:		      /* message: received a command */
	    if (wParam == IDOK                /* "OK" box selected?	     */
                || wParam == IDCANCEL) {      /* System menu close command? */
		EndDialog(hDlg, TRUE);	      /* Exits the dialog box	     */
		return (TRUE);
	    }
	    break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

