#include "stdafx.h"

#include "cdib.h"

#include <memory.h>

CDib::CDib()
{
}

CDib::~CDib()
{
}

BOOL CDib::Load( LPSTR fileName )
{
  m_pDib = DibOpenFile( fileName );
  return( m_pDib != NULL );
}

PDIB CDib::GetDibHeader()
{
  return m_pDib;
}

CDib::operator PDIB()
{
  return m_pDib;
}

LPBYTE CDib::GetDibBits()
{
  return (LPBYTE)DibPtr( m_pDib );
}

CDib::operator LPBYTE()
{
  return (LPBYTE)DibPtr( m_pDib );
}

LPRGBQUAD CDib::GetDibColors()
{
  return DibColors( m_pDib );
}

int CDib::GetWidth()
{
  return DibWidth( m_pDib );
}

int CDib::GetHeight()
{
  return DibHeight( m_pDib );
}

void CDib::MapToPalette( CPalette& palette )
{
  DibMapToPalette( m_pDib, (HPALETTE)palette.GetSafeHandle() );
}
