// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"

#include "wingee.h"
#include "mainfrm.h"

#include <wing.h>
#include <dibfx.h>
#include <dib.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
  //{{AFX_MSG_MAP(CMainFrame)
  ON_WM_ERASEBKGND()
  ON_WM_CREATE()
  ON_WM_SIZE()
  ON_WM_RBUTTONDBLCLK()
  ON_WM_SETFOCUS()
  ON_WM_KILLFOCUS()
  ON_WM_LBUTTONDOWN()
  ON_WM_LBUTTONUP()
  ON_WM_MOUSEMOVE()
  ON_WM_KEYUP()
  ON_WM_TIMER()
  ON_WM_PAINT()
  ON_WM_ACTIVATE()
  //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
  m_nDispWidth = 640;
  m_nDispHeight = 480;
  m_nWidth = 0;
  m_nHeight = 0;
  m_nXOffset = 0;
  m_nYOffset = 0;
  m_bMoveBitmap = FALSE;
  m_bWindowSized = FALSE;
  m_pSprite = NULL;
  
  // create actual window
  Create( NULL, NULL, WS_POPUP & ~WS_CAPTION );
}

CMainFrame::~CMainFrame()
{
  HBITMAP hBitmap = (HBITMAP)::SelectObject( m_hWinGDC, m_hOldBitmap);
  ::DeleteObject( hBitmap );
  ::DeleteDC( m_hWinGDC );
  delete m_pDC;

  // Delete the phased sprite
  delete m_pSprite;
  
  // Delete the dib cache
  for( int nIndex=0; nIndex < 30; nIndex++ )
    delete m_dibs[nIndex];
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
  CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
  CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::SetupWinG()
{
  //  Get WinG to recommend the fastest DIB format
  if( WinGRecommendDIBFormat( (BITMAPINFO*)&m_bufferHeader ))
  {
    //  make sure it's 8bpp and remember the orientation
    m_bufferHeader.bih.biBitCount = 8;
    m_bufferHeader.bih.biCompression = BI_RGB;
  }
  else
  {
    //  set it up ourselves
    m_bufferHeader.bih.biSize = sizeof(BITMAPINFOHEADER);
    m_bufferHeader.bih.biPlanes = 1;
    m_bufferHeader.bih.biBitCount = 8;
    m_bufferHeader.bih.biCompression = BI_RGB;
    m_bufferHeader.bih.biSizeImage = 0;
    m_bufferHeader.bih.biClrUsed = 0;
    m_bufferHeader.bih.biClrImportant = 0;
    m_bufferHeader.bih.biHeight = 1;
  }
  m_bufferHeader.bih.biWidth = m_nDispWidth;
  m_bufferHeader.bih.biHeight *= m_nDispHeight;

  // Load the palette with colors from bitmaps, then create it
  m_palette.AddColors( *(CDib*)m_dibs[0], TRUE );
  m_palette.AddColors( m_background, TRUE );
  m_palette.CreatePalette();

  // Remap the existing bitmaps' colors to the new palette
  m_background.MapToPalette( m_palette );
  for( int nIndex=0; nIndex < 30; nIndex++ )
    ((CDib*)m_dibs[nIndex])->MapToPalette( m_palette );

  // Fill the WinGBitmap's header with the colors
  m_palette.CopyQuadsTo( m_bufferHeader.aColors );
  
  //  Create a WinGDC and Bitmap
  m_hWinGDC = WinGCreateDC();
  HBITMAP hBitmap = WinGCreateBitmap( 
    m_hWinGDC,
    (BITMAPINFO*)&m_bufferHeader, 
    &m_pDispBuffer );

  //  Store the old bitmap to select back in before deleting
  m_hOldBitmap = (HBITMAP)::SelectObject( m_hWinGDC, hBitmap );

  // Blit the background bitmap to the WinG bitmap surface
  DibBlt(
    (LPBITMAPINFOHEADER)&m_bufferHeader, 
    (LPBYTE)m_pDispBuffer, 
    0, 0, 
    m_background,
    m_background,
    0, 0, 
    m_nDispWidth, m_nDispHeight );
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
  if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
    return -1;
  
  SetCursor( AfxGetApp()->LoadStandardCursor( IDC_WAIT ));

  // Load the DIBs  
  m_dibs.SetSize( 30 );
  for( int nIndex=0; nIndex < 30; nIndex++ )
  {
    char fileName[40];
    wsprintf(
      fileName,
      "media\\wing%04d.bmp",
      nIndex );

    CDib* pDib = new CDib();
    pDib->Load( fileName );
    m_dibs[nIndex] = pDib;
  }
  
  m_pSprite = new CPhasedSprite( &m_dibs );
  m_background.Load( "media\\backgrnd.bmp" );

  // Create a DC which we will use as the screen DC
  m_pDC = new CClientDC( this );  
  SetupWinG();

  return 0;
}


void CMainFrame::OnPaint()
{
  // This function must use a CPaintDC to keep the app from locking
  CPaintDC dc(this);
  
  if( m_bWindowSized )
    WinGBitBlt(
      m_pDC->GetSafeHdc(), 
      m_nXOffset, 
      m_nYOffset, 
      m_nDispWidth, 
      m_nDispHeight, 
      m_hWinGDC, 
      0, 0 );
}

BOOL CMainFrame::OnEraseBkgnd(CDC* pDC)
{
  CBrush* pOldBrush = (CBrush*)pDC->SelectStockObject( BLACK_BRUSH );
  
  CRect rect;
  GetClientRect( &rect );

  // Fill the client area with the black brush  
  pDC->PatBlt( rect.left, rect.top, rect.Width(), rect.Height(), PATCOPY );
  pDC->SelectObject(pOldBrush);

  return TRUE;
}

void CMainFrame::OnSetFocus(CWnd* pOldWnd)
{
  CFrameWnd::OnSetFocus(pOldWnd);

  // We just got focus, so make sure that our palette is realized by the system
  m_pDC->SelectPalette( &m_palette, FALSE );
  m_pDC->RealizePalette();

  // Start the timer, since we are ready
  m_nTimerID = 1000;
  SetTimer( m_nTimerID, 1, NULL );
}

void CMainFrame::OnKillFocus(CWnd* pNewWnd)
{
  CFrameWnd::OnKillFocus(pNewWnd);
  
  // We are losing focus, stop the timer, so we don't eat CPU cycles
  KillTimer( m_nTimerID );
}

void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
  CFrameWnd::OnSize(nType, cx, cy);
  
  if (nType == SIZE_MAXIMIZED)
  { 
    // We received the message to maximize, so calculate window position
    m_nWidth = cx;
    m_nHeight = cy;
    m_nXOffset = (m_nWidth - m_nDispWidth) / 2 - 1;
    m_nYOffset = (m_nHeight - m_nDispHeight) / 2 - 1;

    m_bWindowSized = TRUE;
    
    // Blt the offscreen buffer to the window
    WinGBitBlt(
      m_pDC->GetSafeHdc(), 
      m_nXOffset, 
      m_nYOffset, 
      m_nDispWidth, 
      m_nDispHeight, 
      m_hWinGDC, 
      0, 0 );
  }    
}

void CMainFrame::ExitApp()
{
  KillTimer( m_nTimerID );
  ((CWinGeeApp*)AfxGetApp())->OnAppExit();
}

void CMainFrame::OnTimer(UINT nIDEvent)
{
  // Step to its next frame
  m_pSprite->NextFrame();

  // Clear the old area of the sprite with the background bitmap
  m_pSprite->EraseSprite(
    (LPBITMAPINFOHEADER)&m_bufferHeader, 
    (LPBYTE)m_pDispBuffer, 
    m_background );

  // Draw the sprite in the new position    
  m_pSprite->DrawSprite(
    (LPBITMAPINFOHEADER)&m_bufferHeader, 
    (LPBYTE)m_pDispBuffer,
    0 );

  // Take the union of the previous rect and the new rect and blit that
  // area onto the window      
  CRect updateRect;
  updateRect.UnionRect( m_pSprite->GetPrevRect(), m_pSprite->GetRect() );
  WinGBitBlt(
    m_pDC->GetSafeHdc(), 
    m_nXOffset + updateRect.left, 
    m_nYOffset + updateRect.top, 
    updateRect.Width(), updateRect.Height(),
    m_hWinGDC, 
    updateRect.left, updateRect.top); 

  m_pSprite->SetPrevRect();
}

//----------------------------------------------------------------------------
// Mouse Functions
//----------------------------------------------------------------------------
void CMainFrame::OnRButtonDblClk(UINT nFlags, CPoint point)
{
  ExitApp();
}

void CMainFrame::OnLButtonDown(UINT nFlags, CPoint point)
{
  point.x -= m_nXOffset;
  point.y -= m_nYOffset;
  
  // Check to see if button click was inside sprite
  if( m_pSprite->HitTest( point ))
  {
    point.x += m_nXOffset;
    point.y += m_nYOffset;
    m_mousePos = point;
    m_bMoveBitmap = TRUE;
  }
}

void CMainFrame::OnLButtonUp(UINT nFlags, CPoint point)
{
  m_bMoveBitmap = FALSE;
}

void CMainFrame::OnMouseMove(UINT nFlags, CPoint point)
{
  if( (nFlags & MK_LBUTTON) == MK_LBUTTON && m_bMoveBitmap )
  {
    // Make sure the sprite doesn't go out of bounds
    int xOffset = point.x - m_mousePos.x;
    int yOffset = point.y - m_mousePos.y;
    if( m_pSprite->GetRect().left + xOffset >= 0 &&
        m_pSprite->GetRect().right + xOffset <= m_nDispWidth &&
        m_pSprite->GetRect().top + yOffset >= 0 &&
        m_pSprite->GetRect().bottom + yOffset <= m_nDispHeight )
    {
      m_pSprite->Offset( xOffset, yOffset );
      m_mousePos = point;
  
      // Clear the old area of the sprite with the background bitmap
      m_pSprite->EraseSprite(
        (LPBITMAPINFOHEADER)&m_bufferHeader, 
        (LPBYTE)m_pDispBuffer, 
        m_background );
    
      // Draw the sprite in the new position    
      m_pSprite->DrawSprite(
        (LPBITMAPINFOHEADER)&m_bufferHeader, 
        (LPBYTE)m_pDispBuffer,
        0 );
  
      // Blit the changed part of the display surface to the screen
      CRect updateRect;
      updateRect.UnionRect( m_pSprite->GetPrevRect(), m_pSprite->GetRect() );
  
      WinGBitBlt(
        m_pDC->GetSafeHdc(), 
        m_nXOffset + updateRect.left, 
        m_nYOffset + updateRect.top, 
        updateRect.Width(), updateRect.Height(),
        m_hWinGDC, 
        updateRect.left, updateRect.top); 
    }
  }
}

void CMainFrame::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
  if( nChar == VK_ESCAPE )
    ExitApp();
  else
    CFrameWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}
