// mainfrm.h : interface of the CMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __CDIB_H
#include "cdib.h"
#endif

#ifndef __PSPRITE_H
#include "psprite.h"
#endif

#ifndef __WINGPAL_H
#include "wingpal.h"
#endif

class CMainFrame : public CFrameWnd
{
  DECLARE_DYNCREATE(CMainFrame)
public: // create from serialization only
  CMainFrame();
  virtual ~CMainFrame();

// Attributes
protected:
  struct
  {
    BITMAPINFOHEADER  bih;
    RGBQUAD           aColors[256];
  } m_bufferHeader;
  int m_nDispWidth;
  int m_nDispHeight;
  HDC m_hWinGDC;
  void* m_pDispBuffer;
  HBITMAP m_hOldBitmap;
  CDC* m_pDC;
  CWinGPalette m_palette;
    
  CPhasedSprite* m_pSprite;
  CDib m_background;

  CObArray m_dibs;

  int m_nWidth;
  int m_nHeight;  
  int m_nXOffset;
  int m_nYOffset;

  int m_nTimerID;   // timer id for screen refresh

  CPoint m_mousePos;
  BOOL m_bMoveBitmap;
  BOOL m_bWindowSized;
  
// Operations
protected:
  void SetupWinG();
  void SetupPalette();
  
public:

// Implementation
public:
#ifdef _DEBUG
  virtual void AssertValid() const;
  virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
protected:
  void ExitApp();

  //{{AFX_MSG(CMainFrame)
  afx_msg BOOL OnEraseBkgnd(CDC* pDC);
  afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
  afx_msg void OnSize(UINT nType, int cx, int cy);
  afx_msg void OnRButtonDblClk(UINT nFlags, CPoint point);
  afx_msg void OnSetFocus(CWnd* pOldWnd);
  afx_msg void OnKillFocus(CWnd* pNewWnd);
  afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
  afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
  afx_msg void OnMouseMove(UINT nFlags, CPoint point);
  afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
  afx_msg void OnTimer(UINT nIDEvent);
  afx_msg void OnPaint();
	//}}AFX_MSG
  DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
