#include "stdafx.h"
#include "psprite.h"

CPhasedSprite::CPhasedSprite( CObArray* pDibArray )
{
  ASSERT( pDibArray != NULL );
  m_pDibArray = pDibArray;
  m_nNumFrames = m_pDibArray->GetSize();
  ASSERT( m_nNumFrames > 0 );
  m_nFrame = 0;
  SetDib( (CDib*)m_pDibArray->GetAt(0) );
}

CPhasedSprite::~CPhasedSprite()
{
}

int CPhasedSprite::GetNumFrames()
{
  return m_nNumFrames;
}

int CPhasedSprite::GetFrame()
{
  return m_nFrame;
}

void CPhasedSprite::SetFrame( int nFrame )
{
  ASSERT( nFrame >= 0 );
  ASSERT( nFrame < m_nNumFrames );
  m_nFrame = nFrame;
}

void CPhasedSprite::NextFrame()
{
  m_nFrame++;
  if( m_nFrame == m_nNumFrames )
    m_nFrame = 0;
  m_pDib = (CDib*)m_pDibArray->GetAt( m_nFrame );
}
