#include "stdafx.h"

#include "sprite.h"

#ifndef __CDIB_H
#include "cdib.h"
#endif

#include <dibfx.h>

CSprite::CSprite()
{
  m_pDib = NULL;
  m_rect.SetRect( 0,0,0,0 );
  m_prevRect.SetRect( 0,0,0,0 );
}

CSprite::CSprite( CDib* pDib )
{
  SetDib( pDib );
}

CSprite::~CSprite()
{
}

void CSprite::SetDib( CDib* pDib )
{
  ASSERT( pDib != NULL );
  m_pDib = pDib;
  m_rect.SetRect( 0, 0, pDib->GetWidth(), pDib->GetHeight() );
  m_prevRect.CopyRect( &m_rect );
}

int CSprite::GetHeight()
{
  return m_pDib->GetHeight();
}

int CSprite::GetWidth()
{
  return m_pDib->GetWidth();
}

CRect& CSprite::GetRect()
{
  return m_rect;
}

CRect& CSprite::GetPrevRect()
{
  return m_prevRect;
}

void CSprite::SetPrevRect()
{
  m_prevRect.CopyRect( &m_rect );
}

void CSprite::Offset( int cx, int cy )
{
  SetPrevRect(); 
  m_rect.OffsetRect( cx, cy );
}

BOOL CSprite::HitTest( CPoint& hitPoint )
{
  return m_rect.PtInRect( hitPoint );
}

void CSprite::DrawSprite( 
  LPBITMAPINFOHEADER lpBIH, 
  LPBYTE lpByte, 
  int nTransColor )
{
  // Blt the sprite onto its current position 
  DibTransparentBlt(
    lpBIH, 
    lpByte, 
    m_rect.left, m_rect.top, 
    *m_pDib,
    *m_pDib,
    0, 0, 
    m_pDib->GetWidth(), m_pDib->GetHeight(),
    nTransColor );
}

void CSprite::EraseSprite( 
  LPBITMAPINFOHEADER lpBIH, 
  LPBYTE lpByte, 
  CDib& background  )
{
  DibBlt(
    lpBIH, 
    lpByte, 
    m_prevRect.left, m_prevRect.top, 
    background,
    background,
    m_prevRect.left, m_prevRect.top, 
    m_prevRect.Width(), m_prevRect.Height() );
}

//****************************************************************************
// Passthrough to CDib
//****************************************************************************
