#ifndef __SPRITE_H
#define __SPRITE_H

#ifndef __WINGPAL_H
#include "wingpal.h"
#endif

#include <dib.h>

class CDib;
class CSprite : public CObject
{
protected:
  CSprite();
  
public:
  CSprite( CDib* pDib );
  ~CSprite();

protected:
  CDib* m_pDib;
  CRect m_rect;
  CRect m_prevRect;

  void SetDib( CDib* pDib );

public:  
  int GetWidth();
  int GetHeight();

  CRect& GetRect();
  CRect& GetPrevRect();
  void SetPrevRect();
    
  void Offset( int cx, int cy );  
  BOOL HitTest( CPoint& hitPoint );

  void DrawSprite( LPBITMAPINFOHEADER lpBIH, LPBYTE lpByte, int nTransColor );
  void EraseSprite( LPBITMAPINFOHEADER lpBIH, LPBYTE lpByte, CDib& background  );
};

#endif
