#include "stdafx.h"
#include "wingpal.h"

#include "cdib.h"

#include <memory.h>
#include <dib.h>

#define BI_WIDTH(pBI)       ((pBI)->bmiHeader.biWidth)
#define BI_HEIGHT(pBI)      ((pBI)->bmiHeader.biHeight)

#define DIB_PCLRTAB(pDIB)   ((LPRGBQUAD)(((LPSTR)((LPBITMAPINFO)(pDIB))) \
                            + sizeof(BITMAPINFOHEADER)))
#define DIB_WIDTH(pDIB)     (BI_WIDTH((LPBITMAPINFO)(pDIB)))
#define DIB_HEIGHT(pDIB)    (BI_HEIGHT((LPBITMAPINFO)(pDIB)))
#define DIB_STORAGEWIDTH(pDIB) ((DIB_WIDTH(pDIB) + 3) & ~3)
#define DIB_BISIZE(pDIB)    (sizeof(BITMAPINFOHEADER) \
                            + DibNumColors(pDIB) * sizeof(RGBQUAD))
#define DIB_PBITS(pDIB)     (((LPSTR)((LPBITMAPINFO)(pDIB))) \
                            + DIB_BISIZE(pDIB))

CWinGPalette::CWinGPalette()
{
  // Allocate memory for logical palette structure
  m_pLogPal = (LPLOGPALETTE)GlobalAllocPtr(
    GMEM_MOVEABLE,
    sizeof(LOGPALETTE) + 256 * sizeof(PALETTEENTRY));
  m_pLogPal->palVersion = 0x300;
  m_pLogPal->palNumEntries = 256;

  // Allocate memory for array of rgb quads  
  m_pRgbQuad = (LPRGBQUAD)GlobalAllocPtr( GMEM_MOVEABLE,  256 * sizeof(RGBQUAD) );

  // Get a device context for the screen
  HDC hDC = ::GetDC( NULL );
  
  // Get the firt and last 10 static colors of the palette
  GetSystemPaletteEntries( hDC, 0, 10, m_pLogPal->palPalEntry );
  GetSystemPaletteEntries( hDC, 246, 10, m_pLogPal->palPalEntry + 246 );
  
  // Don't need the dc any more
  ::ReleaseDC( NULL, hDC );

  // Copy RGB data into the RGBQUAD structures also (from the LOGPALETTE)  
  for( int nIndex=0; nIndex < 10; nIndex++ )
  {
    m_pRgbQuad[nIndex].rgbRed = m_pLogPal->palPalEntry[nIndex].peRed;
    m_pRgbQuad[nIndex].rgbGreen = m_pLogPal->palPalEntry[nIndex].peGreen;
    m_pRgbQuad[nIndex].rgbBlue = m_pLogPal->palPalEntry[nIndex].peBlue;
    m_pRgbQuad[nIndex].rgbReserved = 0;

    m_pRgbQuad[nIndex+246].rgbRed = 
      m_pLogPal->palPalEntry[nIndex+246].peRed;
    m_pRgbQuad[nIndex+246].rgbGreen = 
      m_pLogPal->palPalEntry[nIndex+246].peGreen;
    m_pRgbQuad[nIndex+246].rgbBlue = 
      m_pLogPal->palPalEntry[nIndex+246].peBlue;
    m_pRgbQuad[nIndex+246].rgbReserved = 0;
  }
      
  // Fill the unused portion with the color black
  for( nIndex=10; nIndex < 246; nIndex++ )
  {
    if( nIndex >= 10 && nIndex <= 246 )
    {
      m_pLogPal->palPalEntry[nIndex].peRed = 0;
      m_pLogPal->palPalEntry[nIndex].peGreen = 0;
      m_pLogPal->palPalEntry[nIndex].peBlue = 0;
    }
    m_pLogPal->palPalEntry[nIndex].peFlags = PC_NOCOLLAPSE;
    
    m_pRgbQuad[nIndex].rgbRed = 0;
    m_pRgbQuad[nIndex].rgbGreen = 0;
    m_pRgbQuad[nIndex].rgbBlue = 0;
    m_pRgbQuad[nIndex].rgbReserved = 0;
  }


  // The first added color will go into the 11th element in the array
  m_nPalIndex = 10;
}

CWinGPalette::~CWinGPalette()
{
  // Get rid of globally allocated memory
  GlobalFreePtr( m_pLogPal );
  GlobalFreePtr( m_pRgbQuad );
}

int CWinGPalette::AddQuad( LPRGBQUAD pRgbQuad, BOOL bCollapse /*=TRUE*/ )
{
  // Check to see if there are quads available to add colors
  if( m_nPalIndex < 246 )
  {
    BOOL bFound = FALSE;
    int nMatchIndex;
    
    // Check to see whether the color exists or not in the array
    for(int nIndex = 0; nIndex < 256 && !bFound; nIndex++ )
    {
      if (bFound =
          ( m_pLogPal->palPalEntry[nIndex].peRed == pRgbQuad->rgbRed &&
            m_pLogPal->palPalEntry[nIndex].peGreen == pRgbQuad->rgbGreen &&
            m_pLogPal->palPalEntry[nIndex].peBlue == pRgbQuad->rgbBlue )
         )
      {
        nMatchIndex = nIndex;
      }
    }
    if( !bFound || !bCollapse )
    {
      // It didn't exist, so add it to both arrays
      m_pLogPal->palPalEntry[m_nPalIndex].peRed = pRgbQuad->rgbRed;
      m_pLogPal->palPalEntry[m_nPalIndex].peGreen = pRgbQuad->rgbGreen;
      m_pLogPal->palPalEntry[m_nPalIndex].peBlue = pRgbQuad->rgbBlue;
      m_pLogPal->palPalEntry[m_nPalIndex].peFlags = PC_NOCOLLAPSE;

      m_pRgbQuad[m_nPalIndex].rgbRed = pRgbQuad->rgbRed;
      m_pRgbQuad[m_nPalIndex].rgbGreen = pRgbQuad->rgbGreen;
      m_pRgbQuad[m_nPalIndex].rgbBlue = pRgbQuad->rgbBlue;
      m_pRgbQuad[m_nPalIndex].rgbReserved = 0;
      
      return ++m_nPalIndex;
    }
    else
    {
      return nMatchIndex;
    }
    
  }
  
  return ERR_PALETTEFULL;
}

BOOL CWinGPalette::CreatePalette()
{
  return CPalette::CreatePalette( m_pLogPal );
}

void CWinGPalette::CopyQuadsTo( LPRGBQUAD lpRgbQuads, int nNumColors )
{
  // Copy the RGBQUADs to the bitmap's RGBQUADS
  _fmemcpy( lpRgbQuads, m_pRgbQuad, nNumColors*sizeof(RGBQUAD) );  
}

void CWinGPalette::AddColors( CDib& dib, BOOL bScanPixels, BOOL bCollapse /*=TRUE*/ )
{
  LPRGBQUAD pDibColors = dib.GetDibColors();
  PDIB pDib = dib;
  
  if( bScanPixels )
  {
    // This is the slow part!
    long flags[256];

    // Index in flag array represents one of 256 colors. The value in flag 
    // array is the count of colors used
    for( int nIndex=0; nIndex < 256; flags[nIndex++] = 0 );
    
    // Go through all bits of bitmap and increment flag counter
    for( int nCol=0; nCol < dib.GetWidth(); nCol++ )
    {
      for( int nRow=0; nRow < dib.GetHeight(); nRow++ )
      {
        long lWidth = DIB_STORAGEWIDTH(pDib);
    
        HPBYTE p = (HPBYTE)DIB_PBITS(pDib);
        p += (long)(DIB_HEIGHT(pDib)-nRow-1) * lWidth + (long)nCol;
        flags[*p]++;
      }
    }

    // Go get the most used color and add it to the palette
    for( nIndex=0; nIndex < 256; nIndex++ )
    {
      int nMax = 0;
      int nMaxIndex = 0;
      for( int nIndex2=0; nIndex2 < 256; nIndex2++ )
      {
        if( flags[nIndex2] > nMax )
        {
          nMax = flags[nIndex2];
          nMaxIndex = nIndex2;
        }
      }
      AddQuad( &pDibColors[nMaxIndex], bCollapse );
      flags[nMaxIndex] = 0;
    }
  }
  else
  {
    for( int nIndex=0; nIndex < DibNumColors( pDib ); nIndex++ )
    {
      AddQuad( pDibColors, bCollapse );
      pDibColors++;
    }
  }
}
