/*   Connect.C   -   Connect the Dots Program
                     Petzold
*/

#include <windows.h>

#define MAXPOINTS 1000

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);

int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdParam,
                    int    nCmdShow)
                    
  {
  static char szAppName[] = "Connect";
  HWND        hwnd;
  MSG         msg;
  WNDCLASS    wndclass;
  
  if (!hPrevInstance)
     {
     wndclass.style            = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc      = WndProc;
     wndclass.cbClsExtra       = 0;
     wndclass.cbWndExtra       = 0;
     wndclass.hInstance        = hInstance;
     wndclass.hIcon            = LoadIcon (NULL, IDI_APPLICATION);
     wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground    = GetStockObject (WHITE_BRUSH);
     wndclass.lpszMenuName     = NULL;
     wndclass.lpszClassName    = szAppName;
     
     RegisterClass(&wndclass);
     }
     
  hwnd = CreateWindow (szAppName,
                       "Connect-the-Dots Mouse Demo",
                       WS_OVERLAPPEDWINDOW, 
                       CW_USEDEFAULT,   
                       CW_USEDEFAULT,
                       CW_USEDEFAULT,   
                       CW_USEDEFAULT,   
                       NULL,
                       NULL,
                       hInstance,
                       NULL);
                       
  ShowWindow (hwnd, nCmdShow);
  UpdateWindow (hwnd);
  
  while (GetMessage (&msg, NULL, 0, 0))
    {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
    }
    
  return msg.wParam;
  }
  
long FAR PASCAL WndProc (HWND hwnd,
                         WORD message,
                         WORD wParam,
                         LONG lParam)
                         
  {
  static POINT points[MAXPOINTS];
  static short nCount;
  HDC          hdc;
  PAINTSTRUCT  ps;
  short        i, j;
    
  switch (message)
    {
    case WM_LBUTTONDOWN:
      nCount = 0;
      InvalidateRect (hwnd, NULL, TRUE);
      return 0;
      
    case WM_MOUSEMOVE:
      if (wParam & MK_LBUTTON && nCount < MAXPOINTS)
        {
        points [nCount++] = MAKEPOINT (lParam);
        hdc = GetDC (hwnd);
        SetPixel (hdc, LOWORD (lParam), HIWORD (lParam), 0l);
        ReleaseDC (hwnd, hdc);
        }
      return 0;
      
    case WM_LBUTTONUP:
      InvalidateRect (hwnd, NULL, FALSE);
      return 0;
      
    case WM_PAINT:
      hdc = BeginPaint (hwnd, &ps);
      
      for (i = 0; i < nCount - 1; i++)
        for (j = i; j < nCount; j++)
          {
          MoveTo (hdc, points[i].x, points[i].y);
          LineTo (hdc, points[j].x, points[j].y);
          }
       EndPaint (hwnd, &ps);
       return 0;
       
    case WM_DESTROY:
      PostQuitMessage (0);
      return 0;
    }
    
  return DefWindowProc (hwnd, message, wParam, lParam);
  }
                  
     