/*   OwnSize.c   -  OwnSize and Profile Program
                    Norton and Yao
*/

#include <windows.h>

#define REOPEN_NORMAL   0
#define REOPEN_ZOOM     1
#define REOPEN_DEFAULT  2


static char szAppName[] = "ownsize";
char achPr[]   = "OWNSIZE";
char achFile[] = "WIN.INI";


long FAR PASCAL WndProc  (HWND, WORD, WORD, LONG);

int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdParam,
                    int    nCmdShow)
                    
  {
  HWND        hwnd;
  MSG         msg;
  WNDCLASS    wndclass;
  int         x, y, cx, cy;
  int         iReopen;  

  if (!hPrevInstance)
    {      
     wndclass.style            = NULL;
     wndclass.lpfnWndProc      = WndProc;
     wndclass.cbClsExtra       = 0;
     wndclass.cbWndExtra       = 0;
     wndclass.hInstance        = hInstance;
     wndclass.hIcon            = LoadIcon (hInstance, szAppName);
     wndclass.hCursor          = LoadCursor (hInstance, szAppName);
     wndclass.hbrBackground    = COLOR_WINDOW + 1;
     wndclass.lpszMenuName     = NULL;
     wndclass.lpszClassName    = szAppName;
     
     RegisterClass(&wndclass);
     
     /*  for first instance only - set position & size to that of window
                                   when last ran.                           */
                                   

     cy = GetSystemMetrics (SM_CYSCREEN) -
          GetSystemMetrics (SM_CYICON)   -
         (GetSystemMetrics (SM_CYCAPTION) * 2);                                   
         
     x = GetPrivateProfileInt (achPr, "x", 0, achFile);
     y = GetPrivateProfileInt (achPr, "y", 0, achFile);
     
     cx = GetSystemMetrics (SM_CXSCREEN);
     cx = GetPrivateProfileInt (achPr, "cx", cx, achFile);
     cy = GetPrivateProfileInt (achPr, "cy", cy, achFile);
     
     iReopen = GetPrivateProfileInt (achPr, "Reopen", 0, achFile);
     
     if (iReopen == REOPEN_ZOOM)
       nCmdShow = SW_SHOWMAXIMIZED;
     
     if (iReopen == REOPEN_DEFAULT)
       {
       x  = CW_USEDEFAULT;
       cx = CW_USEDEFAULT;
       }   
    }
  else
    {
    x = cx = CW_USEDEFAULT;
    y = cy = 0;
    }   
   

  
  hwnd = CreateWindow (szAppName,
                       "OwnSize and Profile Program",
                       WS_OVERLAPPEDWINDOW,
                       x,
                       y,
                       cx,
                       cy,
                       NULL,
                       NULL,
                       hInstance,
                       NULL);
                       
                                                                                      
  ShowWindow (hwnd, nCmdShow);

/*  UpdateWindow (hwnd);  */
  
  while (GetMessage (&msg, NULL, 0, 0))
    {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
    }
    
  return msg.wParam;
  }
  
long FAR PASCAL WndProc (HWND hwnd,
                         WORD message,
                         WORD wParam,
                         LONG lParam)
                         
  {
  static int    xLeft;
  static int    yTop;
  static int    cxWidth;
  static int    cyHeight;
  
  
  switch (message)
    {
    case WM_MOVE:
      if (IsZoomed (hwnd))
        return 0;
      
      xLeft =  LOWORD (lParam);
      xLeft -= GetSystemMetrics (SM_CXFRAME);
      
      yTop  = HIWORD (lParam);
      yTop -= (GetSystemMetrics (SM_CYFRAME) + 
               GetSystemMetrics (SM_CYCAPTION) - 1);
      
      break;
               
     case WM_SIZE:
       if (IsZoomed (hwnd))
         return 0;
  
       cxWidth  = LOWORD (lParam);
       cxWidth += 2 * GetSystemMetrics (SM_CXFRAME);
       
       cyHeight  = HIWORD (lParam);
       cyHeight += (2 * GetSystemMetrics (SM_CYFRAME) + 
                        GetSystemMetrics (SM_CYCAPTION) - 1);
       break;
                        

    case WM_DESTROY:
      {
      char ach[80];
      int  iReopen;

      /*  Update private ownsize entry  */
      
      wsprintf (ach, "%d", xLeft);
      WritePrivateProfileString (achPr, "x", /*  X.  */
                                 ach, achFile);
                                 
      wsprintf (ach, "%d", yTop);                           
      WritePrivateProfileString (achPr, "y", /*  Y.  */
                                 ach, achFile);

      if (cxWidth == 0)
        cxWidth = CW_USEDEFAULT;
      
      wsprintf (ach, "%u", cxWidth);
      WritePrivateProfileString (achPr, "cx", /*  CX.  */
                                 ach, achFile);
        
      wsprintf (ach, "%d", cyHeight);
      WritePrivateProfileString (achPr, "cy", /*  CY.  */
                                 ach, achFile);
 
      /*  write  reopen flags  for iconic/zoomed windows  */
      iReopen = REOPEN_NORMAL;
      if (IsZoomed (hwnd)) 
        iReopen = REOPEN_ZOOM;
      if (IsZoomed (hwnd)) 
        iReopen = REOPEN_DEFAULT;
         
      wsprintf (ach, "%d", iReopen);
      WritePrivateProfileString (achPr, "Reopen", ach, achFile);
         
      PostQuitMessage (0);
      }
      break;
    
    default:  return (DefWindowProc (hwnd, message, wParam, lParam));
              break;
    }
    return 0L;
    
  }                  
