/*   poppad1.c   -   Popup Editor Using Child Window Edit Box
                     Petzold
*/

#include <windows.h>


long FAR PASCAL WndProc  (HWND, WORD, WORD, LONG);

int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdParam,
                    int    nCmdShow)
                    
  {
  static char szAppName[] = "poppad1";
  HWND        hwnd;
  MSG         msg;
  WNDCLASS    wndclass;
  

  if (!hPrevInstance)
    {      
     wndclass.style            = CS_HREDRAW | CS_VREDRAW;
     wndclass.lpfnWndProc      = WndProc;
     wndclass.cbClsExtra       = 0;
     wndclass.cbWndExtra       = 0;
     wndclass.hInstance        = hInstance;
     wndclass.hIcon            = NULL;
     wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground    = GetStockObject (WHITE_BRUSH);
     wndclass.lpszMenuName     = NULL;
     wndclass.lpszClassName    = szAppName;
     
     RegisterClass(&wndclass);
     
    }

  hwnd = CreateWindow (szAppName,
                       szAppName,
                       WS_OVERLAPPEDWINDOW,
                       CW_USEDEFAULT,
                       CW_USEDEFAULT,
                       GetSystemMetrics (SM_CXSCREEN) /2,
                       GetSystemMetrics (SM_CYSCREEN) /2,
                       NULL,
                       NULL,
                       hInstance,
                       NULL);
                       
                                                                                      
  ShowWindow (hwnd, nCmdShow);
  UpdateWindow (hwnd);
  
  while (GetMessage (&msg, NULL, 0, 0))
    {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
    }
    
  return msg.wParam;
  }
  
long FAR PASCAL WndProc (HWND hwnd,
                         WORD message,
                         WORD wParam,
                         LONG lParam)
                         
  {
  static HWND hwndEdit;
  
  switch (message)
    {
    case WM_CREATE:
      hwndEdit = CreateWindow ("edit",
                                NULL,
                                WS_CHILD | WS_VISIBLE | WS_VSCROLL |
                                WS_BORDER | ES_LEFT | ES_MULTILINE | 
                                ES_AUTOVSCROLL,
                                0,
                                0,
                                0,
                                0,
                                hwnd,
                                1,
                                ((LPCREATESTRUCT) lParam) -> hInstance, 
                                NULL);
                                
      return 0;
                                              
     case WM_SIZE:
       MoveWindow (hwndEdit,
                   0, 
                   0,
                   LOWORD (lParam),
                   HIWORD (lParam),
                   TRUE);
                   
       return 0;
       
     case WM_SETFOCUS:
       SetFocus (hwndEdit);
       return 0;
       
     case WM_COMMAND:
       if (wParam == 1 && HIWORD (lParam) == EN_ERRSPACE)
         MessageBox (hwnd, "Edit Control out of Space",
                     "PopPad Version 1",
                     MB_OK | MB_ICONSTOP);
         
       return 0;
       

    case WM_DESTROY:
      PostQuitMessage (0);
      return 0;
    }
    
  return DefWindowProc (hwnd, message, wParam, lParam);
  }
                  
