/*   Statline.c   -  StatLine ChildWindow Program
                     Norton and Yao
*/

#include <windows.h>
#include "statline.h"


static char szAppName[] = "StatLine";


long FAR PASCAL WndProc  (HWND, WORD, WORD, LONG);
long FAR PASCAL StatLineProc  (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL Test2(HWND, unsigned, WORD, LONG);

HWND hwndStat;
int cyChildHeight;


int PASCAL WinMain (HANDLE hInstance,
                    HANDLE hPrevInstance,
                    LPSTR  lpszCmdParam,
                    int    nCmdShow)
                    
  {
  HWND        hwnd;
  MSG         msg;
  WNDCLASS    wndclass;


  if (!hPrevInstance)
    {      
     wndclass.style            = NULL;
     wndclass.lpfnWndProc      = WndProc;
     wndclass.cbClsExtra       = 0;
     wndclass.cbWndExtra       = 0;
     wndclass.hInstance        = hInstance;
     wndclass.hIcon            = LoadIcon (NULL, IDI_APPLICATION);
     wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground    = COLOR_WINDOW + 1;
     wndclass.lpszMenuName     = "#1";
     wndclass.lpszClassName    = szAppName;
     
     RegisterClass(&wndclass);

     wndclass.style            = NULL;
     wndclass.lpfnWndProc      = StatLineProc;
     wndclass.cbClsExtra       = 0;
     wndclass.cbWndExtra       = 0;
     wndclass.hInstance        = hInstance;
     wndclass.hIcon            = NULL;
     wndclass.hCursor          = LoadCursor (NULL, IDC_ARROW);
     wndclass.hbrBackground    = COLOR_WINDOW + 1;
     wndclass.lpszMenuName     = NULL;
     wndclass.lpszClassName    = "StatLineProc";
     
     RegisterClass(&wndclass);
     

    }

  
  hwnd = CreateWindow (szAppName,
                       "Status Line Program",
                       WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
                       CW_USEDEFAULT,
                       0,
                       CW_USEDEFAULT,
                       0,
                       NULL,
                       NULL,
                       hInstance,
                       NULL);
                       
                        
  hwndStat = CreateWindow ("StatLineProc",
                           NULL,
                           WS_CHILD | WS_BORDER | WS_VISIBLE,
                           0,
                           0,
                           0,
                           0,
                           hwnd,
                           NULL,
                           hInstance,
                           NULL);
                           
  ShowWindow (hwnd, nCmdShow);       
  
  while (GetMessage (&msg, NULL, 0, 0))
    {
    TranslateMessage (&msg);
    DispatchMessage  (&msg);
    }
    
  return 0;
  }
  
long FAR PASCAL WndProc (HWND hwnd,
                         WORD message,
                         WORD wParam,
                         LONG lParam)
                         
  {

    FARPROC lpProcTest2;

    int bTest2;

  switch (message)
    {
    case WM_CREATE:
      {
      HDC hdc;
      int cyBorder;
      TEXTMETRIC tm;
      
      hdc = GetDC (hwnd);
      GetTextMetrics (hdc,&tm);
      ReleaseDC (hwnd,hdc);
      
      cyBorder = GetSystemMetrics (SM_CYBORDER);
      cyChildHeight = tm.tmHeight + cyBorder * 2;
      }
      break;
      
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
      
      case WM_COMMAND:
        if (wParam == IDM_TONY)
          {
          lpProcTest2 = MakeProcInstance(Test2, hwnd);
          bTest2 = DialogBox(hwnd, "Test2", hwnd, lpProcTest2);
          FreeProcInstance(lpProcTest2);
          if (bTest2)
            MessageBox( GetFocus(),
                        "Dialog OK'ed",
                        "Dialog Response",
                        MB_ICONINFORMATION | MB_OK);
          else
            MessageBox( GetFocus(),
                        "Dialog CANCLED",
                        "Dialog Response",
                        MB_ICONINFORMATION | MB_OK);
        }
        break;

   case WM_MENUSELECT:
     SendMessage (hwndStat, message, wParam, lParam);
     break;
     
   case WM_SIZE:
     {
     int cxWidth;
     int cyHeight;
     int xChild;
     int yChild;
     
     cxWidth = LOWORD (lParam);
     cyHeight = HIWORD (lParam);
     
     xChild = 0;
     yChild = cyHeight - cyChildHeight + 1;
     
     MoveWindow (hwndStat,
                 xChild,
                 yChild,
                 cxWidth,
                 cyChildHeight,
                 TRUE);

     }
     break;
     
   default:
      return(DefWindowProc (hwnd,message,wParam,lParam));
      break;
   }
 return 0L;
 }
 
             
    
long FAR PASCAL StatLineProc (HWND hwnd,
                              WORD message,
                              WORD wParam,
                              LONG lParam)
                         
  {

  static STATUSDATA   sd[COUNT] = 
    { 0xffff, "",
      IDM_SYS,      "Move, size or close application window",
      IDM_FILE,     "Create, open, save, print, or quit",
      IDM_EDIT,     "Undo, cut, copy, paste, and delete",
      
      IDM_NEW,      "Creates a new item",
      IDM_OPEN,     "Open an existing item",
      IDM_SAVE,     "Save an existing item",
      IDM_SAVEAS,   "Save the current item with a new name",
      IDM_PRINT,    "Prints the current item",
      IDM_EXIT,     "Quits the application",
      
      IDM_UNDO,     "Reverse the last action",
      IDM_CUT,      "Cuts the selection to the ClipBoard",
      IDM_COPY,     "Copis the selection to the ClipBoard",
      IDM_PASTE,    "Copies the selection from the ClipBoard",
      IDM_CLEAR,    "Erases the currently selected item",
      IDM_DELETE,   "Erases the currently selected item",
      
      SC_SIZE,      "Changes window size",
      SC_MOVE,      "Changes window position",
      SC_MINIMIZE,  "Reduces window to an icon",
      SC_MAXIMIZE,  "Enlarges the active window to full size",
      SC_CLOSE,     "Quits application",
      SC_RESTORE,   "Restores window to normal size",
      SC_TASKLIST,  "Switches to the Task Monitor",
      IDM_TONY,     "Test Tony's Dialog Box Procedure"
      
    };
    
    static HMENU  hmenuEdit;
    static HMENU  hmenuFile;
    static HMENU  hmenuSys;

    
    switch (message)
      {
      case WM_CREATE:
        {
        HMENU hmenu;
        HWND  hwndParent;
        
        hwndParent = GetParent (hwnd);
        hmenu = GetMenu (hwndParent);
        hmenuFile = GetSubMenu (hmenu, 0);
        hmenuEdit = GetSubMenu (hmenu, 1);
        hmenuSys = GetSystemMenu (hwndParent, 0);
        PostMessage (hwndParent, WM_CHAR, hmenuSys, 0L);
        }
        break;
        
                       
      case WM_MENUSELECT:
        {
        char ach[50];
        HDC hdc;
        int isd;
        int i;
        RECT rClient;
        WORD wFlag;
        
        wFlag = LOWORD (lParam);
        
        isd = 0;
        if (wFlag == 0xffff)
          isd = 0;
        else if (wFlag & MF_POPUP)
               {
               if (hmenuSys == wParam)
                 isd = 1;
               if (hmenuFile == wParam)
                 isd = 2;
               if (hmenuEdit == wParam)
                 isd = 3;
               }
        else
               {
               for (i = 0; i < COUNT; i++)
                 {
                 if (wParam == sd[i].wCode)
                   {
                   isd = i;
                   break;
                   }
                 }
               }
        GetClientRect (hwnd, &rClient);
        
        hdc = GetDC (hwnd);
        ExtTextOut (hdc,
                    0,
                    0,
                    ETO_OPAQUE,
                    &rClient,
                    sd[isd].achMsg,
                    lstrlen(sd[isd].achMsg),
                    NULL);
        ReleaseDC (hwnd,hdc);
        }
        break;
        
      default:
        return (DefWindowProc (hwnd, message, wParam, lParam));
        break;
      }
      
    return 0L;
  }              
        
        
/****************************************************************************

    FUNCTION: Test2(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL Test2(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    char name[80];
    char address[40];
    char city[40];
    char state[3];
    char zip[5];
    
    
    switch (message) {
        case WM_INITDIALOG:
          return (TRUE);

        case WM_COMMAND:
          if (wParam == IDOK)
            {
            EndDialog(hDlg, TRUE);
            return (TRUE);
            }
          else
            if (wParam == IDCANCEL)
             {
             EndDialog(hDlg, FALSE);
             return (FALSE);
             }
           break;
    }
    return (FALSE);
}
