//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WCOM.C

#include <windows.h>
#include <string.h>        // for strncat
#include <mem.h>           // for memmove
#include "wmserial.h"

static HWND hComPortWnd;
static HANDLE hWriteBuffer;
static LPSTR szWriteBuffer;



int InitComPort(HWND hWnd, LPSTR szCom)
   {
   DCB dcb;
   char szSettings[25];
   int nResult;

   // Save hWnd
   hComPortWnd = hWnd;

   // Open Com Port
   int nComID = OpenComm(szCom,QBUFFSIZE,QBUFFSIZE);
   if (nComID < 0)
       return nComID;

   lstrcpy(szSettings,szCom);
   lstrcat(szSettings,":");
   lstrcat(szSettings,BAUDRATE);
   lstrcat(szSettings,",");
   lstrcat(szSettings,PARITY);
   lstrcat(szSettings,",");
   lstrcat(szSettings,DATABITS);
   lstrcat(szSettings,",");
   lstrcat(szSettings,STOPBITS);
   
   nResult = BuildCommDCB(szSettings,&dcb);
   if (nResult < 0)
       return nResult;

   dcb.Id = nComID;

   // Set Com Port
   nResult = SetCommState(&dcb);
   if (nResult < 0)
       return nResult;

   // Allocate Write Buffer
   hWriteBuffer = GlobalAlloc( GMEM_MOVEABLE, QBUFFSIZE );
   if (!hWriteBuffer)
       {
       MessageBeep(MB_ICONEXCLAMATION);
       MessageBox(hWnd,"Not enough memory for initializing modem.","Example Windows Terminal",MB_ICONSTOP);
       PostMessage(hWnd,WM_CLOSE,0,0L);
       return NULL;
       }
   szWriteBuffer = (LPSTR) GlobalLock(hWriteBuffer);
   szWriteBuffer[0] = 0;

   return nComID;
   }



int CloseComPort(int nComID)
   {
   CloseComm(nComID);
   if (hWriteBuffer)
       GlobalUnlock(hWriteBuffer);
   return NULL;
   }



int ReadComPort(int nComID, LPSTR szDest, int nMaxLength)
   {
   COMSTAT ComStat;
   int nTotal = 0;
   int nResult = NULL;

   // It's usually a good idea to clear the in queue before
   // quitting.  Windows will not send another WM_COMMNOTIFY
   // if your application does not reduce the queue below
   // the threshold after you get a notice.  
   // If this seems backwards to you, you should know that 
   // it does to me, too.
   do
       {
       CheckComPort(nComID,&ComStat);

       // Check for overflow
       if (nTotal + ComStat.cbInQue > nMaxLength)
           break;

       nResult = ReadComm(nComID,&(szDest[nTotal]),ComStat.cbInQue);

       // Check for error
       if (nResult < 0)
           {
           nTotal = -nTotal - nResult;
           break;
           }

       nTotal += nResult;
       CheckComPort(nComID,&ComStat);
       } while (ComStat.cbInQue);

   return nTotal;
   }



int WriteComPort(int nComID,LPSTR szData,int nLength)
   {
   int nResult;

   if (szData != NULL) 
       strncat(szWriteBuffer,szData,nLength);

   nResult = WriteComm(nComID,szWriteBuffer,lstrlen(szWriteBuffer));

   if ( nResult > 0 )
       szWriteBuffer[0] = 0;
   else if (nResult < 0)
       {
       memmove(szWriteBuffer,&(szWriteBuffer[-nResult]),
               lstrlen(szWriteBuffer)-nResult);
       }
   return nResult;
   }



int CheckComPort(int nComID,COMSTAT *pComStat)
   {
   return GetCommError(nComID,pComStat);
   }

