//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WCONNECT.C

#include <windows.h>
#include <string.h>    // for strstr()
#include "wmserial.h"

static HWND hConnectWnd;

BOOL Connect(HWND hWnd)
   {
   BOOL bResult;

   // Save hWnd
   hConnectWnd = hWnd;

   if (!nActiveComPort)
       {
       nActiveComPort = InitComPort(hWnd,COMPORT);
       if (nActiveComPort < 0)
           {
           MessageBeep(MB_ICONEXCLAMATION);
           MessageBox(hWnd,"Could not activate COM port.","Example Windows Terminal",MB_ICONSTOP);
           PostMessage(hWnd,WM_CLOSE,0,0L);
           return FALSE;
           }
       }

   if (!bConnected)
       {
       bResult = InitModem(hWnd,nActiveComPort);
       if (!bResult)
           {
           MessageBeep(MB_ICONEXCLAMATION);
           MessageBox(hWnd,"Could not initialize modem.","Example Windows Terminal",MB_ICONSTOP);
           PostMessage(hWnd,WM_CLOSE,0,0L);
           return FALSE;
           }

       bConnected = Dial();
       if (!bConnected)
           {
           MessageBeep(MB_ICONEXCLAMATION);
           MessageBox(hWnd,"Error connecting.","Example Windows Terminal",MB_ICONSTOP);
           PostMessage(hWnd,WM_CLOSE,0,0L);
           return FALSE;
           }
       else
           {
           if (!EnableCommNotification(nActiveComPort,hWnd,32,32))
               {
               MessageBeep(MB_ICONEXCLAMATION);
               MessageBox(hWnd,"Unable to initialize Comm messages.",
                               "Example Windows Terminal",MB_ICONSTOP);
               PostMessage(hWnd,WM_CLOSE,0,0L);
               }
           bEcho = FALSE;
           } 
       }

   return TRUE;
   }



BOOL Dial(void)
   {
   int nResult;
   BOOL bReturnValue;
   HANDLE hBufferMem;
   LPSTR szModemResponse;

   // This dials Borland's Online Automated Support Service
   // change the string to ATL1M1DT14084315250\r if 
   // long distance is necessary.
   char szDialString[] = "ATL1M1DT4315250\r";

   // Get memory for response
   hBufferMem = GlobalAlloc( GMEM_MOVEABLE, QBUFFSIZE );
   if (!hBufferMem)
       {
       MessageBeep(MB_ICONEXCLAMATION);
       MessageBox(hConnectWnd,"Not enough memory for initializing modem.","Example Windows Terminal",MB_ICONSTOP);
       PostMessage(hConnectWnd,WM_CLOSE,0,0L);
       return FALSE;
       }

   szModemResponse = (LPSTR) GlobalLock(hBufferMem);

   // Send Initialization String
   nResult = WriteComPort(nActiveComPort,szDialString,lstrlen(szDialString));
   CheckComPort(nActiveComPort,NULL);
   TTYWriteScreen(szDialString);
   if (nResult < 0) 
       return FALSE;

   // Get the response
   nResult = GetModemResponse(nActiveComPort,szModemResponse,QBUFFSIZE,60);
   if (nResult <= 0) 
       return FALSE;
   else
       TTYWriteScreen(szModemResponse);

   if (strstr(szModemResponse,"CONNECT"))
       bReturnValue = TRUE;
   else
       bReturnValue = FALSE;

   GlobalUnlock(hBufferMem);
   return bReturnValue;
   }



void Disconnect(void)
   {
   bConnected = HangUpModem(nActiveComPort);
   nActiveComPort = CloseComPort(nActiveComPort);
   }
