//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WTTY.C

#include <windows.h>
#include "wmserial.h"


static HWND hTTYWnd;
static int nCurrRow, nCurrCol;
static int nRows, nCols;
static int nXChar, nYChar;



void TTYInit(HWND hWnd)
   {
   HDC hDC;
   TEXTMETRIC TextMetric;
   RECT TTYRect;

   // TTY Window Handle
   hTTYWnd = hWnd;

   // Window Position
   nCurrRow = 0;
   nCurrCol = 0;

   // Window Text Metrics
   hDC = GetDC( hTTYWnd );
   SelectObject( hDC,
                 GetStockObject( OEM_FIXED_FONT ) );
   GetTextMetrics( hDC, &TextMetric );
   ReleaseDC( hTTYWnd, hDC );
   nXChar = TextMetric.tmAveCharWidth;
   nYChar = TextMetric.tmHeight +
            TextMetric.tmExternalLeading;

   GetClientRect(hTTYWnd,&TTYRect);
   nRows = (TTYRect.bottom - TTYRect.top)  /  nYChar;
   nCols = (TTYRect.right - TTYRect.left) /  nXChar;

   return;
   }




void TTYWriteScreen( LPSTR lpOutString )
   {
   LPSTR lpCurrChar;
   HDC hDC;

   // get a device context for the client area
   hDC = GetDC( hTTYWnd );
   SelectObject( hDC, GetStockObject( OEM_FIXED_FONT ) );

   // hide caret
   HideCaret( hTTYWnd );

   for ( lpCurrChar = lpOutString; *lpCurrChar; lpCurrChar++ ) 
       {
       switch ( *lpCurrChar ) 
           {

           // BACKSPACE
           case '\b':
               if (nCurrCol)
                   nCurrCol--;
               break;

           // CARRAIGE RETURN
           case '\r':         
               nCurrCol = 0;
               break;



           // NEW LINE
           case '\n':               
               nCurrRow++;
               if ( nCurrRow == ( nRows - 1 ) ) 
                   {
                   ValidateRect( hTTYWnd, NULL );
                   ScrollWindow( hTTYWnd, 0, -nYChar, NULL, NULL );
                   UpdateWindow( hTTYWnd );
                   nCurrRow = nRows - 2;
                   }
               break;


           // OTHERS...
           default:    
               TextOut( hDC, nCurrCol * nXChar, nCurrRow * nYChar,
                       lpCurrChar, 1 );
               nCurrCol++;
               if ( nCurrCol == ( nCols - 1 ) ) 
                   {
                   // move to the next line
                   nCurrCol = 0;
                   nCurrRow++;

                   // check whether window needs to be scrolled
                   if ( nCurrRow == ( nRows - 1 ) ) 
                       {
                       ValidateRect( hTTYWnd, NULL );
                       ScrollWindow( hTTYWnd, 0, -nYChar, NULL, NULL );
                       UpdateWindow( hTTYWnd );
                       nCurrRow = nRows - 2;
                       }
                   }
               break;
           }
       }

   // update the caret position and show it
   SetCaretPos( nCurrCol * nXChar, nCurrRow * nYChar );
   ShowCaret( hTTYWnd );

   // release the device context
   ReleaseDC( hTTYWnd, hDC );
   }


void TTYSetFocus(void)
   {
   CreateCaret( hTTYWnd, NULL, nXChar, nYChar );
   SetCaretPos( nCurrCol * nXChar, nCurrRow * nYChar );
   ShowCaret( hTTYWnd );
   }
