/* WNDCLASS.H v1.0 Copyright (c) 1993, 1994 Burnham Park Software, Inc. */
#ifndef __WNDCLASS_H
#define __WNDCLASS_H

#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifndef __MEM_H
#include <mem.h>
#endif

#define CW_FIRSTCHILD 500

#define DBFUNC BOOL FAR PASCAL _export
#define WNDPROC long FAR PASCAL _export

#define BLACK RGB(0, 0, 0)
#define DARKBLUE RGB(0, 0, 128)
#define DARKGREEN RGB(0, 128, 0)
#define DARKCYAN RGB(0, 128, 128)
#define DARKRED RGB(128, 0, 0)
#define DARKMAGENTA RGB(128, 0, 128)
#define DARKYELLOW RGB(128, 128, 0)
#define DARKGREY RGB(128, 128, 128)
#define GREY RGB(192, 192, 192)
#define BLUE RGB(0, 0, 255)
#define GREEN RGB(0, 255, 0)
#define CYAN RGB(0, 255, 255)
#define RED RGB(255, 0, 0)
#define MAGENTA RGB(255, 0, 255)
#define YELLOW RGB(255, 255, 0)
#define WHITE RGB(255, 255, 255)

#define wabs(a) (((a) >= 0) ? (a) : (0 - (a)))
#define wmax(a, b) (((a) > (b)) ? (a) : (b))
#define wmin(a, b) (((a) < (b)) ? (a) : (b))
#define wdir(a, b) (((a) == (b)) ? 0 : (((b) > (a)) ? 1 : -1))

typedef LONG (FAR PASCAL *LPFN)(HWND, unsigned int, unsigned int, LONG);

class BASEWINDOW_CLASS{
  protected:
    HWND hwnd;
  public:
    HWND Get() { return hwnd; }
    void Set(HWND wnd) { hwnd = wnd; }
    BOOL Show(int input) { return ShowWindow(hwnd, input); }
    BOOL Show() { return Show(SW_SHOWNORMAL); }
    BOOL ShowMaximized() { return Show(SW_SHOWMAXIMIZED); }
    void Update() { UpdateWindow(hwnd); }
    LONG SendMessage(UINT message, WPARAM wparam, LPARAM lparam)
     { return ::SendMessage(hwnd, message, wparam, lparam); }
    LONG SendMessage(UINT message, WPARAM wparam)
     { return SendMessage(message, wparam, 0L); }
    LONG SendMessage(UINT message) { return SendMessage(message, 0); }
    void SendCommand(WPARAM wparam, LPARAM lparam)
     { ::SendMessage(hwnd, WM_COMMAND, wparam, lparam); }
    void SendCommand(WPARAM wparam) { SendCommand(wparam, 0L); }
    void PostMessage(UINT message, WPARAM wparam, LPARAM lparam)
     { ::PostMessage(hwnd, message, wparam, lparam); }
    void PostMessage(UINT message, WPARAM wparam)
     { PostMessage(message, wparam, 0L); }
    void PostMessage(UINT message) { PostMessage(message, 0); }
    void PostCommand(WPARAM wparam, LPARAM lparam)
     { ::PostMessage(hwnd, WM_COMMAND, wparam, lparam); }
    void PostCommand(WPARAM wparam) { PostCommand(wparam, 0L); }
    void GetWindowText(LPSTR string, int length)
     { ::GetWindowText(hwnd, string, length); }
    void SetWindowText(LPSTR string)
     { ::SetWindowText(hwnd, string); }
    void Invalidate(const RECT FAR *rect, BOOL erase)
     { InvalidateRect(hwnd, rect, erase); }
    void Invalidate(BOOL erase) { Invalidate(NULL, erase); }
    void Invalidate() { Invalidate(NULL, FALSE); }
    void GetRect(RECT FAR *rect) { GetWindowRect(hwnd, rect); }
    void GetClientRect(RECT FAR *rect) { ::GetClientRect(hwnd, rect); }
};

class WINDOW_CLASS : public BASEWINDOW_CLASS{
  protected:
    struct{
      LPSTR lpClassName, lpWindowName, lpParam;
      DWORD dwStyle;
      int X, Y, nWidth, nHeight;
      HWND hWndParent;
      HMENU hMenu;
      HANDLE hInstance;
    } wnd;
  public:
    WINDOW_CLASS(HANDLE input1, LPSTR input2){
      wnd.lpClassName = input2;
      wnd.lpWindowName = NULL;
      wnd.dwStyle = WS_OVERLAPPEDWINDOW;
      wnd.X = CW_USEDEFAULT;
      wnd.Y = CW_USEDEFAULT;
      wnd.nWidth = CW_USEDEFAULT;
      wnd.nHeight = CW_USEDEFAULT;
      wnd.hWndParent = NULL;
      wnd.hMenu = NULL;
      wnd.hInstance = input1;
      wnd.lpParam = NULL;
    }
    void Create() { hwnd = CreateWindow(wnd.lpClassName, wnd.lpWindowName,
     wnd.dwStyle, wnd.X, wnd.Y, wnd.nWidth, wnd.nHeight, wnd.hWndParent,
     wnd.hMenu, wnd.hInstance, wnd.lpParam); }
    void Display(int input){
      Create();
      Show(input);
      Update();
    }
    void Display() { Display(SW_SHOWNORMAL); }
    void DisplayMaximized() { Display(SW_SHOWMAXIMIZED); }
    void lpClassName(LPSTR input) { wnd.lpClassName = input; }
    void lpWindowName(LPSTR input) { wnd.lpWindowName = input; }
    void dwStyle(DWORD input) { wnd.dwStyle = input; }
    void X(int input) { wnd.X = input; }
    void Y(int input) { wnd.Y = input; }
    void nWidth(int input) { wnd.nWidth = input; }
    void nHeight(int input) { wnd.nHeight = input; }
    void hWndParent(HWND input) { wnd.hWndParent = input; }
    void hMenu(HMENU input) { wnd.hMenu = input; }
    virtual void hInstance(HANDLE input) { wnd.hInstance = input; }
    void lpParam(LPSTR input) { wnd.lpParam = input; }
    HWND Getchild() { return GetWindow(hwnd, GW_CHILD); }
    HANDLE LoadAccelerators(char* input)
     { return ::LoadAccelerators(wnd.hInstance, input); }
    HANDLE LoadAccelerators()
     { return ::LoadAccelerators(wnd.hInstance, wnd.lpClassName); }
};

class WINDOWMESSAGE_CLASS : public WINDOW_CLASS{
  protected:
    MSG msg;
  public:
    WINDOWMESSAGE_CLASS(HANDLE input1, LPSTR input2) : WINDOW_CLASS(input1, input2) { }
    HWND Getmsghwnd() { return msg.hwnd; }
    UINT Getmsgmessage() { return msg.message; }
    WPARAM GetmsgwParam() { return msg.wParam; }
    LPARAM GetmsglParam() { return msg.lParam; }
    int TranslateAccelerator(HANDLE haccel)
     { return ::TranslateAccelerator(hwnd, haccel, &msg); }
    int TranslateMDISysAccel()
     { return ::TranslateMDISysAccel(Getchild(), &msg); }
    int IsDialogMessage(HWND hmodeless)
     { return ::IsDialogMessage(hmodeless, &msg); } 
    int TestMessage() { return GetMessage(&msg, NULL, 0, 0); }
    void DoMessage(){
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    void AccelMessage(HANDLE haccel)
     { if(TranslateAccelerator(haccel) == FALSE) DoMessage(); }
    void ModelessMessage(HWND hmodeless){
      if(hmodeless == NULL || IsDialogMessage(hmodeless) == FALSE)
       DoMessage();
    }
    void ModelessAccelMessage(HWND hmodeless, HANDLE haccel){
      if(hmodeless == NULL || IsDialogMessage(hmodeless) == FALSE)
       AccelMessage(haccel);
    }
};

class WINDOWACCEL_CLASS : public WINDOWMESSAGE_CLASS{
  protected:
    HANDLE haccel;
  public:
    WINDOWACCEL_CLASS(HANDLE input1, LPSTR input2) : WINDOWMESSAGE_CLASS(input1, input2) { }
    void LoadAccelerators(char* input)
     { haccel = WINDOW_CLASS::LoadAccelerators(input); }
    void LoadAccelerators()
     { haccel = WINDOW_CLASS::LoadAccelerators(); }
    int TranslateAccelerator()
     { return WINDOWMESSAGE_CLASS::TranslateAccelerator(haccel); }
    void AccelMessage() { WINDOWMESSAGE_CLASS::AccelMessage(haccel); }
    void ModelessAccelMessage(HWND hmodeless){
      if(hmodeless == NULL || IsDialogMessage(hmodeless) == FALSE)
       AccelMessage();
    }
};

class EDITWINDOW_CLASS : public virtual WINDOW_CLASS{
  public:
    EDITWINDOW_CLASS(HANDLE input1, HWND input2) : WINDOW_CLASS(input1,
     "edit"){
      wnd.dwStyle = WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
       WS_BORDER | ES_LEFT | ES_MULTILINE | ES_AUTOHSCROLL |
       ES_AUTOVSCROLL;
      wnd.hWndParent = input2;
    }
    EDITWINDOW_CLASS(LONG input1, HWND input2) :
     WINDOW_CLASS(((LPCREATESTRUCT)input1)->hInstance, "edit"){
      wnd.dwStyle = WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
       WS_BORDER | ES_LEFT | ES_MULTILINE | ES_AUTOHSCROLL |
       ES_AUTOVSCROLL;
      wnd.hWndParent = input2;
    }
    void SetFocus() { ::SetFocus(hwnd); }
    void MoveWindow(LONG input)
      { ::MoveWindow(hwnd, 0, 0, LOWORD(input), HIWORD(input), TRUE); }
};

class BUTTONWINDOW_CLASS : public virtual WINDOW_CLASS{
  public:
    BUTTONWINDOW_CLASS(HANDLE input1, HWND input2) : WINDOW_CLASS(input1,
     "button"){
      wnd.dwStyle = WS_CHILD | WS_VISIBLE;
      wnd.hWndParent = input2;
    }
};

class LISTBOXWINDOW_CLASS : public virtual WINDOW_CLASS{
  public:
    LISTBOXWINDOW_CLASS(HANDLE input1, HWND input2) : WINDOW_CLASS(input1,
     "listbox"){
      wnd.dwStyle = WS_CHILD | WS_VISIBLE | LBS_STANDARD;
      wnd.hWndParent = input2;
    }
    void Reset() { BASEWINDOW_CLASS::SendMessage(LB_RESETCONTENT); }
    int Addstring(LPSTR string)
     { return BASEWINDOW_CLASS::SendMessage(LB_ADDSTRING, 0, (LPARAM)string); }
    int Insertstring(LPSTR string, int index)
     { return BASEWINDOW_CLASS::SendMessage(LB_INSERTSTRING, index, (LPARAM)string); }
    int Deletestring(int index)
     { return BASEWINDOW_CLASS::SendMessage(LB_DELETESTRING, index); }
    void Setredraw(int flag)
     { BASEWINDOW_CLASS::SendMessage(WM_SETREDRAW, flag); }
    void Setredraw() { Setredraw(TRUE); }
    void Resetredraw() { Setredraw(FALSE); }
    LONG Getcount() { return BASEWINDOW_CLASS::SendMessage(LB_GETCOUNT); }
    LONG Getsel() { return BASEWINDOW_CLASS::SendMessage(LB_GETCURSEL); }
    void Setsel(int index) { BASEWINDOW_CLASS::SendMessage(LB_SETCURSEL, index); }
    int Selectstring(LPSTR string, int index)
     { return BASEWINDOW_CLASS::SendMessage(LB_SELECTSTRING, index, (LPARAM)string); }
    int Selectstring(LPSTR string) { return Selectstring(string, -1); }
    int Gettextlen(int index)
     { return BASEWINDOW_CLASS::SendMessage(LB_GETTEXTLEN, index); }
    int Gettext(LPSTR string, int index)
     { return BASEWINDOW_CLASS::SendMessage(LB_GETTEXT, index, (LPARAM)string); }
    void Setmultiplesel(int index, int flag)
     { BASEWINDOW_CLASS::SendMessage(LB_SETSEL, flag, (LPARAM)index); }
    void Setmultiplesel(int index) { Setmultiplesel(index, TRUE); }
    void Resetmultiplesel(int index) { Setmultiplesel(index, FALSE); }
    void Setmultipleall(int flag) { Setmultiplesel(-1, flag); }
    void Setmultipleall() { Setmultipleall(TRUE); }
    void Resetmultipleall() { Setmultipleall(FALSE); }
};

class DIALOGBOXWINDOW_CLASS : public virtual BASEWINDOW_CLASS{
  protected:
    BOOL error;
  public:
    DIALOGBOXWINDOW_CLASS(HWND input) { hwnd = input; }
    int Getnoerror() { return error > 0; }
    void CheckButton(int control, int state)
     { CheckDlgButton(hwnd, control, state); }
    void CheckButton(int control)
     { CheckButton(control, TRUE); }
    void UncheckButton(int control)
     { CheckButton(control, FALSE); }
    void GrayButton(int control)
     { CheckButton(control, 2); }
    void CheckRadio(int first, int last, int checked)
     { CheckRadioButton(hwnd, first, last, checked); }
    void CheckRadio(int first, int last)
     { CheckRadio(first, last, first); }
    void End(int value) { ::EndDialog(hwnd, value); }
    void End() { End(FALSE); }
    HWND GetItem(int control) { return GetDlgItem(hwnd, control); }
    int GetInt(int control, int sign)
     { return GetDlgItemInt(hwnd, control, &error, sign); }
    int GetInt(int control) { return GetInt(control, TRUE); }
    void GetText(int control, LPSTR string, int chars)
     { GetDlgItemText(hwnd, control, string, chars); }
    void GetText(int control, LPSTR string)
     { GetText(control, string, 255); }
    void SetInt(int control, int value, int sign)
     { SetDlgItemInt(hwnd, control, value, sign); }
    void SetInt(int control, int value)
     { SetInt(control, value, FALSE); }
    void SetText(int control, LPSTR string)
     { SetDlgItemText(hwnd, control, string); }
    int IsButtonChecked(int control)
     { return IsDlgButtonChecked(hwnd, control); }
    void HideItem(int control) { ShowWindow(GetItem(control), SW_HIDE); }
    void ShowItem(int control) { ShowWindow(GetItem(control), SW_SHOW); }
    void EnableItem(int control, int flag) { EnableWindow(GetItem(control), flag); }
    void EnableItem(int control) { EnableItem(control, TRUE); }
    void DisableItem(int control) { EnableItem(control, FALSE); }
    void EnableOK(int flag) { EnableItem(IDOK, flag); }
    void EnableOK() { EnableOK(TRUE); }
    void DisableOK() { EnableOK(FALSE); }
    LONG SendItemMessage(int control, UINT message, WPARAM wparam, LPARAM lparam)
     { return SendDlgItemMessage(hwnd, control, message, wparam, lparam); }
    LONG SendItemMessage(int control, UINT message, WPARAM wparam)
     { return SendItemMessage(control, message, wparam, 0L); }
    LONG SendItemMessage(int control, UINT message)
     { return SendItemMessage(control, message, 0, 0L); }
    void LimitText(int control, int length)
     { SendItemMessage(control, EM_LIMITTEXT, length); }
    void SetLimitText(int control, LPSTR string, int length){
      LimitText(control, length);
      SetText(control, string);
    }
    void SetLimitInt(int control, int value, int length){
      LimitText(control, length);
      SetInt(control, value);
    }
    void SetScrollRange(int control, int range)
     { ::SetScrollRange(GetDlgItem(hwnd, control), SB_CTL, 0, range - 1, FALSE); }
    void SetScrollPos(int control, int position)
     { ::SetScrollPos(GetDlgItem(hwnd, control), SB_CTL, position, TRUE); }
    void ListboxReset(int control)
     { SendItemMessage(control, LB_RESETCONTENT); }
    int ListboxAdd(int control, LPSTR string)
     { return SendItemMessage(control, LB_ADDSTRING, 0, (LPARAM)string); }
    int ListboxInsert(int control, int index, LPSTR string)
     { return SendItemMessage(control, LB_INSERTSTRING, index, (LPARAM)string); }
    int ListboxInsert(int control, LPSTR string)
     { return SendItemMessage(control, LB_INSERTSTRING, -1, (LPARAM)string); }
    int ListboxGetcount(int control)
     { return SendItemMessage(control, LB_GETCOUNT); }
    int ListboxGetsel(int control)
     { return SendItemMessage(control, LB_GETCURSEL); }
    int ListboxGetdata(int control, int index)
     { return SendItemMessage(control, LB_GETITEMDATA, index); }
    void ListboxGettext(int control, int index, LPSTR string)
     { string[SendItemMessage(control, LB_GETTEXT, index, (LPARAM)string)] = 0; }
    void ListboxSetsel(int control, int selection)
     { SendItemMessage(control, LB_SETCURSEL, selection); }
    void ListboxSetdata(int control, int index, long data)
     { SendItemMessage(control, LB_SETITEMDATA, data); }
    void ListboxSettabstops(int control, int tabs, int *stops)
     { SendItemMessage(control, LB_SETTABSTOPS, tabs, (LPARAM)(int far*)stops); }
    void ListboxSettabstop(int control, int tab)
     { ListboxSettabstops(control, 1, &tab); }
    void ListboxDelete(int control, int index)
     { SendItemMessage(control, LB_DELETESTRING, index); }
    BOOL FileList(int control, int text, char *filespec)
     { return DlgDirList(hwnd, filespec, control, text, 0); }
    BOOL FileList(int control, char *filespec)
     { return FileList(control, 0, filespec); }
    BOOL FileList(int control)
     { return FileList(control, "*.*"); }
    BOOL DirectoryList(int control, int text, char *filespec)
     { return DlgDirList(hwnd, filespec, control, text, 0x0c010); }
    BOOL DirectoryList(int control, char *filespec)
     { return DirectoryList(control, 0, filespec); }
    BOOL DirectoryList(int control)
     { return DirectoryList(control, "*.*"); }
    BOOL DirectorySelect(int control, char *filespec)
     { return DlgDirSelect(hwnd, filespec, control); }
};

class MDICLIENTWINDOW_CLASS : public virtual BASEWINDOW_CLASS{
  protected:
    CLIENTCREATESTRUCT clientcreate;
    DWORD dwstyle;
    HWND hwndParent;
    HANDLE hinstance;
  public:
    MDICLIENTWINDOW_CLASS(HANDLE input1, HWND input2, int input3){
      hwndParent = input2;
      hinstance = input1;
      dwstyle = WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE;
      clientcreate.idFirstChild = CW_FIRSTCHILD;
      clientcreate.hWindowMenu = GetSubMenu(input2, input3);
    }
    void Create(){
      hwnd = CreateWindow("MDICLIENT", NULL, dwstyle, 0, 0, 0, 0, hwndParent,
       1, hinstance, (LPSTR)&clientcreate);
    }
    void Cascade() { SendMessage(WM_MDICASCADE); }
    void Tile() { SendMessage(WM_MDITILE); }
    void Arrange() { SendMessage(WM_MDIICONARRANGE); }
    HWND Gethwnd() { return hwnd; }
};

class MDICHILDWINDOW_CLASS : public virtual BASEWINDOW_CLASS{
  protected:
    MDICREATESTRUCT mdicreate;
  public:
    MDICHILDWINDOW_CLASS(HANDLE input1, LPSTR input2, LPSTR input3){
      mdicreate.szClass = input2;
      mdicreate.szTitle = input3;
      mdicreate.hOwner = input1;
      mdicreate.x = CW_USEDEFAULT;
      mdicreate.y = CW_USEDEFAULT;
      mdicreate.cx = CW_USEDEFAULT;
      mdicreate.cy = CW_USEDEFAULT;
      mdicreate.style = 0;
      mdicreate.lParam = NULL;
    }
    void Create(HWND hwndclient){
      hwnd = ::SendMessage(hwndclient, WM_MDICREATE, 0,
       (LPARAM)(LPMDICREATESTRUCT)&mdicreate);
    }
    HWND Gethwnd() { return hwnd; }
};

class MOVEWINDOW_CLASS : public BASEWINDOW_CLASS{
  protected:
    RECT xy, pxy;
    unsigned char flag;
  public:
    MOVEWINDOW_CLASS() { flag = FALSE; }
    int GetLEFT() { return xy.left; }
    int GetTOP() { return xy.top; }
    int GetRIGHT() { return xy.right; }
    int GetBOTTOM() { return xy.bottom; }
    void Start(HWND input){
      hwnd = input;
      if(flag == FALSE){
        GetWindowRect(hwnd, &xy);
	flag = TRUE;
      }
      else MoveWindow(hwnd, xy.left, xy.top, xy.right - xy.left,
       xy.bottom - xy.top, FALSE);
    }
    void Move() { GetWindowRect(hwnd, &xy); }
    void Move(int dx, int dy){
      xy.left += dx;
      xy.right += dx;
      xy.top += dy;
      xy.bottom += dy;
      MoveWindow(hwnd, xy.left, xy.top, xy.right - xy.left,
       xy.bottom - xy.top, FALSE);
    }
    void Center(HWND input){
      GetWindowRect(input, &pxy);
      pxy.left = pxy.left + (pxy.right - pxy.left) / 2 - (xy.right - xy.left) / 2 - xy.left;
      pxy.top = pxy.top + (pxy.bottom - pxy.top) / 2 - (xy.bottom - xy.top) / 2 - xy.top;
      Move(pxy.left, pxy.top);
    }
    void Center() { Center(GetParent(hwnd)); }
};

class WND_CLASS{
  protected:
    WNDCLASS wc;
  public:
    WND_CLASS(HANDLE input1, LPSTR input2, LPFN input3){
      wc.style = CS_HREDRAW | CS_VREDRAW;
      wc.lpfnWndProc = input3;
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;
      wc.hInstance = input1;
      wc.hIcon = ::LoadIcon(NULL, IDI_APPLICATION);
      wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
      wc.hbrBackground = COLOR_WINDOW + 1;
      wc.lpszMenuName = NULL;
      wc.lpszClassName = input2;
    }
    BOOL Register(HANDLE input){
      if(!input) RegisterClass(&wc);
      return input;
    }
    BOOL Register() { return RegisterClass(&wc); }
    void LoadIcon(LPSTR input)
     { wc.hIcon = ::LoadIcon(wc.hInstance, input); }
    void LoadIcon()
     { wc.hIcon = ::LoadIcon(wc.hInstance, wc.lpszClassName); }
    void LoadCursor(LPSTR input)
      { wc.hCursor = ::LoadCursor(wc.hInstance, input); }
    void LoadCursor()
      { wc.hCursor = ::LoadCursor(wc.hInstance, wc.lpszClassName); }
    void style(WORD input) { wc.style = input; }
    void lpfnWndProc(LPFN input) { wc.lpfnWndProc = input; }
    void cbClsExtra(int input) { wc.cbClsExtra = input; }
    void cbWndExtra(int input) { wc.cbWndExtra = input; }
    virtual void hInstance(HANDLE input) { wc.hInstance = input; }
    void hIcon(HICON input) { wc.hIcon = input; }
    void hCursor(HCURSOR input) { wc.hCursor = input; }
    void hbrBackground(HBRUSH input) { wc.hbrBackground = input; }
    void lpszMenuName(LPSTR input) { wc.lpszMenuName = input; }
    void lpszMenuName() { wc.lpszMenuName = wc.lpszClassName; }
    void lpszClassName(LPSTR input) { wc.lpszClassName = input; }
};

class INSTANCE_CLASS{
  protected:
    HANDLE hinstance;
  public:
    INSTANCE_CLASS() { hinstance = NULL; }
    INSTANCE_CLASS(HANDLE input) { hinstance = input; }
    HANDLE Get() { return hinstance; }
    void Set(HANDLE input) { hinstance = input; }
    HBITMAP LoadBitmap(LPSTR bitmap) { return ::LoadBitmap(hinstance, bitmap); }
    HCURSOR LoadCursor(LPSTR cursor) { return ::LoadCursor(hinstance, cursor); }
    HICON LoadIcon(LPSTR icon) { return ::LoadIcon(hinstance, icon); }
    HMENU LoadMenu(LPSTR menu) { return ::LoadMenu(hinstance, menu); }
    HGLOBAL LoadResource(HRSRC resource)
     { return ::LoadResource(hinstance, resource); }
};

class LOCALMEMORY_CLASS{
  protected:
    LOCALHANDLE hmem;
    NPSTR p_mem;
    unsigned int num;
  public:
    LOCALMEMORY_CLASS(){
      hmem = NULL;
      p_mem = NULL;
      num = 0;
    }
    int Alloc(int input1, int input2){
      Free();
      num = input2;
      hmem = LocalAlloc(input1, input2);
      return hmem;
    }
    int Alloc(int input) { return Alloc(LHND, input); }
    int Allocchar(int input) { return Alloc(LHND, input); }
    int Allocint(int input)
     { return Alloc(input * sizeof(int)); }
    int Allocfloat(int input) { return Alloc(input * sizeof(float)); }
    void Lock() { if(hmem) p_mem = LocalLock(hmem); }
    void Unlock() { if(hmem) LocalUnlock(hmem); }
    void Free(){
      if(hmem){
	LocalFree(hmem);
	hmem = NULL;
      }
      p_mem = NULL;
      num = 0;
    }
    LOCALHANDLE Gethmem() { return hmem; }
    void Sethmem(LOCALHANDLE input) { hmem = input; }
    int Getlen() { return num; }
    int Getlenchar() { return num; }
    int Getlenint() { return num / sizeof(int); }
    int Getlenfloat() { return num / sizeof(float); }
    char Getchar(int input) { return *(p_mem + input); }
    int Getint(int input) { return *((int far*)p_mem + input); }
    float Getfloat(int input) { return *((float far*)p_mem + input); }
    void Setchar(int input1, char input2) { *(p_mem + input1) = input2; }
    void Setint(int input1, int input2) { *((int far*)p_mem + input1) = input2; }
    void Setfloat(int input1, float input2)
     { *((float far*)p_mem + input1) = input2; }
    void Set(HWND hwnd) { SetWindowWord(hwnd, 0, hmem); }
    void Get(HWND hwnd) { hmem = GetWindowWord(hwnd, 0); }
    LPSTR Getp_mem() { return p_mem; }
};

class LOCALARRAY_CLASS : public virtual LOCALMEMORY_CLASS{
  protected:
    int dim1, dim2;
  public:
    LOCALARRAY_CLASS() { dim1 = dim2 = 0; }
    int Alloc(int input1, int input2){
      dim1 = input1;
      dim2 = input2;
      return LOCALMEMORY_CLASS::Alloc(input1 * input2);
    }
    int Allocchar(int input1, int input2) { return Alloc(input1, input2); }
    int Allocint(int input1, int input2)
     { return Alloc(input1 * sizeof(int), input2 * sizeof(int)); }
    int Allocfloat(int input1, int input2)
     { return Alloc(input1 * sizeof(float), input2 * sizeof(float)); }
    char Getchar(int input1, int input2)
     { return LOCALMEMORY_CLASS::Getchar(input1 * dim2 + input2); }
    int Getint(int input1, int input2)
     { return LOCALMEMORY_CLASS::Getint(input1 * dim2 + input2); }
    float Getfloat(int input1, int input2)
     { return LOCALMEMORY_CLASS::Getfloat(input1 * dim2 + input2); }
    void Setchar(int input1, int input2, char data)
     { LOCALMEMORY_CLASS::Setchar(input1 * dim2 + input2, data); }
    void Setint(int input1, int input2, int data)
     { LOCALMEMORY_CLASS::Setint(input1 * dim2 + input2, data); }
    void Setfloat(int input1, int input2, float data)
     { LOCALMEMORY_CLASS::Setfloat(input1 * dim2 + input2, data); }
};

class LOCALSTRUCT_CLASS : public virtual LOCALMEMORY_CLASS{
  protected:
    NPSTR p_struct;
    unsigned int pnt, len, lck, sze, tmp;
  public:
    LOCALSTRUCT_CLASS(int input){
      hmem = NULL;
      p_mem = NULL;
      pnt = len = lck = 0;
      sze = input;
    }  
    void LockUp(){
      if(hmem){
	if(lck == 0) Lock();
	lck++;
      }
      else lck = 0;
      p_struct = p_mem + pnt * sze;
    }
    void LockDown(){
      if(hmem){
        lck--;
	if(lck == 0) Unlock();
      }
      else lck = 0;
    }
    void Alloc(int input){
      len = input;
      LOCALMEMORY_CLASS::Alloc((DWORD)len * sze);
    }
    void Free(){
      LOCALMEMORY_CLASS::Free();
      p_struct = NULL;
      pnt = len = lck = 0;
    }
    void Add(){
      tmp = lck;
      pnt = len;
      len++;
      Unlock();
      if(len > 1){
	hmem = LocalReAlloc(hmem, len * sze, LHND);
	LockUp();
	_fmemset(p_mem + pnt * sze, 0, sze);
	LockDown();
      }
      else hmem = LocalAlloc(LHND, sze);
      if(tmp){
        Lock();
	if(tmp > 1) lck = tmp;
      }
    }
    void Remove(){
      len--;
      if(len){
        if(pnt < len){
          LockUp();
	  _fmemmove(p_mem + pnt * sze, p_mem + len * sze, sze);
          LockDown();
	}
	tmp = lck;
        Unlock();
        hmem = GlobalReAlloc(hmem, len * sze, LHND);
        if(tmp){
          Lock();
	  if(tmp > 1) lck = tmp;
        }
      }
      else Free();
    }
    void Insert(int place){
      Add();
      if(place < pnt)
       _fmemmove(p_mem + place * sze, p_mem + (place + 1) * sze, sze * (pnt - place));
    }
    void Insert() { Insert(pnt); }
    void Delete(int place){
      pnt = place;
      Remove();
    }
    void Delete() { Remove(); }
    void First(){
      pnt = 0;
      p_struct = p_mem;
    }
    void Last(){
      pnt = len - 1;
      p_struct = p_mem + pnt * sze;;
    }
    int Next(){
      if(pnt < len - 1){
        pnt++;
	p_struct += sze;
        return TRUE;
      }
      else return FALSE;
    }
    int Prev(){
      if(pnt){
        pnt--;
	p_struct -= sze;
        return TRUE;
      }
      else return FALSE;
    }
    int Getlen() { return len; }
    int Getpnt() { return pnt; }
    int Getsze() { return sze; }
    LPSTR Getp_struct() { return p_struct; }
    LPSTR Getp_struct(int index) { return p_mem + index * sze; }
    void Setpnt(int index){
      pnt = index;
      if(p_mem) p_struct = p_mem + pnt * sze;
    }
    int Test() { return len > pnt; }
};

class GLOBALMEMORY_CLASS{
  protected:
    GLOBALHANDLE hmem;
    LPSTR p_mem;
    DWORD num;
  public:
    GLOBALMEMORY_CLASS(){
      hmem = NULL;
      p_mem = NULL;
      num = 0;
    }
    int Alloc(int input1, DWORD input2){
      Free();
      num = input2;
      hmem = GlobalAlloc(input1, input2);
      return hmem;
    }
    int Alloc(DWORD input) { return Alloc(GHND, input); }
    int Allocchar(DWORD input) { return Alloc(GHND, input); }
    int Allocint(DWORD input) { return Alloc(input * sizeof(int)); }
    int Allocfloat(DWORD input) { return Alloc(input * sizeof(float)); }
    void Lock() { if(hmem) p_mem = GlobalLock(hmem); }
    void Unlock() { if(hmem) GlobalUnlock(hmem); }
    void Free(){
      if(hmem){
	GlobalFree(hmem);
	hmem = NULL;
      }
      p_mem = NULL;
      num = 0;
    }
    DWORD Getlen() { return num; }
    DWORD Getcharlen() { return num; }
    DWORD Getlenint() { return num / sizeof(int); }
    DWORD Getlenfloat() { return num / sizeof(float); }
    char Getchar(DWORD input) { return *(p_mem + input); }
    int Getint(DWORD input) { return *((int far*)p_mem + input); }
    float Getfloat(DWORD input) { return *((float far*)p_mem + input); }
    void Setchar(DWORD input1, char input2) { *(p_mem + input1) = input2; }
    void Setint(DWORD input1, int input2) { *((int far*)p_mem + input1) = input2; }
    void Setfloat(DWORD input1, float input2) { *((float far*)p_mem + input1) = input2; }
    LPSTR Getp_mem() { return p_mem; }
};

class GLOBALARRAY_CLASS : public virtual GLOBALMEMORY_CLASS{
  protected:
    unsigned int dim1, dim2;
  public:
    GLOBALARRAY_CLASS() { dim1 = dim2 = 0; }
    int Alloc(int input1, int input2){
      dim1 = input1;
      dim2 = input2;
      return GLOBALMEMORY_CLASS::Alloc(input1 * input2);
    }
    int Allocchar(int input1, int input2) { return Alloc(input1, input2); }
    int Allocint(int input1, int input2)
     { return Alloc(input1 * sizeof(int), input2 * sizeof(int)); }
    int Allocfloat(int input1, int input2)
     { return Alloc(input1 * sizeof(float), input2 * sizeof(float)); }
    char Getchar(int input1, int input2)
     { return GLOBALMEMORY_CLASS::Getchar(input1 * dim2 + input2); }
    int Getint(int input1, int input2)
     { return GLOBALMEMORY_CLASS::Getint(input1 * dim2 + input2); }
    float Getfloat(int input1, int input2)
     { return GLOBALMEMORY_CLASS::Getfloat(input1 * dim2 + input2); }
    void Setchar(int input1, int input2, char data)
     { GLOBALMEMORY_CLASS::Setchar(input1 * dim2 + input2, data); }
    void Setint(int input1, int input2, int data)
     { GLOBALMEMORY_CLASS::Setint(input1 * dim2 + input2, data); }
    void Setfloat(int input1, int input2, float data)
     { GLOBALMEMORY_CLASS::Setfloat(input1 * dim2 + input2, data); }
};

class GLOBALSTRUCT_CLASS : public virtual GLOBALMEMORY_CLASS{
  protected:
    LPSTR p_struct;
    unsigned int pnt, len, lck, sze, tmp;
  public:
    GLOBALSTRUCT_CLASS(int input){
      hmem = NULL;
      p_mem = NULL;
      pnt = len = lck = 0;
      sze = input;
    }
    void LockUp(){
      if(hmem){
	if(lck == 0) Lock();
	lck++;
      }
      else lck = 0;
      p_struct = p_mem + pnt * sze;
    }
    void LockDown(){
      if(hmem){
        lck--;
	if(lck == 0) Unlock();
      }
      else lck = 0;
    }
    void Alloc(int input){
      len = input;
      GLOBALMEMORY_CLASS::Alloc((DWORD)len * sze);
    }
    void Free(){
      GLOBALMEMORY_CLASS::Free();
      p_struct = NULL;
      pnt = len = lck = 0;
    }
    void Add(){
      tmp = lck;
      pnt = len;
      len++;
      Unlock();
      if(len > 1){
	hmem = GlobalReAlloc(hmem, len * sze, GHND);
	LockUp();
        _fmemset(p_mem + pnt * sze, 0, sze);
	LockDown();
      }
      else hmem = GlobalAlloc(GHND, sze);
      if(tmp){
        Lock();
	if(tmp > 1) lck = tmp;
      }
    }
    void Remove(){
      len--;
      if(len){
        if(pnt < len){
          LockUp();
	  _fmemmove(p_mem + pnt * sze, p_mem + len * sze, sze);
          LockDown();
	}
	tmp = lck;
        Unlock();
        hmem = GlobalReAlloc(hmem, len * sze, GHND);
        if(tmp){
          Lock();
	  if(tmp > 1) lck = tmp;
        }
      }
      else Free();
    }
    void Insert(int place){
      Add();
      if(place < pnt)
       _fmemmove(p_mem + place * sze, p_mem + (place + 1) * sze, sze * (pnt - place));
    }
    void Insert() { Insert(pnt); }
    void Delete(int place){
      pnt = place;
      Remove();
    }
    void Delete() { Remove(); }
    void First(){
      pnt = 0;
      p_struct = p_mem;
    }
    void Last(){
      pnt = len - 1;
      p_struct = p_mem + pnt * sze;;
    }
    int Next(){
      if(pnt < len - 1){
        pnt++;
	p_struct += sze;
        return TRUE;
      }
      else return FALSE;
    }
    int Prev(){
      if(pnt){
        pnt--;
	p_struct -= sze;
        return TRUE;
      }
      else return FALSE;
    }
    int Getlen() { return len; }
    int Getpnt() { return pnt; }
    int Getsze() { return sze; }
    LPSTR Getp_struct() { return p_struct; }
    LPSTR Getp_struct(int index) { return p_mem + index * sze; }
    void Setpnt(int index){
      pnt = index;
      if(p_mem) p_struct = p_mem + pnt * sze;
    }
    int Test() { return len > pnt; }
};

class DIALOGBOX_CLASS{
  protected:
    HANDLE hinstance;
    HWND hwnd, hdlg;
    FARPROC DialogBoxFN;
    int value;
  public:
    DIALOGBOX_CLASS(HANDLE handle) {
      hinstance = handle;
      hdlg = hwnd = NULL;
      DialogBoxFN = NULL;
    }
    DIALOGBOX_CLASS(HANDLE handle, HWND hinput) {
      hinstance = handle;
      hwnd = hinput;
      hdlg = NULL;
      DialogBoxFN = NULL;
    }
    int DialogBox(HWND hinput, FARPROC farproc, LPSTR name){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBox(hinstance, name, hinput, DialogBoxFN);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int DialogBox(FARPROC farproc, LPSTR name){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBox(hinstance, name, hwnd, DialogBoxFN);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int DialogBoxParam(HWND hinput, FARPROC farproc, LPSTR name, LPARAM lparam){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBoxParam(hinstance, name, hinput, DialogBoxFN, lparam);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int DialogBoxParam(FARPROC farproc, LPSTR name, LPARAM lparam){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBoxParam(hinstance, name, hwnd, DialogBoxFN, lparam);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int DialogBoxInt(HWND hinput, FARPROC farproc, LPSTR name, int input)
     { return DialogBoxParam(hinput, farproc, name, MAKELPARAM(input, 0)); }
    int DialogBoxInt(FARPROC farproc, LPSTR name, int input)
     { return DialogBoxParam(hwnd, farproc, name, MAKELPARAM(input, 0)); }
    int ChildDialogBox(HWND hwnd, FARPROC farproc, LPSTR name){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBox(hinstance, name, GetParent(hwnd), DialogBoxFN);
      SetFocus(hwnd);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int ChildDialogBoxParam(HWND hwnd, FARPROC farproc, LPSTR name, LPARAM lparam){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      value = ::DialogBoxParam(hinstance, name, GetParent(hwnd), DialogBoxFN, lparam);
      SetFocus(hwnd);
      FreeProcInstance(DialogBoxFN);
      return value;
    }
    int ChildDialogBoxInt(HWND hwnd, FARPROC farproc, LPSTR name, int input)
     { return ChildDialogBoxParam(hwnd, farproc, name, MAKELPARAM(input, 0)); }
    HWND CreateDialog(HWND hinput, FARPROC farproc, LPSTR name){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      hdlg = ::CreateDialog(hinstance, name, hinput, DialogBoxFN);
      return hdlg;
    }
    HWND CreateDialog(FARPROC farproc, LPSTR name){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      hdlg = ::CreateDialog(hinstance, name, hwnd, DialogBoxFN);
      return hdlg;
    }
    HWND CreateDialogParam(HWND hinput, FARPROC farproc, LPSTR name, LPARAM lparam){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      hdlg = ::CreateDialogParam(hinstance, name, hinput, DialogBoxFN, lparam);
      return hdlg;
    }
    HWND CreateDialogParam(FARPROC farproc, LPSTR name, LPARAM lparam){
      DialogBoxFN = MakeProcInstance(farproc, hinstance);
      hdlg = ::CreateDialogParam(hinstance, name, hwnd, DialogBoxFN, lparam);
      return hdlg;
    }
    HWND CreateDialogInt(HWND hinput, FARPROC farproc, LPSTR name, int input)
     { return CreateDialogParam(hinput, farproc, name, MAKELPARAM(input, 0)); }
    HWND CreateDialogInt(FARPROC farproc, LPSTR name, int input)
     { return CreateDialogParam(hwnd, farproc, name, MAKELPARAM(input, 0)); }
    void Free() { if(DialogBoxFN) FreeProcInstance(DialogBoxFN); }
    void Destroy(){
      if(hdlg){
	DestroyWindow(hdlg);
	hdlg = NULL;
      }
      Free();
    }
};

class FILE_CLASS{
  protected:
    OFSTRUCT of;
    HANDLE hfile;
    BYTE eof;
    union{
      char b;
      int i;
      float f;
    };
    void read(LPSTR input1, int input2)
     { eof = _lread(hfile, input1, input2) - input2; }
  public:
    FILE_CLASS() { hfile = NULL; }
    ~FILE_CLASS() { if(hfile) _lclose(hfile); };
    BYTE* GetszPathName() { return of.szPathName; }
    int GetEOF() { return eof; }
    int Open(LPSTR input1, int input2)
     { return hfile = OpenFile(input1, &of, input2); }
    int OpenRead(LPSTR input)
     { return hfile = OpenFile(input, &of, OF_READ); }
    int OpenWrite(LPSTR input)
     { return hfile = OpenFile(input, &of, OF_WRITE); }
    BYTE ReadBYTE(){
      read((LPSTR)&b, sizeof(b));
      return b;
    }
    char Readchar(){
      read((LPSTR)&b, sizeof(b));
      return b;
    }
    void WriteBYTE(char input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    void Writechar(char input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    WORD ReadWORD(){
      read((LPSTR)&i, sizeof(i));
      return i;
    }
    WORD Readint(){
      read((LPSTR)&i, sizeof(i));
      return i;
    }
    void WriteWORD(int input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    void Writeint(int input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    float ReadFLOAT(){
      read((LPSTR)&f, sizeof(f));
      return f;
    }
    float Readfloat(){
      read((LPSTR)&f, sizeof(f));
      return f;
    }
    void WriteFLOAT(float input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    void Writefloat(float input) { _lwrite(hfile, (LPSTR)&input, sizeof(input)); }
    void ReadBuffer(LPSTR input1, int input2) { read(input1, input2); }
    void WriteBuffer(LPSTR input1, int input2)
     { _lwrite(hfile, input1, input2); }
    long Position() { return _llseek(hfile, 0L, 1); }
    void Seek(long input1, int input2) { _llseek(hfile, input1, input2); }
    void Seek(long input) { _llseek(hfile, input, 0); }
    void Close(){
      if(hfile){
	_lclose(hfile);
	hfile = NULL;
      }
    }
};

class TIMER_CLASS : public BASEWINDOW_CLASS{
  protected:
    int timer;
    HANDLE hinstance;
    FARPROC timerproc;
  public:
    TIMER_CLASS(HANDLE input){
      timer = 0;
      hinstance = input;
      hwnd = NULL;
      timerproc = NULL;
    }
    void Set(HWND input1, int input2, FARPROC input3){
      Kill();
      hwnd = input1;
      timerproc = MakeProcInstance(input3, hinstance);
      if(hwnd == NULL) timer = SetTimer(hwnd, NULL, input2, timerproc);
      else{
	timer = 1;
	SetTimer(hwnd, timer, input2, timerproc);
      }
    }
    void Set(HWND input1, FARPROC input2) { Set(input1, 200, input2); }
    void Set(FARPROC input) { Set(NULL, input); }
    void Setmessage(HWND input1, int input2){
      Kill();
      hwnd = input1;
      timer = 1;
      SetTimer(hwnd, timer, input2, NULL);
    }
    void Setmessage(HWND input) { Setmessage(input, 200); }
    void Kill(){
      if(timer){
	KillTimer(hwnd, timer);
	timer = 0;
      }
      if(timerproc) FreeProcInstance(timerproc);
      hwnd = NULL;
    }
};

class CURSOR_CLASS{
  protected:
    HCURSOR hcursor;
  public:
    CURSOR_CLASS() { hcursor = NULL; }
    HCURSOR Get() { return hcursor; }
    void Set(HCURSOR cursor) { hcursor = SetCursor(cursor); }
    void Show() { ShowCursor(TRUE); }
    void Hide() { ShowCursor(FALSE); }
    void SetARROW() { hcursor = SetCursor(LoadCursor(NULL, IDC_ARROW)); }
    void SetWAIT() { hcursor = SetCursor(LoadCursor(NULL, IDC_WAIT)); }
    void SetCROSS() { hcursor = SetCursor(LoadCursor(NULL, IDC_CROSS)); }
    void SetUPARROW()
     { hcursor = SetCursor(LoadCursor(NULL, IDC_UPARROW)); }
    void SetSIZENWSE()
     { hcursor = SetCursor(LoadCursor(NULL, IDC_SIZENWSE)); }
    void Restore() { hcursor = SetCursor(hcursor); }
    void Destroy(){
      Set(hcursor);
      DestroyCursor(hcursor);
      hcursor = NULL;
    }
};

class MOUSE_CLASS{
  protected:
    HWND hwnd;
    POINT point;
  public:
    MOUSE_CLASS(HWND input) { hwnd = input; }
    void GetClientPos(){
      GetCursorPos(&point);
      ScreenToClient(hwnd, &point);
    }
    int Getx() { return point.x; }
    int Gety() { return point.y; }
};

class MENU_CLASS{
  protected:
    HMENU hmenu;
    HWND hwnd;
  public:
    MENU_CLASS(HWND input) { hwnd = input; }
    MENU_CLASS(HANDLE hinstance, HWND input1, LPSTR input2){
      hwnd = input1;
      hmenu = LoadMenu(hinstance, input2);
    }
    void Get() { hmenu = GetMenu(hwnd); }
    void Set() { SetMenu(hwnd, hmenu); }
    int GetState(int input1, int input2)
     { return GetMenuState(hmenu, input1, input2); }
    int GetState(int input)
     { return GetState(input, MF_BYCOMMAND); }
    void CheckItem(int input1, int input2)
     { CheckMenuItem(hmenu, input1, input2); }
    void EnableItem(int input1, int input2)
     { EnableMenuItem(hmenu, input1, input2); }
};

class HELP_CLASS{
  protected:
    HWND hwnd;
    char far *helpfile;
  public:
    HELP_CLASS(HWND input1, char far *input2){
      hwnd = input1;
      helpfile = input2;
    }
    void HelpIndex() { WinHelp(hwnd, helpfile, HELP_CONTENTS, 0l); }
    void Help(int input) { WinHelp(hwnd, helpfile, HELP_CONTEXT, input); }
};

class BASEDC_CLASS{
  protected:
    HDC hdc;
  public:
    BASEDC_CLASS() { hdc = NULL; }
    HDC GetHDC() { return hdc; }
    void SetHDC(HDC input) { hdc = input; }
    void Delete(){
      DeleteDC(hdc);
      hdc = NULL;
    }
    void Compatible(HDC input) { hdc = CreateCompatibleDC(input); }
    HANDLE Select(HANDLE handle) { return SelectObject(hdc, handle); }
    void SetPixel(int x, int y, COLORREF color)
     { ::SetPixel(hdc, x, y, color); }
    void MoveTo(int x, int y) { ::MoveTo(hdc, x, y); }
    void LineTo(int x, int y) { ::LineTo(hdc, x, y); }
    void HorizontallineTo(int x1, int x2, int y){
      MoveTo(x1, y);
      LineTo(x2, y);
    }
    void Horizontalline(int x1, int x2, int y){
      MoveTo(x1, y);
      LineTo(x2 + wdir(x1, x2), y);
    }
    void VerticallineTo(int y1, int y2, int x){
      MoveTo(x, y1);
      LineTo(x, y2);
    }
    void Verticalline(int y1, int y2, int x){
      MoveTo(x, y1);
      LineTo(x, y2 + wdir(y1, y2));
    }
    void LineTo(int x1, int y1, int x2, int y2){
      MoveTo(x1, y1);
      LineTo(x2, y2);
    }
    void Line(int x1, int y1, int x2, int y2){
      if(y1 == y2) Horizontalline(x1, x2, y1);
      else if(x1 == x2) Verticalline(y1, y2, x1);
      else{
        MoveTo(x1, y1);
        if(wabs(y1 - y2) == wabs(x1 - x2))
         LineTo(x2 + wdir(x1, x2), y2 + wdir(y1, y2));
        else if(wabs(y1 - y2) > wabs(x1 - x2))
         LineTo(x2, y2 + wdir(y1, y2));
        else
	 LineTo(x2 + wdir(x1, x2), y2);
      }
    }
    void Rectangle(int right, int top, int left, int bottom)
     { ::Rectangle(hdc, right, top, left, bottom); }
    void Rectangle(RECT *rect)
     { Rectangle(rect->right, rect->top, rect->left, rect->bottom); }
    void DrawIcon(int x, int y, HICON hicon)
     { ::DrawIcon(hdc, x, y, hicon); }
    void SetTextColor(COLORREF color) { ::SetTextColor(hdc, color); }
    void SetTextColor(int r, int g, int b)
     { BASEDC_CLASS::SetTextColor(RGB(r, g, b)); }
    void SetBkColor(COLORREF color) { ::SetBkColor(hdc, color); }
    void SetBkColor(int r, int g, int b)
     { BASEDC_CLASS::SetBkColor(RGB(r, g, b)); }
    void SetBkMode(int mode) { ::SetBkColor(hdc, mode); }
    void SetBkTRANSPARENT() { BASEDC_CLASS::SetBkMode(TRANSPARENT); }
    void SetBkOPAQUE() { BASEDC_CLASS::SetBkMode(OPAQUE); }
    void TextOut(int x, int y, LPCSTR string)
     { ::TextOut(hdc, x, y, string, lstrlen(string)); }
    void DPtoLP(POINT FAR *input1, int input2)
     { ::DPtoLP(hdc, input1, input2); }
};

class DC_CLASS : public BASEDC_CLASS{
  protected:
    HWND hwnd;
    COLORREF rgb;
  public:
    DC_CLASS() : BASEDC_CLASS() { hwnd = NULL; }
    DC_CLASS(HWND input) : BASEDC_CLASS() { hwnd = input; }
    ~DC_CLASS(){ if(hdc) Release(); }
    void Get() { hdc = GetDC(hwnd); }
    void Get(HWND input){
      hwnd = input;
      Get();
    }
    void Release(){
      if(hdc){
        if(hwnd) ReleaseDC(hwnd, hdc);
	hdc = NULL;
      }
    }
    void SetRGB(COLORREF color) { rgb = color; }
    void SetRGB(int r, int g, int b) { rgb = RGB(r, g, b); }
    void SetPixelRGB(int x, int y) { BASEDC_CLASS::SetPixel(x, y, rgb); }
    void SetTextColorRGB() { BASEDC_CLASS::SetTextColor(rgb); }
    void SetBkColorRGB() { BASEDC_CLASS::SetBkColor(rgb); }
};

class PAINT_CLASS : public DC_CLASS{
  protected:
    PAINTSTRUCT ps;
  public:
    PAINT_CLASS() : DC_CLASS() { }
    PAINT_CLASS(HWND input) : DC_CLASS(input) { }
    ~PAINT_CLASS() { if(hwnd) EndPaint(hwnd, &ps); }
    void Begin() { if(hwnd) hdc = BeginPaint(hwnd, &ps); }
    void Begin(HWND input){
      hwnd = input;
      Begin();
    }
    void End(){
      if(hwnd){
	EndPaint(hwnd, &ps);
	hwnd = NULL;
	hdc = NULL;
      }
    }
    int Getleft() { return ps.rcPaint.left; }
    int Getright() { return ps.rcPaint.right; }
    int Gettop() { return ps.rcPaint.top; }
    int Getbottom() { return ps.rcPaint.bottom; }
    RECT *Getrect() { return &ps.rcPaint; }
    void Rectangle() { DC_CLASS::Rectangle(&ps.rcPaint); }
    void Rectangle(int right, int top, int left, int bottom)
     { DC_CLASS::Rectangle(right, top, left, bottom); }
    void Rectangle(RECT *rect) { DC_CLASS::Rectangle(rect); }
};

class TEXT_CLASS : public virtual DC_CLASS{
  protected:
    TEXTMETRIC tm;
  public:
    TEXT_CLASS() : DC_CLASS() { }
    TEXT_CLASS(HWND hwnd) : DC_CLASS(hwnd) { Get(); }
    void Get(HDC input){
      if(hdc) Release();
      hdc = input; 
      if(hdc) GetTextMetrics(hdc, &tm);
    }
    void Get(){
      if(hdc == NULL) DC_CLASS::Get();
      if(hdc) GetTextMetrics(hdc, &tm);
      Release();
    }
    int GetHeight() { return tm.tmHeight; }
    int GetAscent() { return tm.tmAscent; }
    int GetDescent() { return tm.tmDescent; }
    int GetInternalLeading() { return tm.tmInternalLeading; }
    int GetExternalLeading() { return tm.tmExternalLeading; }
    int GetAveCharWidth() { return tm.tmAveCharWidth; }
    int GetMaxCharWidth() { return tm.tmMaxCharWidth; }
    int GetWeight() { return tm.tmWeight; }
    int GetOverhang() { return tm.tmOverhang; }
    int GetDigitizedAspectX() { return tm.tmDigitizedAspectX; }
    int GetDigitizedAspectY() { return tm.tmDigitizedAspectY; }
};

class BRUSH_CLASS : public virtual PAINT_CLASS{
  protected:
    HBRUSH hbrush;
  public:
    BRUSH_CLASS() : PAINT_CLASS() { hbrush = NULL; }
    BRUSH_CLASS(HWND input) : PAINT_CLASS(input) { hbrush = NULL; }
    virtual void CreateSolid(COLORREF input)
     { hbrush = CreateSolidBrush(input); }
    virtual void CreateSolid(int r, int g, int b) { CreateSolid(RGB(r, g, b)); }
    void CreateSolid() { hbrush = CreateSolidBrush(rgb); }
    void GetStock(int input) { hbrush = GetStockObject(input); }
    HANDLE Select() { return hbrush = DC_CLASS::Select(hbrush); }
    void Delete(){
      if(hbrush){
	DeleteObject(hbrush);
        hbrush = NULL;
      }
    }
    void SelectDelete(){
      Select();
      Delete();
    }
    virtual void SelectSolid(int r, int g, int b){
      CreateSolid(r, g, b);
      Select();
    }
    virtual void SelectSolid(COLORREF input){
      CreateSolid(input);
      Select();
    }
    void SelectSolid(){
      CreateSolid();
      Select();
    }
    void FrameRect(RECT *rect) { ::FrameRect(hdc, rect, hbrush); }
};

class PEN_CLASS : public virtual PAINT_CLASS{
  protected:
    HPEN hpen;
  public:
    PEN_CLASS() : PAINT_CLASS() { hpen = NULL; }
    PEN_CLASS(HWND hwnd) : PAINT_CLASS(hwnd) { hpen = NULL; }
    void CreatePen(int style, int width, COLORREF color)
     { hpen = ::CreatePen(style, width, color); }
    void CreateSolid(int width, COLORREF color)
     { CreatePen(PS_SOLID, width, color); }
    virtual void CreateSolid(COLORREF color)
     { CreateSolid(0, color); }
    virtual void CreateSolid(int r, int g, int b) { CreateSolid(RGB(r, g, b)); }
    void CreateDot(int width, COLORREF color){
      if(width > 0) CreatePen(PS_DOT, width, color);
      else CreatePen(PS_DOT, 1, color);
    }
    void CreateDot(COLORREF color) { CreateDot(1, color); }
    void GetStock(int input) { hpen = GetStockObject(input); }
    HANDLE Select() { return hpen = DC_CLASS::Select(hpen); }
    void Delete(){
      if(hpen){
	DeleteObject(hpen);
        hpen = NULL;
      }
    }
    void SelectDelete(){
      Select();
      Delete();
    }
    void SelectPen(int style, int width, COLORREF color){
      CreatePen(style, width, color);
      Select();
    }
    void SelectPen(int style, int width){
      CreatePen(style, width, rgb);
      Select();
    }
    void SelectSolid(int width, COLORREF color)
     { SelectPen(PS_SOLID, width, color); }
    void SelectSolid(COLORREF color) { SelectSolid(0, color); }
    void SelectSolid(int r, int g, int b) { SelectSolid(RGB(r, g, b)); }
    void SelectSolid() { SelectSolid(rgb); }
    void SelectDot(int width, COLORREF color)
     { SelectPen(PS_DOT, width, color); }
    void SelectDot(COLORREF color) { SelectDot(1, color); }
    void SelectDot(int r, int g, int b) { SelectDot(RGB(r, g, b)); }
    void SelectDot() { SelectDot(rgb); }
    void SelectStock(int input){
      GetStock(input);
      Select();
    }
};

class BRUSHPEN_CLASS : public virtual PAINT_CLASS, public virtual BRUSH_CLASS,
 public virtual PEN_CLASS{
  public:
    BRUSHPEN_CLASS() : BRUSH_CLASS() , PEN_CLASS() { }
    BRUSHPEN_CLASS(HWND input) : PAINT_CLASS(input), BRUSH_CLASS(input) , PEN_CLASS(input) { }
    void CreateSolid(COLORREF input){
      BRUSH_CLASS::CreateSolid(input);
      PEN_CLASS::CreateSolid(input);
    }
    void CreateSolid(COLORREF brush, COLORREF pen){
      BRUSH_CLASS::CreateSolid(brush);
      PEN_CLASS::CreateSolid(pen);
    }
    void CreateSolid(int r, int g, int b) { CreateSolid(RGB(r, g, b)); }
    void Select(){
      BRUSH_CLASS::Select();
      PEN_CLASS::Select();
    }
    void Delete(){
      BRUSH_CLASS::Delete();
      PEN_CLASS::Delete();
    }
    void SelectDelete(){
      Select();
      Delete();
    }
    void SelectSolid(COLORREF input){
      CreateSolid(input);
      Select();
    }
    void SelectSolid(int r, int g, int b) { SelectSolid(RGB(r, g, b)); }
    void SelectSolid() { SelectSolid(rgb); }
    void SelectSolid(COLORREF brush, COLORREF pen){
      CreateSolid(brush, pen);
      Select();
    }
};

class BITMAP_CLASS : public PAINT_CLASS{
  protected:
    HBITMAP hbm;
    BITMAP bm;
    HDC hdcmem;
    unsigned char flag;
  public:
    BITMAP_CLASS() : PAINT_CLASS(){
      hbm = NULL;
      hdcmem = NULL;
      flag = FALSE;
    }
    BITMAP_CLASS(HWND input) : PAINT_CLASS(input){
      hbm = NULL;
      hdcmem = NULL;
      flag = FALSE;
    }
    ~BITMAP_CLASS() { Cleanup(); }
    HDC GetHDCMEM() { return hdcmem; }
    HBITMAP GetHBITMAP() { return hbm; }
    void Load(HANDLE input1, LPSTR input2){
      hbm = LoadBitmap(input1, input2);
      flag = TRUE;
    }
    void Setbitmap(HBITMAP input) { hbm = input; }
    void Setup(){
      if(hdcmem == NULL) hdcmem = CreateCompatibleDC(hdc);
      if(hbm){
        GetObject(hbm, sizeof(BITMAP), (LPSTR)&bm);
        hbm = ::SelectObject(hdcmem, hbm);
      }
    }
    void Setup(HBITMAP input){
      hbm = input;
      Setup();
    }
    void Setup(int dx, int dy, int del){
      hdcmem = CreateCompatibleDC(hdc);
      hbm = CreateCompatibleBitmap(hdc, dx, dy);
      if(hbm){
        GetObject(hbm, sizeof(BITMAP), (LPSTR)&bm);
        hbm = ::SelectObject(hdcmem, hbm);
      }
      flag = del;
    }
    void Setup(int dx, int dy) { Setup(dx, dy, TRUE); }
    void Cleanup(){
      hbm = ::SelectObject(hdcmem, hbm);
      if(hdcmem){
        DeleteDC(hdcmem);
        hdcmem = NULL;
      }
      if(hbm && flag) DeleteObject(hbm);
      hbm = NULL;
      hdc = NULL;
    }
    void Draw(int x, int y, int dx, int dy)
     { BitBlt(hdc, x, y, dx, dy, hdcmem, 0, 0, SRCCOPY); }
    virtual void Draw(int x, int y) { Draw(x, y, bm.bmWidth, bm.bmHeight); }
    virtual void Draw() { Draw(0, 0); }
    void Drawup(int x, int y, int dx, int dy){
      Setup();
      BitBlt(hdc, x, y, dx, dy, hdcmem, 0, 0, SRCCOPY);
      Cleanup();
    }
    void Draw(HBITMAP hbitmap, int x, int y, int dx, int dy){
      hbm = ::SelectObject(hdcmem, hbitmap);
      BitBlt(hdc, x, y, dx, dy, hdcmem, 0, 0, SRCCOPY);
    }
    void Drawpartial(int x, int y, int dx, int dy)
     { BitBlt(hdc, 0, 0, dx, dy, hdcmem, x, y, SRCCOPY); }
    void Drawpartial(int dstx, int dsty, int srcx, int srcy, int dx, int dy)
     { BitBlt(hdc, dstx, dsty, dx, dy, hdcmem, srcx, srcy, SRCCOPY); }
    void Stretch(int x, int y, int dx1, int dy1, int dx2, int dy2)
     { StretchBlt(hdc, x, y, dx1, dy1, hdcmem, 0, 0, dx2, dy2, SRCCOPY); }
    void Stretch(int x1, int y1, int dx1, int dy1, int x2, int y2, int dx2, int dy2)
     { StretchBlt(hdc, x1, y1, dx1, dy1, hdcmem, x2, y2, dx2, dy2, SRCCOPY); }
    void Stretch(int dx, int dy)
     { StretchBlt(hdc, 0, 0, dx, dy, hdcmem, 0, 0, bm.bmWidth, bm.bmHeight,
      SRCCOPY); }
    void Stretch(HBITMAP hbitmap, int x, int y, int dx1, int dy1, int dx2, int dy2){
      ::SelectObject(hdcmem, hbitmap);
      StretchBlt(hdc, x, y, dx1, dy1, hdcmem, 0, 0, dx2, dy2, SRCCOPY);
    }
    void StretchUp(int x, int y, int dx1, int dy1, int dx2, int dy2){
       Setup();
       StretchBlt(hdc, x, y, dx1, dy1, hdcmem, 0, 0, dx2, dy2, SRCCOPY);
       Cleanup();
    }
};

class BITMAPCONVERT_CLASS : public virtual BITMAP_CLASS{
  protected:
    POINT size, origin;
  public:
    BITMAPCONVERT_CLASS(HWND hwnd) : BITMAP_CLASS(hwnd) { }
    void Convert(){
      GetObject(hbm, sizeof(BITMAP), (LPSTR)&bm);
      size.x = bm.bmWidth;
      size.y = bm.bmHeight;
      DPtoLP(&size, 1);
      origin.x = 0;
      origin.y = 0;
      DPtoLP(&origin, 1);
    }
    void Setup(){
      BITMAP_CLASS::Setup();
      SetMapMode(hdcmem, GetMapMode(hdc));
      Convert();
    }
    void Setup(HBITMAP input){
      hbm = input;
      BITMAPCONVERT_CLASS::Setup();
    }
    void Draw(int x, int y){
      Setup();
      BitBlt(hdc, x, y, size.x, size.y, hdcmem, origin.x, origin.y,
       SRCCOPY);
      Cleanup();
    }
    void Draw() { Draw(0, 0); }
    void Draw(HBITMAP hbitmap, int x, int y){
      ::SelectObject(hdcmem, hbitmap);
      BitBlt(hdc, x, y, size.x, size.y, hdcmem, origin.x, origin.y,
       SRCCOPY);
    }
};

class FONT_CLASS : public virtual DC_CLASS{
  protected:
    LOGFONT logfont;
    HFONT hfont;
  public:
    FONT_CLASS(){
      logfont.lfHeight = 0;
      logfont.lfWidth = 0;
      logfont.lfEscapement = 0;
      logfont.lfOrientation = 0;
      logfont.lfWeight = 0;
      logfont.lfItalic = FALSE;
      logfont.lfUnderline = FALSE;
      logfont.lfStrikeOut = FALSE;
      logfont.lfCharSet = 0;
      logfont.lfOutPrecision = 0;
      logfont.lfClipPrecision = 0;
      logfont.lfQuality = 0;
      logfont.lfPitchAndFamily = 0;
      logfont.lfFaceName[0] = NULL;
      hfont = NULL;
    }
    void Create() { hfont = CreateFontIndirect(&logfont); }
    void Select() { if(hfont) DC_CLASS::Select(hfont); }
    void Delete(){
      DeleteObject(hfont);
      hfont = NULL;
    }
};

class PRINT_CLASS : public BASEDC_CLASS{
  protected:
    int error;
    RECT band;
  public:
    PRINT_CLASS(){
      error = FALSE;
      SetRectEmpty(&band);
    } 
    void Startdoc(LPSTR string){
      string[wmin(lstrlen(string), 31)] = 0;
      error = Escape(hdc, STARTDOC, lstrlen(string), string, NULL);
      if(error > 0) error = 0;
      else if(error == 0) error = SP_ERROR;
    }
    void Newframe(){
      error = Escape(hdc, NEWFRAME, NULL, NULL, NULL);
      if(error > 0) error = 0;
      else if(error == 0) error = SP_ERROR;
    }
    int Nextband(){
      error = Escape(hdc, NEXTBAND, NULL, NULL, &band);
      if(error > 0) error = 0;
      else if(error == 0) error = SP_ERROR;
      return error == FALSE && IsRectEmpty(&band) == FALSE;
    }
    void Enddoc(){
      error = Escape(hdc, ENDDOC, NULL, NULL, NULL);
      if(error > 0) error = 0;
      else if(error == 0) error = SP_ERROR;
    }
    void Setabortproc(FARPROC abortproc){
      error = Escape(hdc, SETABORTPROC, 0, (LPSTR)abortproc, NULL);
      if(error > 0) error = 0;
      else if(error == 0) error = SP_ERROR;
    }
    int Geterror() { return error; }
    int Getleft() { return band.left; }
    int Gettop() { return band.top; }
    int Getright() { return band.right; }
    int Getbottom() { return band.bottom; }
    void Seterror(int input) { error = input; }
    void Seterror() { error = TRUE; }
    void Reseterror() { error = FALSE; }
    void Copyband(RECT *rect) { CopyRect(rect, &band); }
    int Testband() { return IsRectEmpty(&band) == FALSE; }
};

#endif