//
//	PAINT Object Test
//	Written by Andrew Bradnan (c) 1993
//

#define STRICT
#include <windows.h>
#include "paint.h"

char szAppName[] = "DC Test" ;
long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	HWND        hWnd ;
	MSG         msg ;
	WNDCLASS    wc ;

	if (!hPrevInstance) {
		wc.style         = CS_HREDRAW | CS_VREDRAW ;
		wc.lpfnWndProc   = WndProc ;
		wc.cbClsExtra    = 0 ;
		wc.cbWndExtra    = 0 ;
		wc.hInstance     = hInstance ;
		wc.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
		wc.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
		wc.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
		wc.lpszMenuName  = NULL ;
		wc.lpszClassName = szAppName ;

		RegisterClass (&wc) ;
	};

	hWnd = CreateWindow (szAppName,		// window class name
		"DC Test Program",			// window caption
		WS_OVERLAPPEDWINDOW,	// window style
		CW_USEDEFAULT,	// initial x position
		CW_USEDEFAULT,	// initial y position
		CW_USEDEFAULT,	// initial x size
		CW_USEDEFAULT,	// initial y size
		NULL,			// parent window handle
		NULL,			// window menu handle
		hInstance,		// program instance handle
		NULL);			// creation parameters

	ShowWindow (hWnd, nCmdShow);
	UpdateWindow (hWnd);

	while (GetMessage (&msg, NULL, 0, 0)) {
		TranslateMessage (&msg) ;
		DispatchMessage (&msg) ;
	};
	return msg.wParam ;
};

long FAR PASCAL _export WndProc (HWND hWnd, UINT message, UINT wParam, LONG lParam)
{
	 switch (message) {
		case WM_PAINT:
		{
			PAINT	Paint (hWnd);	// PAINT constructor called here!!
			DrawText (Paint, "PAINT Test!!", -1, Paint, DT_SINGLELINE | DT_CENTER | DT_VCENTER);		// PAINT operator LPRECT () called too!!
		};				// PAINT destructor called here!!
		return 1;		// Everything Created OK
	case WM_DESTROY:
		PostQuitMessage (0);
		return 0;
	};

	return DefWindowProc (hWnd, message, wParam, lParam) ;
};

