#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <conio.h>


#define QUEUE_SIZE	1024
#define CTRL_Q		17
#define CTRL_S		19

#define COM1_ID		00
#define COM2_ID		01

#define ESC		27

DCB	commDCB;
COMSTAT	commState;
int	commPort   = COM2_ID, commPortId;
char	inBuff[ QUEUE_SIZE ];



int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int cmdShow )
{
    MSG    msg;
    LPSTR  fp;
    static char *szCommPort[]      = { "COM1", "COM2" };
    static char szDefaultSetting[] = "COM2:=24,n,8,1";
    char szCommSettings[20];

    if ( hPrevInstance )
	return( FALSE );

    GetProfileString(( LPSTR )"[ports]", ( LPSTR )( szCommPort[ commPort ] ),
		     ( LPSTR )szDefaultSetting, (LPSTR)szCommSettings,
		      sizeof( szCommSettings ) - 1 );
    fp = szCommSettings;
    while( *fp )
    {
	if ( *fp == '=' )
	    _fstrncpy( fp, fp+1, _fstrlen( fp ));
	fp++;
    }

    if ( BuildCommDCB( szCommSettings, &commDCB ) != 0 )
    {
	MessageBox( GetFocus(), ( LPSTR )"Error building DCB",
		    ( LPSTR )"WSerial Error", MB_OK | MB_ICONEXCLAMATION );
	return( FALSE );
    }

    commDCB.fOutX   = TRUE;
    commDCB.fInX    = TRUE;
    commDCB.XonChar = CTRL_Q;
    commDCB.XoffChar= CTRL_S;;
    commDCB.fNull   = TRUE;
    commDCB.XonLim  = QUEUE_SIZE/2;
    commDCB.XoffLim = QUEUE_SIZE/2;
    commDCB.fBinary = FALSE;

    if (( commPortId = OpenComm( szCommPort[ commPort ], QUEUE_SIZE, QUEUE_SIZE )) < 0 )
    {
	MessageBox( GetFocus(), ( LPSTR )"Error Opening CommPort",
		    ( LPSTR )"WSerial Error", MB_OK | MB_ICONEXCLAMATION );
	return( FALSE );
    }

    FlushComm( commPortId, 0 );
    FlushComm( commPortId, 1 );

    commDCB.Id = commPortId;

    if ( SetCommState( &commDCB ) != 0 )
    {
	MessageBox( GetFocus(), ( LPSTR )"Error setting CommState",
		    ( LPSTR )"WSerial Error", MB_OK | MB_ICONEXCLAMATION );
	return( FALSE );
    }

    _InitEasyWin();
    puts( "You are in terminal emulation mode...\nHit <ESC> to terminate..." );

    while( TRUE )
    {
	if ( PeekMessage( ( LPMSG )&msg, NULL, 0, 0, PM_REMOVE ) )
	{
	    if ( msg.message == WM_QUIT )
	    {
		return( msg.wParam );
	    }
	    TranslateMessage( &msg );
	    DispatchMessage ( &msg );
	}
	else
	{
	    int nCharWaiting;

	    GetCommError( commDCB.Id, &commState );

	    if ((nCharWaiting = commState.cbInQue ) > 0 )
	    {
		nCharWaiting = ReadComm( commDCB.Id, inBuff,
				       ( nCharWaiting > QUEUE_SIZE ? QUEUE_SIZE : nCharWaiting ));
		if ( nCharWaiting < 0 )
		{
		}
		else
		{
		    int i = 0;
		    while( i < nCharWaiting )
			putch( inBuff[ i++ ] );
		}
	    }
	    else if ( kbhit() )
	    {
		char keyHit  = ( char )getch();
		if ( !keyHit )
		      keyHit = ( char )getch();
		if ( keyHit != ESC )
		    WriteComm( commDCB.Id, ( LPSTR )&keyHit, 1 );
		else
		{
		    FlushComm( commDCB.Id, 0 );
		    FlushComm( commDCB.Id, 1 );
		    CloseComm( commDCB.Id );
		    MessageBox( GetFocus(), ( LPSTR )"Serial Connection Closed\n"
						     "Terminating sample app..",
				( LPSTR )" WSerial Msg ", MB_OK );
		    PostMessage( GetFocus(), WM_DESTROY, 0, 0L  );
		    return( TRUE );
		}
	    }
	}
    }
}

