/*
 * File:     common.h
 * Purpose:  Declarations/definitions common to all wx source files
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 14-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_commonh
#define wx_commonh

#include <stddef.h>
#include <string.h>

#ifdef wx_xview
#define wx_x
#endif

#ifdef wx_motif
#define wx_x
#endif

#ifdef wx_motif
typedef int Bool;
#define TRUE 1
#define FALSE 0
#endif

#ifdef wx_xview
#define Bool int
#define True 1
#define False 0
#define TRUE 1
#define FALSE 0
#define Bool_DEFINED
#endif

#ifdef wx_msw
#ifndef Bool
typedef int Bool;
#endif
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif
#endif

#define wxSINGLE           0
#define wxMULTIPLE         1

// Window status flags
#define wxBORDER           1
#define wxRETAINED         2
#define wxDLG              4

// Mouse button codes
#define wxLEFTDOWN         40
#define wxLEFTUP           41
#define wxRIGHTDOWN        42
#define wxRIGHTUP          43
#define wxMIDDLEDOWN       44
#define wxMIDDLEUP         45

// Event actions
#define wxSELECT           50
#define wxDESELECT         51
#define wxCLICK            52
#define wxDRAG             53
#define wxMOVE             54
#define wxDOUBLECLICK      55
#define wxREPAINT          56
#define wxRESIZE           57
#define wxASCII            58

#define wxDEFAULT          70
#define wxDECORATIVE       71
#define wxROMAN            72
#define wxSCRIPT           73
#define wxSWISS            74
#define wxMODERN           75

#define wxVARIABLE         80
#define wxFIXED            81

#define wxNORMAL           90
#define wxLIGHT            91
#define wxBOLD             92

// Also wxNORMAL for normal (non-italic text)
#define wxITALIC           93
#define wxSLANT            94

// Pen styles
#define wxSOLID            100
#define wxDOT              101
#define wxLONG_DASH        102
#define wxSHORT_DASH       103
#define wxDOT_DASH         104

#define wxTRANSPARENT      105

// Brush styles - not implemented
#define wxSTIPPLE          110

// Logical ops
#define wxXOR              1
#define wxINVERT           2
#define wxOR_REVERSE       3
#define wxAND_REVERSE      4
#define wxCOPY             5

// Directions
#define wxHORIZONTAL      1
#define wxVERTICAL        2
#define wxBOTH            3

// Dialog specifiers/return values
#define wxOK                     1
#define wxYES_NO                 2
#define wxCANCEL                 4
#define wxYES                    8
#define wxNO                    16

#define wxICON_EXCLAMATION      32
#define wxICON_HAND             64
#define wxICON_QUESTION        128

// Colours - see wx_gdi.cc for database

#endif // wx_commonh
