/*
 * File:     wx_dialg.h
 * Purpose:  wxDialogBox and common dialog declarations
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_dialgh
#define wx_dialgh

#include "common.h"
#include "wx_item.h"

#ifdef wx_xview
#include <xview/frame.h>
#endif

// Dialog boxes
class wxDialogBox: public wxPanel
{
 public:
#ifdef wx_motif
  Widget dialogShell;
  Bool modal_showing;
  void PostDestroyChildren(void);
#endif
#ifdef wx_xview
  Frame frame;
#endif
#ifdef wx_msw
  Bool modal_showing;
#endif
  Bool modal;

  wxDialogBox(wxFrame *frame, char *title, Bool modal = FALSE,
              int x = -1, int y = -1,
              int width = -1, int height = -1);
  ~wxDialogBox();

  void SetSize(int x, int y, int width, int height);
  void SetClientSize(int width, int height);
  void GetPosition(int *x, int *y);
  virtual void Show(Bool show);
  virtual void Iconize(Bool iconize);
  virtual Bool Iconized(void);
  void Fit(void);
  void Centre(int direction = wxBOTH);
};

// Handy dialog functions
char *wxGetTextFromUser(char *message, char *caption = "Input text",
                        char *default_value = "", wxFrame *parent = NULL,
                        int x = -1, int y = -1);

char *wxGetSingleChoice(char *message, char *caption,
                        int n, char *choices[], wxFrame *parent = NULL,
                        int x = -1, int y = -1);

// Same as above but gets position in list of strings, instead of string,
// or -1 if no selection
int wxGetSingleChoiceIndex(char *message, char *caption,
                           int n, char *choices[], wxFrame *parent = NULL,
                           int x = -1, int y = -1);

// Return client data instead
char *wxGetSingleChoiceData(char *message, char *caption,
                            int n, char *choices[], char *client_data[],
                            wxFrame *parent = NULL, int x = -1, int y = -1);

// type is an 'or' (|) of wxOK, wxCANCEL, wxYES_NO
// Returns wxYES/NO/OK/CANCEL
int wxMessageBox(char *message, char *caption = "Message", int type = wxOK,
  wxFrame *parent = NULL, int x = -1, int y = -1);

#define wxOPEN 1
#define wxSAVE 2
#define wxOVERWRITE_PROMPT 4
#define wxHIDE_READONLY 8

// File selector
char *wxFileSelector(char *message = "Select a file", char *default_path = NULL,
                     char *default_filename = NULL, char *default_extension = NULL,
                     char *wildcard = "*.*", int flags = 0,
  wxFrame *parent = NULL, int x = -1, int y = -1);

#endif // wx_dialgh
