/*
 * File:     wx_event.h
 * Purpose:  wxEvent declaration
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */


#ifndef wx_eventh
#define wx_eventh

#include "common.h"

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#ifdef wx_xview
#include <xview/canvas.h>
#endif

#ifdef wx_msw
#include <windows.h>
#endif

// General event object
class wxEvent: public wxObject
{
 public:
#ifdef wx_motif
  XButtonEvent *event_handle;
  Bool button1Pressed;
  Bool button2Pressed;
  Bool button3Pressed;
#endif
#ifdef wx_xview
  Event *event_handle;
#endif

  float x;
  float y;

#ifdef wx_msw
  int event;
  UINT flags;
#endif

  int index;
  char *string;
  char *client_data;

  wxEvent();
#ifdef wx_xview
  wxEvent(Event *x_event);
#endif

  Bool IsButton(void);
  Bool ButtonDown(void);
  Bool ControlDown(void);
  Bool ShiftDown(void);
  Bool Button(int);          // True if button N was changing state
  Bool LeftDown(void);
  Bool MiddleDown(void);
  Bool RightDown(void);
  Bool LeftUp(void);
  Bool MiddleUp(void);
  Bool RightUp(void);
  Bool Dragging(void);
  void Position(float *x, float *y);
  int Index(void);
  char *String(void);
};

#endif // wx_eventh
