/*
 * File:     wx_frame.h
 * Purpose:  wxFrame declaration
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_frameh
#define wx_frameh

#include "common.h"

#ifdef wx_xview
#include <xview/frame.h>
#endif

#ifdef wx_motif
#include <Xm/Xm.h>
#endif

#include "wx_win.h"

class wxPanel;
class wxMenuBar;

#define wxSDI        1
#define wxMDI_PARENT 2
#define wxMDI_CHILD  3

class wxStatusWnd;
class wxFrame: public wxWindow
{
 public:
  Bool modal_showing;
  wxMenuBar *wx_menu_bar;
  wxIcon *icon;
  Bool status_line_exists;
  int frame_type;  // SDI, MDI parent/child
#ifdef wx_motif
  Widget frameShell;
  Widget frameWidget;
  Widget workArea;
  Widget menuBarWidget;
  Widget statusLineWidget;
  Widget statusTextWidget;
  Widget GetMenuBarWidget(void);
  void PreResize(void);
#endif
#ifdef wx_xview
  wxPanel *menu_bar_panel;
  int y_offset;
#endif
#ifdef wx_msw
  wxStatusWnd *status_window;
  Bool wx_iconized;
#endif

  wxFrame(wxFrame *parent, char *title,
          int x=-1, int y=-1, int width=-1, int height=-1,
          int type = wxSDI);

  ~wxFrame(void);

  // Override, e.g. to resize subwindows
  void OnSize(int x, int y);
  // The default thing is to set the focus for the first child window.
  // Override for your own behaviour.
  void OnActivate(Bool flag);

  void SetClientSize(int width, int height);
  void GetClientSize(int *width, int *height);

  void GetSize(int *width, int *height);
  void GetPosition(int *x, int *y);
  void SetSize(int x, int y, int width, int height);
  void Show(Bool show);

  // Set menu bar
  void SetMenuBar(wxMenuBar *menu_bar);
  wxMenuBar *GetMenuBar(void);

  // Set title
  void SetTitle(char *title);

  // Set icon
  void SetIcon(wxIcon *icon);

  // Create status line
  void CreateStatusLine(void);

  // Set status line text
  void SetStatusText(char *text);
  Bool StatusLineExists(void);

  // Fit frame around subwindows
  void Fit(void);

  // Centre window on screen (you can also use Center)
  void Centre(int direction = wxBOTH);

  // Iconize
  virtual void Iconize(Bool iconize);
  virtual Bool Iconized(void);

#ifdef wx_msw
  void PositionStatusWindow(void);
  HMENU GetWinMenu(void);
#endif
  virtual void LoadAccelerators(char *table);
};
#endif // wx_frameh
