/*
 * File:     wx_item.h
 * Purpose:  Declares panel items (controls/widgets)
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_itemh
#define wx_itemh

#include "common.h"
#include "wx_win.h"
#include "wx_panel.h"

#ifdef wx_msw
#include <windows.h>
#endif
#ifdef wx_motif
#include <Xm/Label.h>
#include <Xm/Form.h>
#endif
#ifdef wx_xview
#include <xview/openmenu.h>
#endif

// General item class
class wxItem: public wxWindow
{
 public:
    wxItem(void);
   ~wxItem(void);
#ifdef wx_motif
   // Each item is a form/rowcol widget, optional label widget, plus a specific
   // widget
   Widget formWidget;
   Widget labelWidget;
   int itemOrientation;
   void AttachWidget(wxPanel *panel, Widget formWidget,
                     int x, int y, int width, int height);
#endif
   int labelPosition;

   void GetSize(int *width, int *height);
   void GetPosition(int *x, int *y);
   void SetSize(int x, int y, int width, int height);
   void SetClientSize(int width, int height);
   void SetFocus(void);
   virtual void SetDefault(void);
   virtual void SetLabel(char *label);
   virtual char *GetLabel(void);

   void Show(Bool show);
   float GetTextHeight(void);
   float GetTextWidth(void);
   void GetTextExtent(char *string, float *x, float *y);
   int GetLabelPosition(void);
   void SetLabelPosition(int pos);

  // Places item in centre of panel - so can't be used BEFORE panel->Fit()
  void Centre(int direction = wxHORIZONTAL);
};

// Pushbutton
class wxButton: public wxItem
{
 public:
  wxButton(wxPanel *panel, wxFunction func, char *label, int x = -1, int y = -1,
           int width = -1, int height = -1);
  ~wxButton(void);
  void SetSize(int x, int y, int width, int height);
  void SetFocus(void);
  void SetDefault(void);
  void SetLabel(char *);
  char *GetLabel(void);
#ifdef wx_msw
  virtual BOOL Command(UINT param);
#endif
};

class wxMenuBar;

#ifdef wx_motif
class wxMenuItem: public wxObject
{
 public:
  Widget buttonWidget; // The actual string, so we can grey it etc.
  wxMenuBar *menuBar;
  int itemId;
  char *itemName;
  wxMenu *subMenu;
  wxMenuItem(void) { itemName = NULL; subMenu = NULL; }
  ~wxMenuItem(void) { if (itemName) delete itemName; }
};

#endif

// Menu
class wxMenu: public wxItem
{
  int no_items;
 public:
  char *title;
  wxMenu *top_level_menu;
  wxMenuBar *menu_bar;

#ifdef wx_motif
  Widget buttonWidget; // The actual string, so we can grey it etc.
  wxList menuItems;
  int menuId;
#endif

  wxMenu(char *Title = NULL, wxFunction func = NULL);
  ~wxMenu(void);
  virtual void AppendSeparator(void);
  virtual void Append(int Id, char *Label);
  virtual void Append(int Id, char *Label, wxMenu *SubMenu);
  virtual void Enable(int Id, Bool Flag);
  virtual void Check(int Id, Bool Flag);
#ifdef wx_motif
  Widget CreateMenu(wxMenuBar *menu_bar, Widget parent, char *title);
  Widget FindMenuItem(int Id);
#endif
#ifdef wx_xview
  Menu_item FindMenuItem(int Id);
#endif
};

// Menu Bar (a la Windows)
#define MENU_BAR_PANEL_HEIGHT 30
class wxFrame;
class wxMenuBar:public wxItem
{
 public:
  int n;
  wxMenu **menus;
  char **titles;
  wxFrame *menu_bar_frame;

  wxMenuBar(void);
  wxMenuBar(int n, wxMenu *menus[], char *Titles[]);
  ~wxMenuBar(void);

  virtual void Append(wxMenu *menu, char *title);
  // Must only be used AFTER menu has been attached to frame,
  // otherwise use individual menus to enable/disable items
  virtual void Enable(int Id, Bool Flag);
  virtual void Check(int Id, Bool Flag);
};

// Checkbox item (single checkbox)
class wxCheckBox: public wxItem
{
 public:
  wxCheckBox(wxPanel *panel, wxFunction func, char *Title,
             int x = -1, int y = -1, int width = -1, int height = -1);
  ~wxCheckBox(void);
  virtual void SetValue(Bool);
  virtual Bool GetValue(void);
  void SetSize(int x, int y, int width, int height);
#ifdef wx_msw
  virtual BOOL Command(UINT param);
#endif
};

// Choice item
class wxChoice: public wxItem
{
  int no_strings;
 public:
#ifdef wx_motif
  Widget menuWidget;
  Widget buttonWidget;
  Widget messageWidget;
  Widget rowWidget;
  wxStringList stringList;
#endif
#ifdef wx_msw
  HWND static_label;
#endif

  wxChoice(wxPanel *panel, wxFunction func, char *Title,
           int x = -1, int y = -1, int width = -1, int height = -1,
           int N = 0, char **Choices = NULL);
  ~wxChoice(void);
  virtual void Append(char *Item);
  virtual void Clear(void);
  virtual int GetSelection(void);
  virtual void SetSelection(int n);
  virtual int FindString(char *s);
  virtual char *GetStringSelection(void);
  virtual Bool SetStringSelection(char *s);
  virtual char *String(int n);
  void SetSize(int x, int y, int width, int height);
  void GetSize(int *x, int *y);
  void GetPosition(int *x, int *y);
  char *GetLabel(void);
  void SetLabel(char *label);
#ifdef wx_msw
  Bool Command(UINT param);
#endif
};

// List box item
class wxListBox: public wxItem
{
  int no_items;
  int selected;
  int *selections;
#ifdef wx_motif
  wxList clientDataList; // List mapping positions->client data
#endif
#ifdef wx_msw
  HWND static_label;
#endif
 public:
  int multiple;

  wxListBox(wxPanel *panel, wxFunction func, char *Title, Bool Multiple = FALSE,
             int x = -1, int y = -1, int width = -1, int height = -1,
             int N = 0, char **Choices = NULL);
  ~wxListBox(void);
#ifdef wx_msw
  virtual BOOL Command(UINT param);
#endif
  virtual void Append(char *Item);
  virtual void Append(char *Item, char *Client_data);
  virtual void Set(int N, char *Choices[]);
  int FindString(char *s);
  virtual void Clear(void);
  virtual void SetSelection(int N);
  // Get client data
  virtual char *GetClientData(int N);

  virtual void Deselect(int N);

  // For single choice list item only
  virtual int GetSelection(void);
  virtual char *GetStringSelection(void);
  virtual Bool SetStringSelection(char *s);

  virtual int Number(void);
  virtual void Delete(int N);

  // For single or multiple choice list item
  virtual int GetSelections(int **list_selections);
  virtual char *String(int N);
  void SetSize(int x, int y, int width, int height);
  void GetSize(int *x, int *y);
  void GetPosition(int *x, int *y);
  char *GetLabel(void);
  void SetLabel(char *label);
};


// Message item
class wxMessage: public wxItem
{
 public:
  wxMessage(wxPanel *panel, char *message, int x = -1, int y = -1);
  ~wxMessage(void);
  void SetSize(int x, int y, int width, int height);
};

// Single-line text item
class wxText: public wxItem
{
 public:
#ifdef wx_msw
  HWND static_label;
#endif
  wxText(void);
  wxText(wxPanel *panel, wxFunction func, char *label, char *value = "",
         int x = -1, int y = -1, int width = -1, int height = -1);
  ~wxText(void);
  virtual char *GetValue(void);
  virtual char *GetLabel(void);
  virtual void SetValue(char *value);
  virtual void SetLabel(char *label);
  void GetSize(int *x, int *y);
  void SetSize(int x, int y, int width, int height);
  void GetPosition(int *x, int *y);
  void SetFocus(void);
#ifdef wx_msw
  virtual BOOL Command(UINT param);
#endif
};

// Multi-line text item
class wxMultiText: public wxText
{
 public:
  wxMultiText(wxPanel *panel, wxFunction func, char *label, char *value = "",
         int x = -1, int y = -1, int width = -1, int height = 50);
  char *GetValue(void);
  void GetValue(char *buffer, int maxLen);
  void SetSize(int x, int y, int width, int height);
};

// Slider
class wxSlider: public wxItem
{
 public:
#ifdef wx_msw
  HWND static_label;
  HWND static_min;
  HWND static_max;
  HWND edit_value;

  int s_min;
  int s_max;
  int page_size;

#endif
  wxSlider(wxPanel *panel, wxFunction func, char *label, int value,
           int min_value, int max_value, int width, int x = -1, int y = -1);
  ~wxSlider(void);
  virtual int GetValue(void);
  virtual char *GetLabel(void);
  virtual void SetValue(int);
  virtual void SetLabel(char *label);
  void GetSize(int *x, int *y);
  void SetSize(int x, int y, int width, int height);
  void GetPosition(int *x, int *y);
};

#ifdef wx_x
// For stripping out Windows-specific accelerator codes
// from menu items
void wxStripMenuCodes(char *in, char *out);

// Find the letter corresponding to the mnemonic, for Motif
char wxFindMnemonic(char *s);
#endif

#endif // wx_itemh
