/*
 * File:     wx_win.h
 * Purpose:  wxWindow class declaration. Base class for all windows and
 *           panel items.
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                       Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef wx_winh
#define wx_winh

#include "common.h"
#include "wx_obj.h"
#include "wx_event.h"
#include "wx_list.h"
#include "wx_gdi.h"

#ifdef wx_msw
#include <windows.h>
#endif

// Callback function type definition
typedef void (*wxFunction) (wxObject&, wxEvent&);

class wxMenu;

/*
 * Base class for frame, panel, canvas, panel items, dialog box.
 *
 */

class wxWindow: public wxObject
{

 public:
  // Font - created on demand, not deleted with window
  wxFont *font;                               // Window's font
  wxCursor *wx_cursor;                        // Window's cursor

  char *wx_client_data;                       // Any user client data
  wxList *children;                           // Window's children

#ifdef wx_msw
  HANDLE ms_handle;                           // For menus and hwnds: using 'handle'
                                              // causes too many compiler messages
  int wxWinType;                              // For knowing how to delete the object
  int cxChar;
  int cyChar;
  int windows_id;
  virtual BOOL Command(UINT param);
  wxWindow *FindItem(int id);
  virtual void PreDelete(HDC dc);              // Allows system cleanup
#endif
  wxWindow *window_parent;                     // Each window always knows its parent
  char *handle;                                // Pointer to real window

  wxFunction callback;                         // Callback associated with the window
  virtual void Callback(wxFunction);           // Adds callback

  // Constructors/Destructors
  wxWindow(void);
  virtual ~wxWindow(void);

  virtual void OnPaint(void);                 // Called when needs painting
  virtual void OnSize(int width, int height); // Called on resize
  virtual void OnEvent(wxEvent& event);       // Called on mouse event
  virtual void OnChar(int ch);                // Called on character event
  virtual Bool OnClose(void);                 // Delete window if returns TRUE
  virtual void OnMenuCommand(int Id);         // Called on frame menu command
  virtual void OnMenuSelect(int Id);          // Called on menu select (MSW)
  virtual void OnActivate(Bool active);       // Called on window activation (MSW)
  virtual void OnSetFocus(void) {}            // Called on setting focus
  virtual void OnKillFocus(void) {}           // Called on killing focus

  virtual void GetSize(int *width, int *height);
  virtual void GetPosition(int *x, int *y);
  virtual void GetClientSize(int *width, int *height); // Size client can use
  virtual void SetSize(int x, int y, int width, int height);
  virtual void SetClientSize(int width, int size);
  virtual void SetFocus(void);

  virtual char *GetHandle(void);
  virtual char *GetClientData(void);
  virtual wxWindow *GetParent(void);
  virtual wxWindow *GetGrandParent(void);
  virtual wxList *GetChildren() { return children; }


  virtual int XChar(int pixels);              // Convert pixels to character positions
  virtual int YChar(int pixels);

  virtual void SetClientData(char *);
  virtual void Show(Bool show);
  virtual wxCursor *SetCursor(wxCursor *cursor);

  virtual int GetTextFamily(void);
  virtual int GetTextStyle(void);
  virtual int GetTextWeight(void);
  virtual float GetTextHeight(void);
  virtual float GetTextWidth(void);
  virtual void GetTextExtent(char *string, float *x, float *y);
  void SetTitle(char *title);                  // Set window title
  virtual void Fit(void);                      // Size window to fit contents
  virtual void Centre(int direction);          // Centre item on panel,
                                               // or frame on screen

  // A concession to our friends across the pond
  inline void Center(int direction) { Centre(direction); }

  // INTERNAL FUNCTIONS
  void AddChild(wxObject *child);      // Adds reference to the child object
  void RemoveChild(wxObject *child);   // Removes reference to child
                                       // (but doesn't delete the child object)
  virtual void DestroyChildren(void);  // Removes and destroys all children

#ifdef wx_motif
  virtual void PreResize(void);
  void PostDestroyChildren(void);
  int wxType;
#endif
};

#endif
