/*
 * File:     server.cc
 * Purpose:  Server demo for wxWindows class library
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <windows.h>
#include "wx.h"
#include "server.h"

MyFrame *frame = NULL;

// This statement initialises the whole application
MyApp myApp;

char ipc_buffer[4000];
MyConnection *the_connection = NULL;

// The `main program' equivalent, creating the windows and returning the
// main frame
wxFrame *MyApp::OnInit(void)
{
  // Create the main frame window
  frame = new MyFrame(NULL, "Server", 0, 0, 400, 500);

  // Give it an icon
  wxIcon *icon = new wxIcon("conn_icn");
  frame->SetIcon(icon);

  // Make a menubar
  wxMenu *file_menu = new wxMenu;

  file_menu->Append(SERVER_QUIT, "Quit");

  wxMenuBar *menu_bar = new wxMenuBar;

  menu_bar->Append(file_menu, "File");

  // Associate the menu bar with the frame
  frame->SetMenuBar(menu_bar);

  // Make a panel
  frame->panel = new wxPanel(frame, 0, 0, 400, 250);
  wxListBox *list = new wxListBox(frame->panel, (wxFunction)&list_proc, "A list",
                                  wxSINGLE, -1, -1, 150, 120);
  list->Append("Apple");
  list->Append("Pear");
  list->Append("Orange");
  list->Append("Banana");
  list->Append("Fruit");

  frame->SetSize(0, 0, 400, 300);

  // Initialize IPC
  wxIPCInitialize();

  char *server_name = "4242";
  if (argc > 1)
    server_name = argv[1];

  // Create a new server
  MyServer *server = new MyServer;
  server->Create(server_name);

  frame->Show(TRUE);

  // Return the main frame window
  return frame;
}

// Define my frame constructor
MyFrame::MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h):
  wxFrame(frame, title, x, y, w, h)
{
  panel = NULL;
}

// Intercept menu commands
void MyFrame::OnMenuCommand(int id)
{
  switch (id)
  {
    case SERVER_QUIT:
    {
      OnClose();
      delete this;
      break;
    }
  }
}

// Define the behaviour for the frame closing
// - must delete all frames except for the main one.
Bool MyFrame::OnClose(void)
{
  return TRUE;
}

/*
 * IPC stuff
 *
 */

void IPCButtonQuit(wxButton& button, wxEvent& event)
{
  IPCDialogBox *dialog = (IPCDialogBox *)button.GetParent();
  dialog->connection->Disconnect();
  delete dialog->connection;
}

IPCDialogBox::IPCDialogBox(wxFrame *Parent, char *Title, Bool Modal, 
                         int x, int y, int width, int height, MyConnection *the_connection):wxDialogBox(Parent, Title,
    Modal, x, y, width, height)
{
  connection = the_connection;
  (void)new wxButton(this, (wxFunction)IPCButtonQuit, "Quit this connection");
  Fit();
  Show(TRUE);
}

wxConnection *MyServer::OnAcceptConnection(char *topic)
{
  if (strcmp(topic, "STDIO") != 0 && strcmp(topic, "IPC TEST") == 0)
    return new MyConnection(ipc_buffer, 4000);
  else
    return NULL;
}

MyConnection::MyConnection(char *buf, int size):wxConnection(buf, size)
{
  dialog = new IPCDialogBox(frame, "Connection", FALSE, 100, 100, 100, 100, this);
  the_connection = this;
}

MyConnection::~MyConnection(void)
{
  delete dialog;
  the_connection = NULL;
}

Bool MyConnection::OnExecute(char *topic, char *data, int size, int format)
{
  wxMessageBox(data, "Server: Execute", wxOK);
  return TRUE;
}

Bool MyConnection::OnPoke(char *topic, char *item, char *data, int size, int format)
{
  wxMessageBox(data, "Server: Ouch, got a Poke", wxOK);
  return TRUE;
}

char *MyConnection::OnRequest(char *topic, char *item, int *size, int format)
{
  return "Here, have your data, client!";
}

// Set the client process's listbox to this item
void list_proc(wxListBox& list, wxEvent& event)
{
  char *value = list.GetStringSelection();
  if (the_connection)
  {
    the_connection->Advise("Item", value);
  }
}
