/*
 * File:     tex2any.h
 * Purpose:  Header file for LaTeX --> wxHelp conversion
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include "wx.h"
#include "wx_utils.h"
#include "wx_list.h"

/*
 * We have a list of macro definitions which we must define
 * in advance to enable the parsing to recognize macros.
 */

class TexMacroDef: public wxObject
{
 public:
  int no_args;
  char *name;
  Bool ignore;
  Bool consume_space;

  TexMacroDef(char *the_name, int n, Bool ig, Bool consumeSpace = FALSE);
  ~TexMacroDef(void);
};

#define CHUNK_TYPE_MACRO    1
#define CHUNK_TYPE_ARG      2
#define CHUNK_TYPE_STRING   3

/*
 We have nested lists to represent the Tex document.
 Each element of a list of chunks can be one of:
  - a plain string
  - a macro with/without arguments. Arguments are lists of TexChunks.

Example (\toplevel is implicit but made explicit here):

AddMacroDef("mymat", 2);

\toplevel{The cat sat on the \mymat{very coarse and {\it cheap}}{mat}}.

Parsed as:

TexChunk: type = macro, name = toplevel, no_args = 1
  Children:

    TexChunk: type = argument

      Children:
        TexChunk: type = string, value = "The cat sat on the "
        TexChunk: type = macro, name = mymat, no_args = 2

          Children:
            TexChunk: type = argument

              Children:
                TexChunk: type = string, value = "very coarse and "
                TexChunk: type = macro, name = it, no_args = 1

                  Children:
                    TexChunk: type = argument

                      Children:
                        TexChunk: type = string, value = "cheap"

            TexChunk: type = argument

              Children:
                TexChunk: type = string, value = mat
 */

class TexChunk: public wxObject
{
 public:
  int type;
  char *name;
  char *value;
  int no_args;
  int argn;
  wxList children;
  TexChunk(int the_type);
  ~TexChunk(void);
};

extern TexChunk *TopLevel;

Bool read_a_line(FILE *fd, char *buf);
Bool TexLoadFile(char *filename);
int ParseArg(wxList& children, char *buffer, int pos, char *environment = NULL);
int ParseMacroBody(char *macro_name, wxList& children, int no_args,
                   char *buffer, int pos, char *environment = NULL);
void TraverseDocument(void);
void TraverseDocument1(TexChunk *chunk);
void SetCurrentOutput(FILE *fd);
void SetCurrentOutputs(FILE *fd1, FILE *fd2);
void AddMacroDef(char *name, int n, Bool ignore = FALSE, Bool consume_space = FALSE);
void TexInitialize(void);
void TexOutput(char *s);

/*
 * Client-defined
 *
 */

// Called on start/end of macro examination
void OnMacro(char *name, int no_args, Bool start);

// Called on start/end of argument examination
void OnArgument(char *macro_name, int arg_no, Bool start);

/*
#define hyBLOCK_NORMAL   1
#define hyBLOCK_RED      2
#define hyBLOCK_BLUE     3
#define hyBLOCK_GREEN    4
#define hyBLOCK_LARGE_HEADING 5
#define hyBLOCK_SMALL_HEADING 6
#define hyBLOCK_ITALIC   7
#define hyBLOCK_BOLD     8
#define hyBLOCK_INVISIBLE_SECTION 9
#define hyBLOCK_LARGE_VISIBLE_SECTION 10
#define hyBLOCK_SMALL_VISIBLE_SECTION 11
#define hyBLOCK_SMALL_TEXT 12
#define hyBLOCK_RED_ITALIC 13
*/

#define BLOCK_LARGE_SECTION 10
#define BLOCK_SMALL_SECTION 11
#define BLOCK_LARGE_HEADING 5
#define BLOCK_SMALL_HEADING 6
#define BLOCK_RED_ITALIC    13
#define BLOCK_RED           2
#define BLOCK_ITALIC        7
#define BLOCK_BOLD          8
#define BLOCK_TELETYPE      14

