/*
 * File:     wxhelp.h
 * Purpose:  wxWindows help system
 *
 *                       wxWindows 1.40
 * Copyright (c) 1993 Artificial Intelligence Applications Institute,
 *                   The University of Edinburgh
 *
 *                     Author: Julian Smart
 *                        Date: 18-4-93
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice, author statement and this permission
 * notice appear in all copies of this software and related documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, EXPRESS,
 * IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE ARTIFICIAL INTELLIGENCE APPLICATIONS INSTITUTE OR THE
 * UNIVERSITY OF EDINBURGH BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF
 * DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH
 * THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <windows.h> // Included only for using MS C/C++ precompiled headers
#include "wx.h"
#include "hytext.h"

// Define a new application
class MyApp: public wxApp
{
  public:
    wxFrame *OnInit(void);
};


class HelpWindow: public wxHyperTextWindow
{
 public:
  HelpWindow(wxFrame *frame, int x, int y, int w, int h, int style);
  ~HelpWindow(void);

  // Derived members
  void OnLeftClick(float x, float y, int char_pos, int line, long block_id, int keys);
  void OnRightClick(float x, float y, int char_pos, int line, long block_id, int keys);
  void OnSelectBlock(long block_id, Bool select);
  void ClearBlock(long block_id);

  // New members
  void DisplaySection(void);
  void StoreHypertextItem(long block_id);
  void HistoryBack(void);
  void DisplayHistory(void);
};

// Define a new frame
class MyFrame: public wxFrame
{
  public:
    HelpWindow *window;
    wxPanel *panel;
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    Bool OnClose(void);
    void OnSize(int x, int y);
    void OnMenuCommand(int id);
};

#define HELP_OPEN        100
#define HELP_EXIT        101
#define HELP_TEST        102
#define HELP_CLEAR_SELECTION 103
#define HELP_CLEAR_BLOCK 104
#define HELP_SAVE        105
#define HELP_RUN_EDITOR  106
#define HELP_SET_TITLE   107
#define HELP_HELP_CONTENTS 108
#define HELP_ABOUT       109

// Special blocks
#define HELP_MARK_LARGE_VISIBLE_SECTION 200
#define HELP_MARK_SMALL_VISIBLE_SECTION 201
#define HELP_MARK_INVISIBLE_SECTION 202

// Cosmetic stuff
#define HELP_MARK_LARGE_HEADING 203
#define HELP_MARK_SMALL_HEADING 204
#define HELP_MARK_SMALL_TEXT 205

#define HELP_MARK_BOLD   220
#define HELP_MARK_ITALIC 221

#define HELP_MARK_RED    230
#define HELP_MARK_BLUE   231
#define HELP_MARK_GREEN  232

#define HELP_MARK_RED_ITALIC 240

void hyErrorMsg(char *msg);
void HelpSearch(void);

class SearchBox: public wxDialogBox
{
 public:
  wxText *search_item;
  wxListBox *titles_item;
  SearchBox(wxFrame *parent);
  void DoSearch(wxList *string_list = NULL);
};

class HelpConnection;
extern HelpConnection *TheHelpConnection;

// Communication with applications
class HelpConnection: public wxConnection
{
 public:
  HelpConnection(void)
    { TheHelpConnection = this; }
  ~HelpConnection(void)
    { TheHelpConnection = NULL; }
  Bool OnExecute(char *topic, char *data, int size, int format);
  Bool OnDisconnect(void);
//  char *OnRequest(char *topic, char *item, int *size, int format);
//  Bool OnPoke(char *topic, char *item, char *data, int size, int format);
};

class HelpServer: public wxServer
{
 public:
  wxConnection *OnAcceptConnection(char *topic)
    { if (strcmp(topic, "WXHELP") == 0 && (!TheHelpConnection))
        return new HelpConnection;
      else return NULL; }
};
