unit Caldemo;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Ad3dcal, SysUtils,
  TabNotBk;

type
  TTAdrock3dCalendarForm = class(TForm)
    Image1: TImage;
    Image2: TImage;
    TabbedNotebook1: TTabbedNotebook;
    Adrock3dCalendar2: TAdrock3dCalendar;
    Adrock3dCalendar1: TAdrock3dCalendar;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    Label3: TLabel;
    Adrock3dCalendar3: TAdrock3dCalendar;
    EventsListBox: TListBox;
    Panel1: TPanel;
    BitBtn13: TBitBtn;
    OnDateChangeCheckBox: TCheckBox;
    onDayChangeCheckBox: TCheckBox;
    onMonthChangeCheckBox: TCheckBox;
    OnYearChangeCheckBox: TCheckBox;
    OnCellClickCheckBox: TCheckBox;
    onCellDblClickCheckBox: TCheckBox;
    OptionsGroupBox: TGroupBox;
    MonthAndYearComboRadioButton: TRadioButton;
    NothingRadioButton: TRadioButton;
    MonthAndYearLabelsRadioButton: TRadioButton;
    ShowOnCalendarGroupBox: TGroupBox;
    ShowButtonsCheckBox: TCheckBox;
    ShowWeekDayHeaderCheckBox: TCheckBox;
    ShowSaturdayColorCheckBox: TCheckBox;
    ShowSundayColorCheckBox: TCheckBox;
    ShowPrevNextMonthCheckBox: TCheckBox;
    CalendarButton: TBitBtn;
    TodayButton: TBitBtn;
    SetDateButton: TBitBtn;
    ScrollBar1: TScrollBar;
    ScrollBar2: TScrollBar;
    ScrollBar3: TScrollBar;
    ScrollBar4: TScrollBar;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Adrock3dCalendar4: TAdrock3dCalendar;
    ScrollBar5: TScrollBar;
    ScrollBar6: TScrollBar;
    ScrollBar7: TScrollBar;
    ScrollBar8: TScrollBar;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    ScrollBar9: TScrollBar;
    HorizontalAlignmentGroupBox: TGroupBox;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    VerticalAlignmentGroupBox: TGroupBox;
    RadioButton7: TRadioButton;
    RadioButton8: TRadioButton;
    RadioButton9: TRadioButton;
    CellSpaceGroupBox: TGroupBox;
    ScrollBar10: TScrollBar;
    ScrollBar11: TScrollBar;
    Label13: TLabel;
    Label14: TLabel;
    CheckBox1: TCheckBox;
    CheckBox3: TCheckBox;
    Adrock3dCalendar5: TAdrock3dCalendar;
    ListBox3: TListBox;
    ListBox5: TListBox;
    ListBox4: TListBox;
    CellBevelGroupBox: TGroupBox;
    Label16: TLabel;
    ScrollBar13: TScrollBar;
    RadioButton10: TRadioButton;
    RadioButton11: TRadioButton;
    RadioButton12: TRadioButton;
    CellSurroundGroupBox: TGroupBox;
    Label15: TLabel;
    ScrollBar12: TScrollBar;
    RadioButton13: TRadioButton;
    RadioButton14: TRadioButton;
    RadioButton15: TRadioButton;
    FontDialog1: TFontDialog;
    Edit1: TEdit;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Adrock3dCalendar6: TAdrock3dCalendar;
    BitBtn12: TBitBtn;
    BitBtn17: TBitBtn;
    BitBtn16: TBitBtn;
    ColorDialog1: TColorDialog;
    BitBtn11: TBitBtn;
    BitBtn18: TBitBtn;
    BitBtn19: TBitBtn;
    BitBtn20: TBitBtn;
    BitBtn21: TBitBtn;
    BitBtn23: TBitBtn;
    BitBtn24: TBitBtn;
    BitBtn25: TBitBtn;
    Label21: TLabel;
    Adrock3dCalendar7: TAdrock3dCalendar;
    Label22: TLabel;
    SelectedDateLabel: TLabel;
    Label23: TLabel;
    SelectedDayLabel: TLabel;
    Label25: TLabel;
    SelectedMonthLabel: TLabel;
    SelectedYearLabel: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    DayOfWeekLabel: TLabel;
    DayOfYearLabel: TLabel;
    Label32: TLabel;
    Label28: TLabel;
    WeekOfYearLabel: TLabel;
    WeekOfMonthLabel: TLabel;
    Label30: TLabel;
    Label24: TLabel;
    CenturyLabel: TLabel;
    Quarter: TLabel;
    QuarterLabel: TLabel;
    Label29: TLabel;
    DayThLabel: TLabel;
    Label31: TLabel;
    DaysAgoLabel: TLabel;
    Label33: TLabel;
    WeeksAgoLabel: TLabel;
    Label35: TLabel;
    MonthsAgoLabel: TLabel;
    Label37: TLabel;
    YearsAgoLabel: TLabel;
    Label34: TLabel;
    DaysBetweenDatesLabel: TLabel;
    Label38: TLabel;
    WeeksBetweenDatesLabel: TLabel;
    Label40: TLabel;
    MonthsBetweenDatesLabel: TLabel;
    Label42: TLabel;
    YearsBetweenDatesLabel: TLabel;
    Label36: TLabel;
    BoundryWeeksBetweenDatesLabel: TLabel;
    Label39: TLabel;
    BoundryMonthsBetweenDatesLabel: TLabel;
    Label43: TLabel;
    BoundryYearsBetweenDatesLabel: TLabel;
    Label41: TLabel;
    DelphiDayOfWeekLabel: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    BoundryQuartersBetweenDatesLabel: TLabel;
    Label46: TLabel;
    QuartersAgoLabel: TLabel;
    Adrock3dCalendar8: TAdrock3dCalendar;
    Label2: TLabel;
    SelectedDateLabel1: TLabel;
    Label48: TLabel;
    SelectedDatePlus1DayLabel: TLabel;
    Label50: TLabel;
    Label47: TLabel;
    Label54: TLabel;
    SelectedDatePlus1WeekLabel: TLabel;
    SelectedDatePlus1MonthLabel: TLabel;
    SelectedDatePlus1YearLabel: TLabel;
    Label49: TLabel;
    SelectedDateMinus1DayLabel: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label55: TLabel;
    SelectedDateMinus1WeekLabel: TLabel;
    SelectedDateMinus1MonthLabel: TLabel;
    SelectedDateMinus1YearLabel: TLabel;
    Label51: TLabel;
    AddDateLabel: TLabel;
    AddDateType: TEdit;
    AddDateNumber: TEdit;
    Label57: TLabel;
    Label58: TLabel;
    DateDiffLabel: TLabel;
    DateDiffType: TEdit;
    Label56: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Label61: TLabel;
    UpdateAddDateButton: TBitBtn;
    UpdateDateDiffButton: TBitBtn;
    Label1: TLabel;
    DaysLeftInYearLabel: TLabel;
    Label63: TLabel;
    DayOfMonthLabel: TLabel;
    Label65: TLabel;
    Label62: TLabel;
    DaysLeftInMonthLabel: TLabel;
    Label64: TLabel;
    QuartersBetweenDatesLabel: TLabel;
    Label66: TLabel;
    OnWeekChangeCheckBox: TCheckBox;
    procedure Adrock3dCalendar2KeyPress(Sender: TObject; var Key: Char);
    procedure OwnerDrawCheckBoxClick(Sender: TObject);
    procedure Adrock3dCalendar5DrawCell(Sender: TObject; CellRect: TRect;
      Day, CellID: Integer; CellInCurrentMonth, Selected: Boolean;
      var UseDefaultDrawing: Boolean);
    procedure Adrock3dCalendar2DBlCLick(Sender: TObject);
    procedure Adrock3dCalendar2DateChange(Sender: TObject);
    procedure UpdateAddDateButtonClick(Sender: TObject);
    procedure ListBox4DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Adrock3dCalendar5DragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure Adrock3dCalendar5DragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure ListBox4DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn13Click(Sender: TObject);
    procedure Adrock3dCalendar3DateChange(Sender: TObject);
    procedure Adrock3dCalendar3DayChange(Sender: TObject);
    procedure Adrock3dCalendar3MonthChange(Sender: TObject);
    procedure Adrock3dCalendar3YearChange(Sender: TObject);
    procedure MonthAndYearLabelsRadioButtonClick(Sender: TObject);
    procedure MonthAndYearComboRadioButtonClick(Sender: TObject);
    procedure NothingRadioButtonClick(Sender: TObject);
    procedure ShowButtonsCheckBoxClick(Sender: TObject);
    procedure ShowWeekDayHeaderCheckBoxClick(Sender: TObject);
    procedure ShowSaturdayColorCheckBoxClick(Sender: TObject);
    procedure ShowSundayColorCheckBoxClick(Sender: TObject);
    procedure ShowPrevNextMonthCheckBoxClick(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ScrollBar2Change(Sender: TObject);
    procedure ScrollBar3Change(Sender: TObject);
    procedure ScrollBar4Change(Sender: TObject);
    procedure CalendarButtonClick(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure BitBtn9Click(Sender: TObject);
    procedure BitBtn10Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure TodayButtonClick(Sender: TObject);
    procedure SetDateButtonClick(Sender: TObject);
    procedure ScrollBar5Change(Sender: TObject);
    procedure ScrollBar6Change(Sender: TObject);
    procedure ScrollBar7Change(Sender: TObject);
    procedure ScrollBar8Change(Sender: TObject);
    procedure ScrollBar9Change(Sender: TObject);
    procedure ScrollBar10Change(Sender: TObject);
    procedure ScrollBar11Change(Sender: TObject);
    procedure RadioButton4Click(Sender: TObject);
    procedure RadioButton5Click(Sender: TObject);
    procedure RadioButton6Click(Sender: TObject);
    procedure RadioButton7Click(Sender: TObject);
    procedure RadioButton8Click(Sender: TObject);
    procedure RadioButton9Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure ScrollBar13Change(Sender: TObject);
    procedure RadioButton11Click(Sender: TObject);
    procedure RadioButton10Click(Sender: TObject);
    procedure RadioButton12Click(Sender: TObject);
    procedure ScrollBar12Change(Sender: TObject);
    procedure RadioButton14Click(Sender: TObject);
    procedure RadioButton13Click(Sender: TObject);
    procedure RadioButton15Click(Sender: TObject);
    procedure CellFontButtonClick(Sender: TObject);
    procedure BitBtn15Click(Sender: TObject);
    procedure BitBtn14Click(Sender: TObject);
    procedure Edit1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Edit1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure BitBtn12Click(Sender: TObject);
    procedure BitBtn17Click(Sender: TObject);
    procedure BitBtn16Click(Sender: TObject);
    procedure BitBtn11Click(Sender: TObject);
    procedure BitBtn18Click(Sender: TObject);
    procedure BitBtn19Click(Sender: TObject);
    procedure BitBtn20Click(Sender: TObject);
    procedure BitBtn21Click(Sender: TObject);
    procedure BitBtn22Click(Sender: TObject);
    procedure BitBtn23Click(Sender: TObject);
    procedure BitBtn24Click(Sender: TObject);
    procedure BitBtn25Click(Sender: TObject);
    procedure Adrock3dCalendar7DateChange(Sender: TObject);
    procedure TabbedNotebook1Change(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure Adrock3dCalendar8DateChange(Sender: TObject);
    procedure UpdateDateDiffButtonClick(Sender: TObject);
    procedure Adrock3dCalendar3WeekChange(Sender: TObject);
    procedure Adrock3dCalendar3CellClick(Sender: TObject; CellRect: TRect;
      Day, CellID: Integer; CellInCurrentMonth: Boolean);
    procedure Adrock3dCalendar3CellDblClick(Sender: TObject;
      CellRect: TRect; Day, CellID: Integer; CellInCurrentMonth: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TAdrock3dCalendarForm: TTAdrock3dCalendarForm;
  CellsImage  : Array [1..42] of String;
  Cells       : Array [1..42] of String;

implementation

{$R *.DFM}

procedure TTAdrock3dCalendarForm.Adrock3dCalendar2KeyPress(Sender: TObject;
  var Key: Char);
begin
     ShowMessage('Key');
end;

procedure TTAdrock3dCalendarForm.OwnerDrawCheckBoxClick(Sender: TObject);
begin
     if (Adrock3dCalendar2.Style = odStandard) then
       Adrock3dCalendar2.Style := odOwnerDraw
     else
       Adrock3dCalendar2.Style := odStandard;

end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar5DrawCell(Sender: TObject;
  CellRect: TRect; Day, CellID: Integer; CellInCurrentMonth,
  Selected: Boolean; var UseDefaultDrawing: Boolean);
Var
   ImageWidth  : Integer;
   ImageHeight : Integer;
begin
{ if (Day > 10) and (Day < 20) then
  begin
    UseDefaultDrawing := TRUE;
    exit;
  end;
}
  Adrock3dCalendar5.Canvas.Font.Name := 'SmallFonts';
  Adrock3dCalendar5.Canvas.Font.Size := 6;

  if (Selected = TRUE) then
     Adrock3dCalendar5.Canvas.brush.Color := clRED
  else if (CellInCurrentMonth = FALSE) then
    Adrock3dCalendar5.Canvas.brush.Color := ClGREEN
  else
     Adrock3dCalendar5.Canvas.brush.Color := clBLUE;
     Adrock3dCalendar5.Canvas.Pen .Color := clWHITE;
     Adrock3dCalendar5.Canvas.FillRect(CellRect);
     Adrock3dCalendar5.Canvas.TextOut(CellRect.Left, CellRect.Top, IntToStr(Day));

     if (Cells[CellID] > '') then
      begin
        Adrock3dCalendar5.Canvas.Font.Color := clWhite;
        Adrock3dCalendar5.Canvas.TextOut(CellRect.Left, CellRect.Bottom-Adrock3dCalendar5.Canvas.textHeight('A'),
          Cells[CellID]);
        Adrock3dCalendar5.Canvas.Font.Color := clRed;
      end;

     if (CellsImage[CellID] = 'Alarm') then
     begin
       ImageWidth := Image1.Picture.Bitmap.Width;
       ImageHeight := Image1.Picture.Bitmap.height;
       Adrock3dCalendar5.Canvas.Draw(CellRect.Right-ImageWidth, CellRect.Top, Image1.Picture.Bitmap);
     end;
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar2DBlCLick(Sender: TObject);
begin
     ShowMessage('Double Click');
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar2DateChange(Sender: TObject);
begin
     CalendarButton.Caption := 'Click Here : '+Adrock3dCalendar2.FormatDate('dZ MMMM YYYY', Adrock3dCalendar2.Date);
end;

procedure TTAdrock3dCalendarForm.UpdateAddDateButtonClick(Sender: TObject);
begin
     AddDateLabel.Caption := FormatDateTime('D MMM, YYYY', Adrock3dCalendar8.AddDate(AddDateType.Text,
       StrToInt(AddDateNumber.Text),  Adrock3dCalendar8.Date));
end;

procedure TTAdrock3dCalendarForm.ListBox4DragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var
 Point : TPoint;
begin
   Point.X := X;
   Point.y := Y;
   ListBox4.Items.Add(DateToStr((Source As TAdrock3dCalendar).Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar5DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
     if ((Source = ListBox3) or (Source = ListBox5)) and (Adrock3dCalendar5.GetIndexFromPoint(x,y) <> -1) then
       Accept := TRUE
     else
       Accept := FALSE;
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar5DragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
  Index     : Integer;
  CurrMonth : String;
begin
     Index := Adrock3dCalendar5.GetIndexFromPoint(x,y);
     if (Adrock3dCalendar5.ISIndexInCurrentCalendarMonth(Index) = TRUE) then
       CurrMonth := 'TRUE'
     else
       CurrMonth := 'False';

     if ((Source = ListBox3) or (Source = ListBox5)) and (Index <> -1) then
      begin
       ListBox4.Items.Add(
         'X = '+IntToStr(x)+
         ', Y = '+IntToStr(y)+
         ', Day = '+IntToStr(Adrock3dCalendar5.GetDayFromIndex(Index))+
         ', Cell = '+IntToStr(Index)+
         ', Date = '+DateToStr(Adrock3dCalendar5.GetDateFromIndex(Index))+
         ', CurrentMonth = '+ CurrMonth);
        if (Source = ListBox3) then
         begin
           Cells[Index] := ListBox3.Items[ListBox3.ItemIndex];
           Adrock3dCalendar5.RepaintCellByIndex(Index);
         end
       else
        begin
          CellsImage[Index] := ListBox5.Items[ListBox5.ItemIndex];
          Adrock3dCalendar5.RepaintCellByIndex(Index);
        end;
      end;
     ShowMessage('Something has been dropped on the calendar.');
end;

procedure TTAdrock3dCalendarForm.ListBox4DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Source = Adrock3dCalendar5);

end;

procedure TTAdrock3dCalendarForm.FormCreate(Sender: TObject);
Var
  Pos : Integer;
begin
  Adrock3dCalendar3.fMonthComboBox.TabStop := FALSE;
  Adrock3dCalendar3.fYearComboBox.TabStop := FALSE;
  CalendarButton.Caption := 'Click Here : '+Adrock3dCalendar2.FormatDate('dZ MMMM YYYY', Adrock3dCalendar2.Date);
  Scrollbar1.Position  := Adrock3dCalendar4.SpaceATTop;
  Scrollbar2.Position  := Adrock3dCalendar4.SpaceATBottom;
  Scrollbar3.Position  := Adrock3dCalendar4.SpaceFromSides;
  ScrollBar4.Position  := Adrock3dCalendar4.SpaceAtLeft;
  ScrollBar5.Position  := Adrock3dCalendar4.SpaceBetweenTopAndLabels;
  ScrollBar6.Position  := Adrock3dCalendar4.SpaceBetweenLabelsAndWeekDayHeader;
  ScrollBar7.Position  := Adrock3dCalendar4.SpaceBetweenCellsAndButtons;
  ScrollBar8.Position  := Adrock3dCalendar4.SpaceBetweenButtonsAndBottom;
  ScrollBar9.Position  := Adrock3dCalendar4.SpaceBetweenWeekDayHeaderAndCells;
  Scrollbar10.Position := Adrock3dCalendar2.CellSpaceX;
  Scrollbar11.Position := Adrock3dCalendar2.CellSpaceY;
  Scrollbar12.Position := Adrock3dCalendar2.CellsSurroundBevelWidth;
  Scrollbar13.Position := Adrock3dCalendar2.CellBevelWidth; 
  for Pos := 0 to 42 do
     Cells[Pos] := '';
  for Pos := 0 to 42 do
     CellsImage[Pos] := '';
  TabbedNoteBook1.PageIndex := 0;
end;

procedure TTAdrock3dCalendarForm.BitBtn13Click(Sender: TObject);
begin
     EventsListBox.Items.Clear;
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3DateChange(Sender: TObject);
begin
  if (onDateChangeCheckBox.Checked) then
     EventsListBox.Items.Add('DateChange '+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3DayChange(Sender: TObject);
begin
  if (onDayChangeCheckBox.Checked) then
     EventsListBox.Items.Add('DayChange '+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3MonthChange(Sender: TObject);
begin
  if (onMonthChangeCheckBox.Checked) then
     EventsListBox.Items.Add('MonthChange '+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3YearChange(Sender: TObject);
begin
  if (onYearChangeCheckBox.Checked) then
     EventsListBox.Items.Add('YearChange '+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));

end;

procedure TTAdrock3dCalendarForm.MonthAndYearLabelsRadioButtonClick(Sender: TObject);
begin
   Adrock3dCalendar2.ShowOnCalendar := scLabels;
end;

procedure TTAdrock3dCalendarForm.MonthAndYearComboRadioButtonClick(Sender: TObject);
begin
     Adrock3dCalendar2.ShowOnCalendar := scCombos;
end;

procedure TTAdrock3dCalendarForm.NothingRadioButtonClick(Sender: TObject);
begin
     Adrock3dCalendar2.ShowOnCalendar := scNothing;
end;

procedure TTAdrock3dCalendarForm.ShowButtonsCheckBoxClick(Sender: TObject);
begin
     Adrock3dCalendar2.ShowButtonBar :=  ShowButtonsCheckBox.Checked;
end;

procedure TTAdrock3dCalendarForm.ShowWeekDayHeaderCheckBoxClick(Sender: TObject);
begin
     Adrock3dCalendar2.ShowWeekDayHeader :=  ShowWeekDayHeaderCheckBox.Checked;
end;

procedure TTAdrock3dCalendarForm.ShowSaturdayColorCheckBoxClick(Sender: TObject);
begin
{     Adrock3dCalendar2.ShowSaturdayColor :=  ShowSaturdayColorCheckBox.Checked;}
end;

procedure TTAdrock3dCalendarForm.ShowSundayColorCheckBoxClick(Sender: TObject);
begin
{     Adrock3dCalendar2.ShowSundayColor :=  ShowSundayColorCheckBox.Checked;}
end;

procedure TTAdrock3dCalendarForm.ShowPrevNextMonthCheckBoxClick(Sender: TObject);
begin
     Adrock3dCalendar2.ShowPrevNextMonth :=  ShowPrevNextMonthCheckBox.Checked;
end;

procedure TTAdrock3dCalendarForm.ScrollBar1Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceAtTop:=ScrollBar1.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar2Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceAtBottom :=ScrollBar2.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar3Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceFromSides :=ScrollBar3.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar4Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceAtLeft :=ScrollBar4.Position
end;

procedure TTAdrock3dCalendarForm.CalendarButtonClick(Sender: TObject);
begin
     Messagedlg('This button was placed on the calendar, because the calendar '+
                'can accept child controls.'+#13#13+'You can make space for the '+
                'child controls just by setting a few properties.'+#13#13+
                'Check the PrecisionSpacing tab for examples that deal with spacing.',
                mtInformation, [mbok], 0);

end;

procedure TTAdrock3dCalendarForm.BitBtn7Click(Sender: TObject);
begin
     Adrock3dCalendar1.NextMonth;
end;

procedure TTAdrock3dCalendarForm.BitBtn8Click(Sender: TObject);
begin
     Adrock3dCalendar1.PrevMonth;
end;

procedure TTAdrock3dCalendarForm.BitBtn9Click(Sender: TObject);
begin
     Adrock3dCalendar1.NextYear;
end;

procedure TTAdrock3dCalendarForm.BitBtn10Click(Sender: TObject);
begin
     Adrock3dCalendar1.PrevYear;
end;

procedure TTAdrock3dCalendarForm.BitBtn3Click(Sender: TObject);
begin
     Adrock3dCalendar1.NextDay;
end;

procedure TTAdrock3dCalendarForm.BitBtn4Click(Sender: TObject);
begin
     Adrock3dCalendar1.PrevDay;
end;

procedure TTAdrock3dCalendarForm.BitBtn5Click(Sender: TObject);
begin
     Adrock3dCalendar1.NextWeek;
end;

procedure TTAdrock3dCalendarForm.BitBtn6Click(Sender: TObject);
begin
     Adrock3dCalendar1.PrevWeek;
end;

procedure TTAdrock3dCalendarForm.TodayButtonClick(Sender: TObject);
begin
     Adrock3dCalendar1.Today;
end;

procedure TTAdrock3dCalendarForm.SetDateButtonClick(Sender: TObject);
begin
     Adrock3dCalendar1.Date:= EncodeDate(1996, 1,25);
end;

procedure TTAdrock3dCalendarForm.ScrollBar5Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceBetweenTopAndLabels :=  ScrollBar5.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar6Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceBetweenLabelsAndWeekDayHeader :=  ScrollBar6.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar7Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceBetweenCellsAndButtons :=  ScrollBar7.Position;
end;

procedure TTAdrock3dCalendarForm.ScrollBar8Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceBetweenButtonsAndBottom :=  ScrollBar8.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar9Change(Sender: TObject);
begin
     Adrock3dCalendar4.SpaceBetweenWeekDayHeaderAndCells :=  ScrollBar9.Position
end;

procedure TTAdrock3dCalendarForm.ScrollBar10Change(Sender: TObject);
begin
     Adrock3dCalendar2.CellSpaceX := Scrollbar10.Position;
end;

procedure TTAdrock3dCalendarForm.ScrollBar11Change(Sender: TObject);
begin
     Adrock3dCalendar2.CellSpaceY := Scrollbar11.Position;
end;

procedure TTAdrock3dCalendarForm.RadioButton4Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextHorizontalAlign := htLeft;
end;

procedure TTAdrock3dCalendarForm.RadioButton5Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextHorizontalAlign := htCenter;
end;

procedure TTAdrock3dCalendarForm.RadioButton6Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextHorizontalAlign := htRight;
end;

procedure TTAdrock3dCalendarForm.RadioButton7Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextVerticalAlign := vtTop;
end;

procedure TTAdrock3dCalendarForm.RadioButton8Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextVerticalAlign := vtCenter;
end;

procedure TTAdrock3dCalendarForm.RadioButton9Click(Sender: TObject);
begin
     Adrock3dCalendar2.CellTextVerticalAlign := vtBottom;
end;

procedure TTAdrock3dCalendarForm.CheckBox1Click(Sender: TObject);
begin
     if (CheckBox1.Checked = TRUE) then
      begin
        Adrock3dCalendar3.MouseMode := CmClickAndMoveAroundCells;
        MessageDlg('Click the mouse over a cell and while the mouse button is down move the mouse.',
          mtInformation, [mbOK], 0);
      end
     else
       begin
        Adrock3dCalendar3.MouseMode := CmClickOnCell;
        MessageDlg('Click the mouse over a cell and while the mouse button is down move the mouse.',
          mtInformation, [mbOK], 0);
      end
end;

procedure TTAdrock3dCalendarForm.CheckBox3Click(Sender: TObject);
begin
     if (CheckBox3.Checked = TRUE) then
      begin
        Adrock3dCalendar3.SelectMode := smDuringMouseMove
      end
     else
      begin
        Adrock3dCalendar3.SelectMode := smOnlyAfterMouseUp;
      end

end;

procedure TTAdrock3dCalendarForm.ScrollBar13Change(Sender: TObject);
begin
  Adrock3dCalendar2.CellBevelWidth := Scrollbar13.Position;
end;

procedure TTAdrock3dCalendarForm.RadioButton11Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellBevel := bvNone;

end;

procedure TTAdrock3dCalendarForm.RadioButton10Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellBevel := bvRaised

end;

procedure TTAdrock3dCalendarForm.RadioButton12Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellBevel := bvLowered;
end;

procedure TTAdrock3dCalendarForm.ScrollBar12Change(Sender: TObject);
begin
  Adrock3dCalendar2.CellsSurroundBevelWidth := Scrollbar12.Position;
end;

procedure TTAdrock3dCalendarForm.RadioButton14Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellsSurroundBevel := bvNone;
end;

procedure TTAdrock3dCalendarForm.RadioButton13Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellsSurroundBevel := bvRaised;
end;

procedure TTAdrock3dCalendarForm.RadioButton15Click(Sender: TObject);
begin
  Adrock3dCalendar2.CellsSurroundBevel := bvLowered;
end;

procedure TTAdrock3dCalendarForm.CellFontButtonClick(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar2.CellFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar2.CellFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn15Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar2.WeekDayHeaderFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar2.WeekDayHeaderFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn14Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar2.SelectedCellFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar2.SelectedCellFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.Edit1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     if (Source = Adrock3dCalendar5) then
       Accept := TRUE;
end;

procedure TTAdrock3dCalendarForm.Edit1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
Var
 Point : TPoint;
begin
   Point.X := X;
   Point.y := Y;
   Edit1.text := DateToStr((Source As TAdrock3dCalendar).Date);
   ShowMessage('Date has been dropped : '+Edit1.Text);
end;

procedure TTAdrock3dCalendarForm.BitBtn12Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar6.CellFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar6.CellFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn17Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar6.WeekDayHeaderFont);
     if (FontDialog1.Execute = TRUE) then
        Adrock3dCalendar6.WeekDayHeaderFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn16Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar6.SelectedCellFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar6.SelectedCellFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn11Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorBack;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorBack := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn18Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorBetweenCellsBackColor;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorBetweenCellsBackColor := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn19Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorWeekDayHeaderBackColor;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorWeekDayHeaderBackColor := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn20Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorWorkDay;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorWorkDay := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn21Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorNonWorkDay;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorNonWorkDay := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn22Click(Sender: TObject);
begin
{     ColorDialog1.Color := Adrock3dCalendar6.ColorSunday;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorSunday := ColorDialog1.Color;
}
end;

procedure TTAdrock3dCalendarForm.BitBtn23Click(Sender: TObject);
begin
     ColorDialog1.Color := Adrock3dCalendar6.ColorPrevNextMonth;
     if (ColorDialog1.Execute = TRUE) then
       Adrock3dCalendar6.ColorPrevNextMonth := ColorDialog1.Color;
end;

procedure TTAdrock3dCalendarForm.BitBtn24Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar6.MonthLabelFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar6.MonthLabelFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.BitBtn25Click(Sender: TObject);
begin
     FontDialog1.Font.Assign(Adrock3dCalendar6.YearLabelFont);
     if (FontDialog1.Execute = TRUE) then
       Adrock3dCalendar6.YearLabelFont.Assign(FontDialog1.Font);
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar7DateChange(Sender: TObject);
begin
     { The functions that are using 2 mean that the starting ssay of the week is a }
     { monday, Since 1=Sunday, 2=Monday, etc.. }
     SelectedDateLabel.Caption := DateToStr(Adrock3dCalendar7.Date);
     SelectedDayLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDayOfMonth(Adrock3dCalendar7.Date));
     SelectedMonthLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnMonth(Adrock3dCalendar7.Date));
     SelectedYearLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnYear(Adrock3dCalendar7.Date));

     DayOfWeekLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDayOfWeek(2, Adrock3dCalendar7.Date))+
                            ', '+Adrock3dCalendar7.ReturnWeekDayName(2,
                             Adrock3dCalendar7.ReturnDayOfWeek(2, Adrock3dCalendar7.Date));

     DelphiDayOfWeekLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDelphiDayOfWeek(2,
        Adrock3dCalendar7.ReturnDayOfWeek(2, Adrock3dCalendar7.Date)));

     DayOfYearLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDayOfYear(Adrock3dCalendar7.Date));
     DaysLeftInyearLabel.Caption := IntToStr(Adrock3dCalendar7.DaysLeftInyear(Adrock3dCalendar7.Date));
     DayOfMonthLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDayOfMonth(Adrock3dCalendar7.Date));
     DaysLeftInMonthLabel.Caption := IntToStr(Adrock3dCalendar7.DaysLeftInMonth(Adrock3dCalendar7.Date));
     WeekOfMonthLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnWeekofMonth(2, Adrock3dCalendar7.Date));
     WeekOfYearLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnWeekofYear(Adrock3dCalendar7.Date));
     QuarterLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnQuarter(Adrock3dCalendar7.Date));
     CenturyLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnCentury(Adrock3dCalendar7.Date));

     DayThLabel.Caption := Adrock3dCalendar7.ReturnDayTh(Adrock3dCalendar7.Date)+',  '+
       IntToStr(Adrock3dCalendar7.ReturnDayOfMonth(Adrock3dCalendar7.Date))+
       Adrock3dCalendar7.ReturnDayTh(Adrock3dCalendar7.Date);

     DaysAgoLabel.Caption := Adrock3dCalendar7.ReturnDaysAgo(Adrock3dCalendar7.Date);
     WeeksAgoLabel.Caption := Adrock3dCalendar7.ReturnWeeksAgo(2, Adrock3dCalendar7.Date);
     MonthsAgoLabel.Caption := Adrock3dCalendar7.ReturnMonthsAgo(Adrock3dCalendar7.Date);
     QuartersAgoLabel.Caption := Adrock3dCalendar7.ReturnQuartersAgo(Adrock3dCalendar7.Date);
     YearsAgoLabel.Caption := Adrock3dCalendar7.ReturnYearsAgo(Adrock3dCalendar7.Date);

     DaysBetweenDatesLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnDaysBetweenDates(Adrock3dCalendar7.Date, Date));
     WeeksBetweenDatesLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnWeeksBetweenDates(Adrock3dCalendar7.Date, Date));
     MonthsBetweenDatesLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnMonthsBetweenDates(Adrock3dCalendar7.Date, Date));
     QuartersBetweenDatesLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnQuartersBetweenDates(Adrock3dCalendar7.Date, Date));
     YearsBetweenDatesLabel.Caption := IntToStr(Adrock3dCalendar7.ReturnYearsBetweenDates(Adrock3dCalendar7.Date, Date));

     BoundryWeeksBetweenDatesLabel.Caption :=
         IntToStr(Adrock3dCalendar7.ReturnBoundaryWeeksBetweenDates(2, Adrock3dCalendar7.Date, Date));
     BoundryMonthsBetweenDatesLabel.Caption :=
         IntToStr(Adrock3dCalendar7.ReturnBoundaryMonthsBetweenDates(Adrock3dCalendar7.Date, Date));
     BoundryQuartersBetweenDatesLabel.Caption :=
         IntToStr(Adrock3dCalendar7.ReturnBoundaryQuartersBetweenDates(Adrock3dCalendar7.Date, Date));
     BoundryYearsBetweenDatesLabel.Caption :=
         IntToStr(Adrock3dCalendar7.ReturnBoundaryYearsBetweenDates(Adrock3dCalendar7.Date, Date));
end;

procedure TTAdrock3dCalendarForm.TabbedNotebook1Change(Sender: TObject;
  NewTab: Integer; var AllowChange: Boolean);
begin
     if (newTab = 3) then
      begin
        { Update the details on this form }
        Adrock3dCalendar7.Date := Date;
        Adrock3dCalendar7DateChange(Sender);
      end;
     if (newTab = 4) then
      begin
        { Update the details on this form }
        Adrock3dCalendar8.Date := Date;
        Adrock3dCalendar8DateChange(Sender);
      end;
end;

procedure TTAdrock3dCalendarForm.BitBtn1Click(Sender: TObject);
begin
     TabbedNotebook1.PageIndex := 4;
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar8DateChange(Sender: TObject);
begin
     SelectedDatelabel1.Caption      := DateToStr(Adrock3dCalendar8.Date);
     SelectedDatePlus1DayLabel.Caption    := DateToStr(Adrock3dCalendar8.AddDays(1, Adrock3dCalendar8.Date));
     SelectedDatePlus1WeekLabel.Caption   := DateToStr(Adrock3dCalendar8.AddWeeks(1, Adrock3dCalendar8.Date));
     SelectedDatePlus1MonthLabel.Caption  := DateToStr(Adrock3dCalendar8.AddMonths(1, Adrock3dCalendar8.Date));
     SelectedDatePlus1YearLabel.Caption   := DateToStr(Adrock3dCalendar8.AddYears(1, Adrock3dCalendar8.Date));

     SelectedDateMinus1DayLabel.Caption    := DateToStr(Adrock3dCalendar8.AddDays(-1, Adrock3dCalendar8.Date));
     SelectedDateMinus1WeekLabel.Caption   := DateToStr(Adrock3dCalendar8.AddWeeks(-1, Adrock3dCalendar8.Date));
     SelectedDateMinus1MonthLabel.Caption  := DateToStr(Adrock3dCalendar8.AddMonths(-1, Adrock3dCalendar8.Date));
     SelectedDateMinus1YearLabel.Caption   := DateToStr(Adrock3dCalendar8.AddYears(-1, Adrock3dCalendar8.Date));

     UpdateAddDateButtonClick(Sender);
     UpdateDateDiffButtonClick(Sender);
end;

procedure TTAdrock3dCalendarForm.UpdateDateDiffButtonClick(Sender: TObject);
begin
     DateDiffLabel.Caption := IntToStr(Adrock3dCalendar8.DateDiff(DateDiffType.Text, 2, Adrock3dCalendar8.Date,
       StrToDate('10/10/95')));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3WeekChange(
  Sender: TObject);
begin
  if (OnWeekChangeCheckBox.Checked) then
     EventsListBox.Items.Add('WeekChange '+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3CellClick(
  Sender: TObject; CellRect: TRect; Day, CellID: Integer;
  CellInCurrentMonth: Boolean);
begin
  if (onCellClickCheckBox.Checked) then
     EventsListBox.Items.Add('CellClick'+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));
end;

procedure TTAdrock3dCalendarForm.Adrock3dCalendar3CellDblClick(
  Sender: TObject; CellRect: TRect; Day, CellID: Integer;
  CellInCurrentMonth: Boolean);
begin
  if (onCellDblClickCheckBox.Checked) then
     EventsListBox.Items.Add('CellDblClick'+Adrock3dCalendar3.FormatDate('DZ MMM, YYYY', Adrock3dCalendar3.Date));

end;

end.

