unit Alrmdemo;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
     SysUtils,  Dialogs, StdCtrls, Buttons, ExtCtrls, Adalarm;

type
  TTAdrockAlarmListSampleProgram = class(TForm)
    AdrockAlarmList1: TAdrockAlarmList;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    ListBox1: TListBox;
    Panel2: TPanel;
    BitBtn2: TBitBtn;
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure AdrockAlarmList1Alarm(Sender: TObject; AlarmEvent: Integer;
      Reference: String);
    procedure AdrockAlarmList1SecondChange(Sender: TObject;
      CurrentTime: TDateTime);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
  private
    { Private declarations }
    Function ReturnFutureTime(CurrentTime : TDateTime; Seconds : Integer) : TDateTime;
  public
    { Public declarations }
  end;

var
  TAdrockAlarmListSampleProgram: TTAdrockAlarmListSampleProgram;

implementation

{$R *.DFM}

Function TTAdrockAlarmListSampleProgram.ReturnFutureTime(CurrentTime : TDateTime; Seconds : Integer) : TDateTime;
Var
  AHour, AMin, ASec, AMSec : Word;
begin
  DecodeTime(CurrentTime, AHour, AMin, ASec, AMSec);
  ASec := ASec + Seconds;
  if (ASec > 59) then
   begin
     ASec := ASec - 60;
     AMin := AMin+1;
     if (AMin > 59) then
      begin
        AMin := Amin-60;
        Ahour := AHour+1;
        if (Ahour > 23) then
         begin
          AHour := AHour-23;
         end;
      end;
   end;
   AMsec :=0;
  Result := EncodeTime(AHour, AMin, ASec, AMsec);
end;

procedure TTAdrockAlarmListSampleProgram.BitBtn1Click(Sender: TObject);
Var
  AlarmTime : TDateTime;
begin
  AlarmTime := ReturnFutureTime(Time, 5);
  AdrockAlarmList1.AddExact(AlarmTime, 'Alarm Triggered : '+TimeToStr(AlarmTime));
  MessageDlg('Alarm set for '+TimeToStr(AlarmTime), mtInformation, [mbOK], 0);
end;

procedure TTAdrockAlarmListSampleProgram.AdrockAlarmList1Alarm(Sender: TObject;
  AlarmEvent: Integer; Reference: String);
begin
     ListBox1.Items.Add(TimeToStr(Time)+'   '+Reference);
     ListBox1.ItemIndex := ListBox1.Items.Count-1;
end;

procedure TTAdrockAlarmListSampleProgram.AdrockAlarmList1SecondChange(Sender: TObject;
  CurrentTime: TDateTime);
begin
     Panel2.Caption := formatDateTime('D MMMM, YYYY    HH:MM:SS AM/PM', Now);
end;

procedure TTAdrockAlarmListSampleProgram.FormCreate(Sender: TObject);
begin
    Panel2.Caption := formatDateTime('HH:MM:SS AM/PM', Time);
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 1), 'Thank you for looking at our TAdrockAlarmList component.');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 3), '');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 3), 'It supports an unlimited number of alarms.');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 5), '');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 5), 'Each alarm can be set for a specific time or it can be set '
                                                     +'using wildcards');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 5), 'that match a position in the time string.');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 7), '');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 7), 'Refer to the HELP FILE enclosed for more details on the alarms.');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 9), '');
    AdrockAlarmList1.AddExact(ReturnFutureTime(Time, 9), 'Click the buttons below and see the results....');
end;

procedure TTAdrockAlarmListSampleProgram.BitBtn2Click(Sender: TObject);
begin
  AdrockAlarmList1.Add('??:??:?0', 'Alarm triggered : ??:??:00, ??:??:10, ??:??:20, ??:??:30, ??:??:40, ??:??:50');
  MessageDlg('Alarm set to trigger at ??:??:00, ??:??:10, ??:??:20, ??:??:30, ??:??:40, ??:??:50', mtInformation, [mbOK], 0);
end;

procedure TTAdrockAlarmListSampleProgram.BitBtn3Click(Sender: TObject);
begin
     AdrockAlarmList1.Add(Edit1.Text, 'This alarm was triggered by the code in Edit1.Text ('+Edit1.Text+')');
     MessageDlg('Alarm set for '+Edit1.Text, mtInformation, [mbOK], 0);
end;

procedure TTAdrockAlarmListSampleProgram.BitBtn5Click(Sender: TObject);
begin
  AdrockAlarmList1.Add('12:00:00', 'This alarm is set to trigger at 12:00:00');
  MessageDlg('Alarm is set to trigger at 12:00:00', mtInformation, [mbOK], 0);
end;

procedure TTAdrockAlarmListSampleProgram.BitBtn4Click(Sender: TObject);
Var
  AlarmTime : TDateTime;
begin
  AlarmTime := ReturnFutureTime(Time, 30);
  AdrockAlarmList1.AddExact(AlarmTime, 'Alarm Triggered : '+TimeToStr(AlarmTime));
  MessageDlg('Alarm set for '+TimeToStr(AlarmTime), mtInformation, [mbOK], 0);
end;

end.


