unit dateEddm;

interface

uses
  Winprocs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, adEdit, adbutedt, addbdate, DB,
  DBTables, DBCtrls, Grids, DBGrids, AdDateEd, Tabnotbk;

type
  TDateDemoForm = class(TForm)
    ListBox1: TListBox;
    FontDialog1: TFontDialog;
    Label4: TLabel;
    Label5: TLabel;
    TAdrockDateEditPanel: TPanel;
    TAdrockDateEditLabel: TLabel;
    AdrockDateEdit1: TAdrockDateEdit;
    Label36: TLabel;
    ColorDialog1: TColorDialog;
    Table1: TTable;
    DataSource1: TDataSource;
    TabbedNotebook1: TTabbedNotebook;
    MaxDateLabel: TLabel;
    MinDateLabel: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    ShowRangeErrorsCheckBox: TCheckBox;
    MinDate: TAdrockDateEdit;
    MaxDate: TAdrockDateEdit;
    DateValidityOptions: TComboBox;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label34: TLabel;
    Label27: TLabel;
    Label33: TLabel;
    Label35: TLabel;
    Label38: TLabel;
    Label39: TLabel;
    Label40: TLabel;
    ShippingLabel: TLabel;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    AdrockDBDateEdit1: TAdrockDBDateEdit;
    EventListBox: TListBox;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CalendarGridCombo: TComboBox;
    CalendarGridBevelCombo: TComboBox;
    Button1: TButton;
    Button2: TButton;
    CustomLabel: TLabel;
    InputStyleRadioGroup: TRadioGroup;
    DisplayStyleRadioGroup: TRadioGroup;
    CustomDisplayFormatEditField: TAdrockEdit;
    Panel1: TPanel;
    Label43: TLabel;
    CalendarTextColorGroupBox: TGroupBox;
    ColorCalendarHighlight: TButton;
    Button14: TButton;
    Button17: TButton;
    Button19: TButton;
    Button20: TButton;
    Button16: TButton;
    Button15: TButton;
    GridGroupBox: TGroupBox;
    Button9: TButton;
    ColorCalendarGridBackground: TButton;
    CalendarButtonGroupBox: TGroupBox;
    Button13: TButton;
    Button21: TButton;
    ColorCalendarButtonsDown: TButton;
    ColorCalendarButtonsUp: TButton;
    EditControlTextColorGroupBox: TGroupBox;
    Button5: TButton;
    Button22: TButton;
    ColorBadDateText: TButton;
    Button4: TButton;
    ColorWhileFocused: TButton;
    CalendarGroupBox: TGroupBox;
    ColorCalendarBack: TButton;
    ColorCalendarCaptionBack: TButton;
    ColorCalendarDateBevel: TButton;
    Button18: TButton;
    Label6: TLabel;
    Label7: TLabel;
    EditControlFontButton: TButton;
    CalendarFontButton: TButton;
    CalendarStatusFontButton: TButton;
    CalendarCaptionFont: TButton;
    Label14: TLabel;
    Label15: TLabel;
    Label37: TLabel;
    Label41: TLabel;
    CaptionLabel: TLabel;
    StatusTextLabel: TLabel;
    Label42: TLabel;
    AutoJumpFieldsCheckBox: TCheckBox;
    ShowWhenNilCheckBox: TCheckBox;
    ShowPrevNextMonthCheckBox: TCheckBox;
    ShowWeekNumbersCheckBox: TCheckBox;
    ShowMonthAsRadioGroup: TRadioGroup;
    StartingDayOfWeekComboBox: TComboBox;
    CalendarWeekNumberBevelComboBox: TComboBox;
    CaptionText: TAdrockEdit;
    StatusText: TAdrockEdit;
    CalendarDateBevelComboBox: TComboBox;
    EditWeekdayCheckBox: TCheckBox;
    Table1OrderNo: TFloatField;
    Table1CustNo: TFloatField;
    Table1ShipDate: TDateTimeField;
    Table1EmpNo: TIntegerField;
    procedure AdrockDateEdit1KeyPress(Sender: TObject; var Key: Char);
    procedure AdrockDateEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Up(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button2Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListBox1MeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure CalendarGridComboChange(Sender: TObject);
    procedure CalendarGridBevelComboChange(Sender: TObject);
    procedure EditControlFontButtonClick(Sender: TObject);
    procedure AutoJumpFieldsCheckBoxClick(Sender: TObject);
    procedure InputStyleRadioGroupClick(Sender: TObject);
    procedure DisplayStyleRadioGroupClick(Sender: TObject);
    procedure CustomDisplayFormatEditFieldChange(Sender: TObject);
    procedure ShowWhenNilCheckBoxClick(Sender: TObject);
    procedure ShowRangeErrorsCheckBoxClick(Sender: TObject);
    procedure ShowPrevNextMonthCheckBoxClick(Sender: TObject);
    procedure ShowWeekNumbersCheckBoxClick(Sender: TObject);
    procedure ShowMonthAsRadioGroupClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DateValidityOptionsChange(Sender: TObject);
    procedure MinDateExit(Sender: TObject);
    procedure MaxDateExit(Sender: TObject);
    procedure StartingDayOfWeekComboBoxChange(Sender: TObject);
    procedure CalendarWeekNumberBevelComboBoxChange(Sender: TObject);
    procedure ColorCalendarCaptionBackClick(Sender: TObject);
    procedure ColorCalendarDateBevelClick(Sender: TObject);
    procedure ColorCalendarGridBackgroundClick(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure ColorCalendarButtonsUpClick(Sender: TObject);
    procedure ColorCalendarButtonsDownClick(Sender: TObject);
    procedure ColorCalendarHighlightClick(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure ColorWhileFocusedClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure ColorBadDateTextClick(Sender: TObject);
    procedure ColorCalendarBackClick(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure CalendarFontButtonClick(Sender: TObject);
    procedure CalendarCaptionFontClick(Sender: TObject);
    procedure CalendarStatusFontButtonClick(Sender: TObject);
    procedure CaptionTextChange(Sender: TObject);
    procedure StatusTextChange(Sender: TObject);
    procedure CalendarDateBevelComboBoxChange(Sender: TObject);
    procedure EditWeekdayCheckBoxClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure AdrockDateEdit1BeforeChange(Sender: TObject);
    procedure AdrockDateEdit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DateDemoForm: TDateDemoForm;

implementation

{$R *.DFM}

procedure TDateDemoForm.AdrockDateEdit1KeyPress(Sender: TObject; var Key: Char);
begin
     ShowMessage('Key Press : '+Key);
end;

procedure TDateDemoForm.AdrockDateEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    ShowMessage('Key Down: '+IntToStr(Key));
end;

procedure TDateDemoForm.Up(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ShowMessage('Key Up : '+IntToStr(Key));
end;

procedure TDateDemoForm.Button2Click(Sender: TObject);
begin
{adrockLabel1.Caption := DateToStr(AddDate('M', ScrollBar1.Position, AdrockDateEdit1.Date));
}
end;

procedure TDateDemoForm.ScrollBar1Change(Sender: TObject);
begin
{  label1.Caption := intToStr(ScrollBar1.Position);
adrockLabel1.Caption := DateToStr(AddDate('M', ScrollBar1.Position, AdrockDateEdit1.Date));
}
end;

procedure TDateDemoForm.ListBox1DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
Var
 RectWidth : Integer;
 Center    : Boolean;
 X,Y       : Word;
 fText     : String;
begin
  With ListBox1.Canvas do
   begin
     fillRect(Rect);
     Font.Size := 8;
     Font.Style := [];
     Font.Color := clBlack;
     Font.Name := 'MS Sans Serif';
     Center := FALSE;

     RectWidth := Rect.Right - Rect.Left;

     fText := ListBox1.Items.Strings[Index];
     if (Index = 0) then
       begin
         Font.Name := 'Times New Roman';
         Font.Size := 18;
         Font.Style := [fsBold];
         Font.COlor := clBlue;
       end
     else if (Index = 1) then
       begin
         Font.Name := 'Times New Roman';
         Font.Size := 14;
         Font.Style := [fsBold];
         Font.COlor := clOlive;
       end;
     Case Index of
       0 .. 5 : Center := TRUE;
     else
       if (Index >= ListBox1.Items.Count-9) then
         Center := TRUE;
     end;
     Case Index of
       3..4         : font.Color := clNavy;
       6            : Font.Color := clRed;
       10,16,20,39  : Font.Color := clBlue;
       11,17,21     : Font.Color := clOlive;
     else if (Index >= ListBox1.Items.Count-9) then
         Font.Color := clNavy;
     end;
     Case Index of
       6 : Font.Size := 10;
     else
       if (Index = ListBox1.Items.Count-9) then
         begin
           Font.Size := 10;
           Font.Style := [fsbold];
           font.Color := clRED;
         End
       else if (Index = ListBox1.Items.Count-1) then
         begin
           Font.Size := 8;
           Font.Style := [fsbold];
           font.Color := clBlue;
         End;
     end;
     if (Center) then
      begin
         X := Rect.Left+(RectWidth div 2) - (TextWidth(fText) div 2);
         Y := Rect.Top;
      end
     else
       begin
         X := Rect.Left+2;
         Y := Rect.Top;
       end;
       TextRect(Rect, X, Y, fText);
   end;
end;

procedure TDateDemoForm.ListBox1MeasureItem(Control: TWinControl; Index: Integer;
  var Height: Integer);
begin
 Height := 13;
 case Index of
   0 : Height := 26;
   1 : Height := 22;
   6 : Height := 16;
 end;
end;

procedure TDateDemoForm.CalendarGridComboChange(Sender: TObject);
begin
     case (Sender as TComboBox).ItemIndex of
       0 : AdrockDateEdit1.CalendarGrid := cgNoGrid;
       1 : AdrockDateEdit1.CalendarGrid := cgCurrentMonth;
       2 : AdrockDateEdit1.CalendarGrid := cgWholeCalendar;
     end;
end;

procedure TDateDemoForm.CalendarGridBevelComboChange(Sender: TObject);
begin
     case (Sender as TComboBox).ItemIndex of
       0 : AdrockDateEdit1.CalendarGridBevel := bvNone;
       1 : AdrockDateEdit1.CalendarGridBevel := bvLowered;
       2 : AdrockDateEdit1.CalendarGridBevel := bvRaised;
     end;
end;

procedure TDateDemoForm.EditControlFontButtonClick(Sender: TObject);
begin
     FontDialog1.FOnt.Assign(AdrockDateEdit1.Font);
     if (FontDialog1.Execute = TRUE) then
       AdrockDateEdit1.Font.Assign(FontDialog1.FOnt);
end;

procedure TDateDemoForm.AutoJumpFieldsCheckBoxClick(Sender: TObject);
begin
     AdrockDateEdit1.AutoJumpFields := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.InputStyleRadioGroupClick(Sender: TObject);
begin
     Case (Sender as TRadioGroup).Itemindex of
       0 : AdrockDateEdit1.InputStyle := isDMY;
       1 : AdrockDateEdit1.InputStyle := isMDY;
       2 : AdrockDateEdit1.InputStyle := isYMD;
       3 : AdrockDateEdit1.InputStyle := isWeekDayDMY;
       4 : AdrockDateEdit1.InputStyle := isWeekDayMDY;
       5 : AdrockDateEdit1.InputStyle := isWeekDayYMD;
       6 : AdrockDateEdit1.InputStyle := isWindows;
       7 : AdrockDateEdit1.InputStyle := isWeekDayWindows;
     end;
end;

procedure TDateDemoForm.DisplayStyleRadioGroupClick(Sender: TObject);
begin
     Case (Sender as TRadioGroup).Itemindex of

       0 : begin
             AdrockDateEdit1.CustomDisplayFormat := CustomDisplayFormatEditField.Text;
             AdrockDateEdit1.DisplayStyle := dsCustomDate;
           end;
           
       1 : AdrockDateEdit1.DisplayStyle := dsDDMMYYYY;
       2 : AdrockDateEdit1.DisplayStyle := dsMMDDYYYY;
       3 : AdrockDateEdit1.DisplayStyle := dsYYYYMMDD;
       4 : AdrockDateEdit1.DisplayStyle := dsWindowsShortDate;
       5 : AdrockDateEdit1.DisplayStyle := dsWindowsLongDate;
       6 : AdrockDateEdit1.DisplayStyle := dsInputDateFormat;
     end;
end;

procedure TDateDemoForm.CustomDisplayFormatEditFieldChange(Sender: TObject);
begin
     AdrockDateEdit1.CustomDisplayFormat := CustomDisplayFormatEditField.Text;
     AdrockDateEdit1.Refresh;

end;

procedure TDateDemoForm.ShowWhenNilCheckBoxClick(Sender: TObject);
begin
     AdrockDateEdit1.ShowWhenNil := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.ShowRangeErrorsCheckBoxClick(Sender: TObject);
begin
    AdrockDateEdit1.ShowRangeErrors := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.ShowPrevNextMonthCheckBoxClick(Sender: TObject);
begin
    AdrockDateEdit1.ShowPrevNextMonth := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.ShowWeekNumbersCheckBoxClick(Sender: TObject);
begin
    AdrockDateEdit1.ShowWeekNumbers := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.ShowMonthAsRadioGroupClick(Sender: TObject);
begin
     Case (Sender as TRadioGroup).Itemindex of
       0 : AdrockDateEdit1.ShowMonthAs := smNumber;
       1 : AdrockDateEdit1.ShowMonthAs := smShortMonth;
       2 : AdrockDateEdit1.ShowMonthAs := smLongMonth;
     end;
end;

procedure TDateDemoForm.FormCreate(Sender: TObject);
begin
  CalendarWeekNumberBevelComboBox.ItemIndex := 2;
  StartingDayOfWeekComboBox.ItemIndex := 0;
  CalendarGridCombo.ItemIndex := 1;
  DateValidityOptions.ItemIndex := 0;
  CalendarGridBevelCombo.ItemIndex := 2;
  CalendarDateBevelComboBox.ItemIndex := 2;
  AdrockDateEdit1.DateMin := MinDate.Date;
  AdrockDateEdit1.DateMax := MaxDate.Date;
  TabbedNotebook1.PageIndex := 0;
end;

procedure TDateDemoForm.DateValidityOptionsChange(Sender: TObject);
begin
     case (Sender as TComboBox).ItemIndex of
       0 : AdrockDateEdit1.DateValidityOptions := dcoStandard;
       1 : AdrockDateEdit1.DateValidityOptions := dcoNotNil;
       2 : AdrockDateEdit1.DateValidityOptions := dcoBetweenMinAndMaxAndNil;
       3 : AdrockDateEdit1.DateValidityOptions := dcoBetweenMinAndMaxNoNil;
       4 : AdrockDateEdit1.DateValidityOptions := dcoGreaterEqualMinAndNil;
       5 : AdrockDateEdit1.DateValidityOptions := dcoGreaterEqualMinNoNil;
       6 : AdrockDateEdit1.DateValidityOptions := dcoLessEqualMaxAndNil;
       7 : AdrockDateEdit1.DateValidityOptions := dcoLessEqualMaxNoNil;
     end;
   AdrockDateEdit1.DateMin := MinDate.Date;
   AdrockDateEdit1.DateMax := MAXDate.Date;
end;

procedure TDateDemoForm.MinDateExit(Sender: TObject);
begin
   AdrockDateEdit1.DateMin := MinDate.Date;
end;

procedure TDateDemoForm.MaxDateExit(Sender: TObject);
begin
   AdrockDateEdit1.DateMax := MaxDate.Date;
end;

procedure TDateDemoForm.StartingDayOfWeekComboBoxChange(Sender: TObject);
begin
  case (Sender as TComboBox).ItemIndex of
    0 : {Sunday    }  AdrockDateEdit1.WeekStart := wsSunday;
    1 : {Monday    }  AdrockDateEdit1.WeekStart := wsMonday;
    2 : {Tuesday   }  AdrockDateEdit1.WeekStart := wsTuesday;
    3 : {Wednesday }  AdrockDateEdit1.WeekStart := wsWednesday;
    4 : {Thursday  }  AdrockDateEdit1.WeekStart := wsThursday;
    5 : {Friday    }  AdrockDateEdit1.WeekStart := wsFriday;
    6 : {Saturday  }  AdrockDateEdit1.WeekStart := wsSaturday;
   end;
end;

procedure TDateDemoForm.CalendarWeekNumberBevelComboBoxChange(Sender: TObject);
begin
     case (Sender as TComboBox).ItemIndex of
       0 : AdrockDateEdit1.CalendarWeekNumberBevel := bvNone;
       1 : AdrockDateEdit1.CalendarWeekNumberBevel := bvLowered;
       2 : AdrockDateEdit1.CalendarWeekNumberBevel := bvRaised;
     end;
end;

procedure TDateDemoForm.ColorCalendarCaptionBackClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarCaptionBack;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarCaptionBack := ColorDialog1.Color;
end;

procedure TDateDemoForm.ColorCalendarDateBevelClick(Sender: TObject);
begin                                                
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarDateBevel;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarDateBevel := ColorDialog1.Color;
end;

procedure TDateDemoForm.ColorCalendarGridBackgroundClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarGridBackground;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarGridBackground := ColorDialog1.Color;
end;

procedure TDateDemoForm.Button13Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarMonthArrowHead;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarMonthArrowHead := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button15Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarPrevNextMonth;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarPrevNextMonth := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button21Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarYearArrowHead;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarYearArrowHead := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button16Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarRangeErrors;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarRangeErrors := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button18Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarStatusBack;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarStatusBack := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button19Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarSunday;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarSunday := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button20Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarWeekNumber;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarWeekNumber := ColorDialog1.Color;
end;

procedure TDateDemoForm.ColorCalendarButtonsUpClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarButtonsUp;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarButtonsUp := ColorDialog1.Color;

end;

procedure TDateDemoForm.ColorCalendarButtonsDownClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarButtonsDown;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarButtonsDown := ColorDialog1.Color;

end;

procedure TDateDemoForm.ColorCalendarHighlightClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarHighlight;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarHighlight := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button17Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarSaturday;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarSaturday := ColorDialog1.Color;

end;

procedure TDateDemoForm.ColorWhileFocusedClick(Sender: TObject);
begin
  ShowMessage('All TAdrockXXXX edit style components will support this property!'); 
  ColorDialog1.Color := AdrockDateEdit1.ColorWhileFocused;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorWhileFocused := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button5Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorWeekDay;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorWeekDay := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button22Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorEditingHighlight;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorEditingHighlight := ColorDialog1.Color;

end;

procedure TDateDemoForm.ColorBadDateTextClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorBadDateText;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorBadDateText := ColorDialog1.Color;

end;

procedure TDateDemoForm.ColorCalendarBackClick(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarBack;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarBack := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button9Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarGrid;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarGrid := ColorDialog1.Color;

end;

procedure TDateDemoForm.Button14Click(Sender: TObject);
begin
  ColorDialog1.Color := AdrockDateEdit1.ColorCalendarNormal;
  if (ColorDialog1.Execute = TRUE) then
    AdrockDateEdit1.ColorCalendarNormal := ColorDialog1.Color;
end;

procedure TDateDemoForm.CalendarFontButtonClick(Sender: TObject);
begin
  FontDialog1.FOnt.Assign(AdrockDateEdit1.FontCalendar);
  if (FontDialog1.Execute = TRUE) then
    AdrockDateEdit1.FontCalendar.Assign(FontDialog1.FOnt);
end;

procedure TDateDemoForm.CalendarCaptionFontClick(Sender: TObject);
begin
  FontDialog1.FOnt.Assign(AdrockDateEdit1.FontCalendarCaption);
  if (FontDialog1.Execute = TRUE) then
    AdrockDateEdit1.FontCalendarCaption.Assign(FontDialog1.FOnt);
end;

procedure TDateDemoForm.CalendarStatusFontButtonClick(Sender: TObject);
begin
  FontDialog1.FOnt.Assign(AdrockDateEdit1.FontCalendarStatus);
  if (FontDialog1.Execute = TRUE) then
    AdrockDateEdit1.FontCalendarStatus.Assign(FontDialog1.FOnt);
end;

procedure TDateDemoForm.CaptionTextChange(Sender: TObject);
begin
  AdrockDateEdit1.CalendarCaption := (Sender as TEdit).Text;
end;

procedure TDateDemoForm.StatusTextChange(Sender: TObject);
begin
  AdrockDateEdit1.CalendarStatus := (Sender as TEdit).Text;
end;

procedure TDateDemoForm.CalendarDateBevelComboBoxChange(Sender: TObject);
begin
     case (Sender as TComboBox).ItemIndex of
       0 : AdrockDateEdit1.DateBevel := bvNone;
       1 : AdrockDateEdit1.DateBevel := bvLowered;
       2 : AdrockDateEdit1.DateBevel := bvRaised;
     end;
end;

procedure TDateDemoForm.EditWeekdayCheckBoxClick(Sender: TObject);
begin
    AdrockDateEdit1.EditWeekDay := (Sender as TCheckBox).Checked;
end;

procedure TDateDemoForm.Button3Click(Sender: TObject);
begin
     EventListBox.Items.Clear;
end;

procedure TDateDemoForm.AdrockDateEdit1BeforeChange(Sender: TObject);
begin
 if (EventListBox <> nil) then
     EventListBox.Items.Add('Before : '+DateToStr(AdrockDateEdit1.Date));
end;

procedure TDateDemoForm.AdrockDateEdit1Change(Sender: TObject);
begin
 if (EventListBox <> nil) then
     EventListBox.Items.Add('Change : '+DateToStr(AdrockDateEdit1.Date));
end;

end.
