unit SamClock;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Menus,
     SysUtils, Dialogs, StdCtrls, Buttons, ExtCtrls, Adclock;

type
  TSampleClock = class(TForm)
    AdrockAnalogClock1: TAdrockAnalogClock;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel4: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Panel3: TPanel;
    DateLabelBottom: TLabel;
    DateLabelTop: TLabel;
    TimeLabelBottom: TLabel;
    TimeLabelTop: TLabel;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure AdrockAnalogClock1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AdrockAnalogClock1Second(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    Count : Integer;
  public
    { Public declarations }
  end;

var
  SampleClock: TSampleClock;

implementation

{$R *.DFM}

procedure TSampleClock.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     Application.Terminate;
end;

procedure TSampleClock.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
     Application.Terminate;
end;

procedure TSampleClock.AdrockAnalogClock1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Count > 3) then
     Close
  else
    Inc(Count);
end;

procedure TSampleClock.FormCreate(Sender: TObject);
begin
     if (hPrevInst > 0) then
       Application.Terminate;
     Count :=0;
     Screen.Cursor := -1;
end;

procedure TSampleClock.FormDestroy(Sender: TObject);
begin
     Screen.Cursor := crdefault;
end;

procedure TSampleClock.AdrockAnalogClock1Second(Sender: TObject);
begin
     DateLabelTop.Caption := FormatDateTime('D MMM YYYY', Date);
     DateLabelBottom.Caption := DateLabelTop.Caption;
     TimeLabelTop.Caption := FormatDateTime('H:MM AM/PM', Time);
     TimeLabelBottom.Caption := TimeLabelTop.Caption;
end;

procedure TSampleClock.FormKeyPress(Sender: TObject; var Key: Char);
begin
     Application.Terminate;
end;

end.

