unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls, swServ, CGI;


type
  TMainForm = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    bStart: TBitBtn;
    bStop: TBitBtn;
    bClose: TBitBtn;
    StatusBar2: TStatusBar;
    QuickWeb1: TQuickWeb;
    tpcOnglet: TPageControl;
    tsGeneral: TTabSheet;
    Label1: TLabel;
    eDirectoryRoot: TEdit;
    Label2: TLabel;
    eDocument: TEdit;
    HostName: TLabel;
    eHostName: TEdit;
    Port: TLabel;
    ePort: TEdit;
    tsMapping: TTabSheet;
    lMapping: TListBox;
    bMappingAdd: TBitBtn;
    bModifyMapping: TBitBtn;
    bDeleteMapping: TBitBtn;
    eMapping: TEdit;
    tsDirectory: TTabSheet;
    lDirectory: TListBox;
    eDirectory: TEdit;
    bAddDirectory: TBitBtn;
    bModifyDirectory: TBitBtn;
    bDeleteDirectory: TBitBtn;
    Label3: TLabel;
    Label4: TLabel;
    procedure bCloseClick(Sender: TObject);
    procedure bStartClick(Sender: TObject);
    procedure bStopClick(Sender: TObject);
    procedure QuickWeb1SetLog(Sender: TObject; Msg: string);
    procedure FormCreate(Sender: TObject);
    procedure QuickWeb1VerifPassword(Sender: TObject; FullFileName,
      password: string; var Ok: Boolean);
    procedure bMappingAddClick(Sender: TObject);
    procedure bModifyMappingClick(Sender: TObject);
    procedure lMappingClick(Sender: TObject);
    procedure bDeleteMappingClick(Sender: TObject);
    procedure bAddDirectoryClick(Sender: TObject);
    procedure bModifyDirectoryClick(Sender: TObject);
    procedure bDeleteDirectoryClick(Sender: TObject);
    procedure lDirectoryClick(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.bCloseClick(Sender: TObject);
begin
     Close
end;

procedure TMainForm.bStartClick(Sender: TObject);
begin
     QuickWeb1.Hostname := eHostname.text ;
     QuickWeb1.PortToService := strtoint(ePort.text);
     QuickWeb1.DefaultDocument := eDocument.text ;
     QuickWeb1.DocumentRoot := eDirectoryRoot.text;
     QuickWeb1.WwwServerStart;
     Memo1.clear;
     memo1.Lines.Add('Server Started');
     bStart.enabled := false;
     bStop.enabled := true;
end;

procedure TMainForm.bStopClick(Sender: TObject);
begin
    QuickWeb1.WwwServerStop;
    memo1.Lines.Add('Server Stopped');
    bStart.enabled := true;
    bStop.enabled := false;

end;

procedure TMainForm.QuickWeb1SetLog(Sender: TObject; Msg: string);
begin
    memo1.Lines.Add( FormatDateTime( 'mm/dd hh:mm:ss ', Now) + Msg);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   tpcOnglet.activePage := tsGeneral;
   eHostname.text := QuickWeb1.Hostname;
    ePort.text := inttostr(QuickWeb1.PortToService);
    eDocument.text := QuickWeb1.DefaultDocument;
    if  QuickWeb1.DocumentRoot = '' then
        eDirectoryRoot.text := extractfilepath(Application.exename)
    else
        eDirectoryRoot.text :=  QuickWeb1.DocumentRoot;
    lMapping.items :=  QuickWeb1.Mapping;
    lDirectory.items :=  QuickWeb1.Directory;
end;




procedure TMainForm.QuickWeb1VerifPassword(Sender: TObject; FullFileName,
  password: string; var Ok: Boolean);
begin
      Ok := true;
end;

procedure TMainForm.bMappingAddClick(Sender: TObject);
begin

   QuickWeb1.Mapping.add(eMapping.text);
   lMapping.clear;
   lMapping.items :=  QuickWeb1.Mapping;
end;




procedure TMainForm.bModifyMappingClick(Sender: TObject);
begin
   QuickWeb1.Mapping[lMapping.ItemIndex] := eMapping.text;
   lMapping.clear;
   lMapping.items :=  QuickWeb1.Mapping;
end;

procedure TMainForm.lMappingClick(Sender: TObject);
begin
     eMapping.text := QuickWeb1.Mapping[lMapping.ItemIndex];
end;

procedure TMainForm.bDeleteMappingClick(Sender: TObject);
begin
    QuickWeb1.Mapping.delete(lMapping.ItemIndex) ;
   lMapping.clear;
   lMapping.items :=  QuickWeb1.Mapping;

end;

procedure TMainForm.bAddDirectoryClick(Sender: TObject);
begin

   QuickWeb1.Directory.add(eDirectory.text);
   lDirectory.clear;
   lDirectory.items :=  QuickWeb1.Directory;
end;




procedure TMainForm.bModifyDirectoryClick(Sender: TObject);
begin
   QuickWeb1.Directory[lDirectory.ItemIndex] := eDirectory.text;
   lDirectory.clear;
   lDirectory.items :=  QuickWeb1.Directory;
end;

procedure TMainForm.lDirectoryClick(Sender: TObject);
begin
     eDirectory.text := QuickWeb1.Directory[lDirectory.ItemIndex];
end;

procedure TMainForm.bDeleteDirectoryClick(Sender: TObject);
begin
    QuickWeb1.Directory.delete(lDirectory.ItemIndex) ;
   lDirectory.clear;
   lDirectory.items :=  QuickWeb1.Directory;

end;





end.
