unit FDBQuery;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CgiDBUtl, CGIUtl, CGIEng, DB, DBTables;

type
  TForm1 = class(TForm)
    CGIEngine1: TCGIEngine;
    CGIMaster1: TCGIMaster;
    CGIDBGrid1: TCGIDBGrid;
    Query1: TQuery;
    procedure CGIMaster1HtmlBody;
    procedure CGIEngine1CGIRequest(Sender: TObject);
    procedure CGIDBGrid1CustomiseRow(Sender: TObject; var TextColor,
      BGColor: TColor);
    procedure CGIDBGrid1CustomiseField(Sender: TObject; Field: TField;
      var FieldString, Link: string; var TextColor, BGColor: TColor;
      var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.CGIMaster1HtmlBody;
var
  S : String;
begin
  with CGIEngine1 do
  begin
    PutLine('<CENTER>');
    PutLine('<FORM METHOD=POST ACTION="dbquery.exe">');
    PutLine('Query : <INPUT NAME="QUERY" TYPE=text VALUE="Select * From Shares" SIZE=70 MAXLENGTH=200><BR><BR>');
    PutLine('<INPUT NAME="EXECUTE" TYPE=submit SIZE=20 VALUE="Execute Query">');
    PutLine('</FORM><BR><BR>');

    S:=GetFormString('Query');
    if S<>Not_Available then
    Try
      Query1.SQL.Clear; Query1.SQL.Add(S); Query1.Open;
      CGIDBGrid1.Title.Caption:=S;
      CGIDBGrid1.Put;
    except
        PutLine('To run this application you have to create an alias named "CGITestDB" pointing at the path where the shares.db file is situated.');
    end;
  end;
end;

procedure TForm1.CGIEngine1CGIRequest(Sender: TObject);
begin
  CGIMaster1.Put;
end;

procedure TForm1.CGIDBGrid1CustomiseRow(Sender: TObject; var TextColor,
  BGColor: TColor);
begin
  try
  if Query1.FieldByName('Diff').AsFloat>0 then
    TextColor:=clBlue
  else if Query1.FieldByName('Diff').AsFloat<0 then
    TextColor:=clRed;
  except
  end;
end;

procedure TForm1.CGIDBGrid1CustomiseField(Sender: TObject; Field: TField;
  var FieldString, Link: string; var TextColor, BGColor: TColor;
  var FontSize: TFontSize; var Bold, Italic, NoFlow, NoWrap: Boolean);
begin
  if AnsiUpperCase(Field.FieldName)='DATE' then
  begin
    FontSize:=fsSize2;
    TextColor:=clBlack;
    Italic:=True;
  end
  else if AnsiUpperCase(Field.FieldName)='NAME' then
    Bold:=True;
end;

end.
