unit Main_32;

interface

uses
  Windows, Messages, Prscrn32, ClipFn32, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    PrintScreenDemo1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Memo1: TMemo;
    PrintScreen1: TPrintScreen;
    ShowAbortDlg1: TMenuItem;
    Print_Screen_Sel: TMenuItem;
    SavetoBMPFile1: TMenuItem;
    CopytoClipboard1: TMenuItem;
    Environment1: TEnvironment;
    procedure FormCreate(Sender: TObject);
    procedure PrintScreen1Print(Sender: TObject; var Op: TPSOperation);
    procedure CopytoClipboard1Click(Sender: TObject);
    procedure SavetoBMPFile1Click(Sender: TObject);
    procedure Print_Screen_SelClick(Sender: TObject);
    procedure ShowAbortDlg1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    { Hook into Application's Message Handling to check for hotkey }
    procedure CheckForHotKey( var Msg: TMsg; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  menuSel : Integer;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
    sTest, sTemp : String;
    i : LongInt;
    wStart, wEnd: LongInt;
begin
    wStart := Seconds;    { Save time we start this process...}
    { Set our MessageHandler to see all messages before application...}
    Application.OnMessage := CheckForHotKey;
    menuSel := -1;        { Initialize variable for OnPrint handler }
    with Memo1.Lines do begin
       Add('This application demonstrates most (but not all!) of the functions');
       Add('available in Clipper Functions 2.0 for Delphi.  Note that the date');
       Add('format has been set to ''mm/dd/yyyy'' by setting TEnvironment properties');
       Add('properties at design time...');
       Add(' '); { Blank space - NULL_STRING ('') didn't add a blank line always? }

       Add('Scroll through the window to see the function calls and results, and');
       Add('examine the source code to see how easy the routines are to use!');
       Add(' ');

       Add('To test the use of the TPrintScreen component, select the File menu,');
       Add('and choose one of the PrintScreen options.  This allows you to test some');
       Add('of the functionality available.  Note that the TPrintScreen component');
       Add('only has to be placed on a single form in your application, and can be');
       Add('accessed from any unit that uses ClipFn32 with a simple call to the');
       Add('PrintScreen procedure.  For the purposes of this demonstration, several');
       Add('menu handlers have been provided, and the menu selection sets menuVar');
       Add('to the appropriate value and then calls PrintScreen.  The value of the');
       Add('''menuSel'' variable is used in the OnPrint event handler to determine');
       Add('what action to take... Also, there is a hotkey assigned and a program-');
       Add('wide hotkey (F9) set to allow PrintScreen functionality from a single');
       Add('keypress (see the TForm1.CheckForHotKey procedure).');
       Add(' ');

       Add('NOTE:  You should make sure your printer is connected and on-line');
       Add('before using the PrintScreen component demo (with the exception of the');
       Add('''Save To File'' option)');
       Add(' ');

       Add('You should know that the long delay in loading this demo is caused by');
       Add('the demo of the Seconds function.  Delphi 2.0''s optimizations kept a');
       Add('delay from being performed by a ''do nothing'' for loop, so I had to use');
       Add('5000 calls to a function inside the loop to introduce an actual three or');
       Add('four second delay on a 75 mhz Pentium - if you don''t see a delay,');
       Add('increase the upper limit of the loop at approx. line 262.');
       Add(' ');

       sTemp := 'Demonstration of string handling functions...';
       Add(sTemp);
       Add(Replicate('-', Length(sTemp)));
       Add('The line of ''-'' characters above was created by a call to');
       Add('Replicate(''-'', Length(sTemp));');
       Add('Space(50) returns [' + Space(50) + ']');
       Add(' ');

       sTemp := '   This is a demonstration of Trim functions...   ';
       Add('Original string   : [' + sTemp + ']');
       Add(' ');
       Add('LTrim(sTemp)      : ' + '[' + LTrim(sTemp) + ']');
       Add('RTrim(sTemp)      : ' + '[' + RTrim(sTemp) + ']');
       Add('AllTrim(sTemp)    : ' + '[' + AllTrim(sTemp) + ']');
       Add(' ');

       sTemp := 'This demonstrates the Pad functions...';
       Add('Original string    : [' + sTemp + ']');
       Add('PadL(sTemp, #0, 45)  : [' + PadL(sTemp, #0, 45) + ']');
       Add('PadC(sTemp, ''-'', 45: [' + PadC(sTemp, '-', 45) + ']');
       Add('PadR(sTemp, ''-'', 45: [' + PadR(sTemp, '-', 45) + ']');
       Add(' ');
       Add('StrZero(''123'', 10) : ' + StrZero('123', 10));
       Add(' ');

       sTemp := 'This demonstrates the SubString functions...';
       Add(sTemp);
       Add('SubStr(sTemp, 1, 14) returns: ' + SubStr(sTemp, 1, 14));
       Add('SubStr(sTemp, 15, 0) returns: ' + SubStr(sTemp, 15, 0));
       Add(' ');
       sTemp := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
       Add('Original string  : ' + sTemp);
       sTest := Clipfn32.Left( sTemp, 13);   { Because of with Memo1.Lines above }
       Add('Left(sTemp, 13)  : ' + sTest);
       Add('Right(sTemp, 13) : ' + Right(sTemp, 13));
       Add(' ');
       sTemp := 'This is a string for At/RAt demonstration...';
       Add( sTemp );
       Add('At(''/'', sTemp) returns : ' + IntToStr(At('/', sTemp)));
       Add('RAt(''s'', sTemp) returns : ' + IntToStr(RAt('A', sTemp)));
       Add(' ');
       Add('Remember, At/RAt are case-sensitive; for case insensitive');
       Add('searches, use AtI/RAtI instead...');
       Add('At(''O'', sTemp) returns : ' + IntToStr(At('O', sTemp)));
       Add('AtI(''O'', sTemp) returns: ' + IntToStr(AtI('O', sTemp)));
       Add(' ');
       Add('Using Stuff/StrTran functions...');
       Add(' ');
       Add('Original string to Stuff()');
       Add(' ');
       Add('    => ' + sTemp );
       Add(' ');
       Add('Stuff(sTemp, At(''At'', sTemp), 6, ''Stuff()'') leaves');
       Add(' ');
       Add('    => ' + Stuff(sTemp, At('At', sTemp), 6, 'Stuff()'));
       Add(' ');

       sTemp := 'This is a test This is a test This is a test';
       Add('Original string for StrTran() example');
       Add(' ');
       Add('    => ' + sTemp );
       Add(' ');
       sTest := StrTran(sTemp, ' is', ' was', 1, 1);
       Add('Replace first ocurrence of '' is'' with '' was'' with call to');
       Add(' ');
       Add('  StrTran(sTemp, '' is'', '' was'', 1, 1)');
       Add(' ');
       Add('    => ' +  sTest);
       Add(' ');

       sTest := StrTran(sTemp, ' is', ' was', 3, 1);
       Add('Replace only third ocurrence of '' is'' with '' was''');
       Add(' ');
       Add('  StrTran(sTemp, '' is'', '' was'', 3, 1)');
       Add(' ');
       Add('    => ' +  sTest);
       Add(' ');

       sTest := StrTran(sTemp, ' is', ' was', 1, 0);
       Add('Replace all ocurrences of '' is'' with '' was'' with call to');
       Add(' ');
       Add('  StrTran(sTemp, '' is'', '' was'', 1, 0)');
       Add(' ');
       Add('    => ' + sTest);
       Add(' ');

       sTest := StrTran(sTemp, ' is', ' will be', 1, 0);
       Add('Multiple words can be used, either as replaced or replacement value...');
       Add(' ');
       Add('  StrTran(sTemp, '' is'', '' will be'', 1, 0) gives us');
       Add(' ');
       Add('    => ' + sTest);
       Add(' ');

       Add('Note the leading spaces before ''is'' and ''was'' in the above calls.');
       Add('These are needed to prevent the following - ');
       Add(' ');
       sTest := StrTran(sTemp, 'is', 'WAS', 1, 0);
       Add('  StrTran(sTemp, ''is'', ''WAS'', 1, 0)');
       Add(' ');
       Add('    => ' + sTest);
       Add(' ');

       Add('Transform() has several uses...');
       Add(' ');
       Add('Note that the following calls do NO conversions to the data for display!');
       Add('Also, the square brackets ([ ]) around the first parameter are required!');
       Add(' ');
       Add('Transform([Date], ''@D'')              : ' + TransForm([Date], '@D'));
       Add('Transform([12345.67], ''$999,999.99'') : ' +
                                  Transform([12345.67], '$999,999.99'));
       Add('Transform([12345.67], ''@$999,999.99''): ' +
                                  Transform([12345.67], '@$999,999.99'));
       Add(' ');
       Add('Transform([''borland delphi''], ''@P'')  : ' +
                                  Transform(['borland delphi'], '@P'));
       Add('Transform([''This is a test''], ''@P'')  : ' +
                                  Transform(['This is a test'], '@P'));
       Add('Transform([''delphi''], ''@!'')          : ' +
                                  Transform(['delphi'], '@!'));
       Add('Transform([''delphi''], ''!x!x!x'')      : ' +
                                  Transform(['delphi'], '!x!x!x'));
       Add(' ');

       Add('Transform() supports more picture clauses and functions than shown -');
       Add('see the documentation for more information.');
       Add(' ');

       Add('Another useful formatting routine is NumWord()...');
       Add('NumWord(123.45) : ' + NumWord(123.45));
       Add('NumWord(2345.67): ' + NumWord(2345.67));
       Add(' ');

       sTest := 'This is a demo string for Encrypt/Decrypt';
       Add('Start with: ' + sTest);
       sTest := Encrypt(sTest, 23456);
       Add('Encrypted : ' + sTest);
       sTest := Decrypt(sTest, 23456);
       Add('Decrypted : ' + sTest);
       Add(' ');

       Add('Demonstrating the Soundex function...');
       Add(' ');
       Add('Soundex(''Robinson''):  ' + Soundex('Robinson'));
       Add('Soundex(''Robinsen''):  ' + Soundex('Robinsen'));
       Add('Soundex(''Robinsyn''):  ' + Soundex('Robinsyn'));
       Add(' ');
       Add('Soundex(''Smith'')   :  ' + Soundex('Smith'));
       Add('Soundex(''Smythe'')  :  ' + Soundex('Smythe'));
       Add(' ');
       Add('Soundex(''Ware'')    :  ' + Soundex('Ware'));
       Add('Soundex(''Wear'')    :  ' + Soundex('Wear'));
       Add('Soundex(''Wary'')    :  ' + Soundex('Wary'));
       Add(' ');
       Add('Note that there are a couple of peculiarities with the original Soundex()');
       Add('algorithm, and some things won''t work exactly the way you''d expect.');
       Add('See the on-line help for more info...');
       Add(' ');
       Add('Soundex(''One'')     :  ' + Soundex('One'));
       Add('Soundex(''Won'')     :  ' + Soundex('Won'));
       Add(' ');

       Add('The following lines demonstrate both the IsXXXX() functions and the');
       Add('implementation of the IIFS() function...');
       Add(' ');
       Add('IsAlpha(''1'')      : ' + IIFS(IsAlpha('1'), 'True', 'False'));
       Add('IsAlpha(''A'')      : ' + IIFS(IsAlpha('A'), 'True', 'False'));
       Add(' ');
       Add('IsDigit(''A'')      : ' + IIFS(IsDigit('A'), 'True', 'False'));
       Add('IsDigit(''1'')      : ' + IIFS(IsDigit('1'), 'True', 'False'));
       Add(' ');
       Add('IsUpper(''A'')      : ' + IIFS(IsUpper('A'), 'True', 'False'));
       Add('IsUpper(''a'')      : ' + IIFS(IsUpper('a'), 'True', 'False'));
       Add(' ');
       Add('IsLower(''A'')      : ' + IIFS(IsLower('A'), 'True', 'False'));
       Add('IsLower(''a'')      : ' + IIFS(IsLower('a'), 'True', 'False'));
       Add(' ');
       Add('IsNumeric(''12345''): ' + IIFS(IsNumeric('12345'), 'True', 'False'));
       Add('IsNumeric(''ABCDE''): ' + IIFS(IsNumeric('ABCDE'), 'True', 'False'));
       Add('IsNumeric(''12a45''): ' + IIFS(IsNumeric('12a45'), 'True', 'False'));
       Add('IsNumeric(''-1234''): ' + IIFS(IsNumeric('-1234'), 'True', 'False'));
       Add(' ');
       Add('IsFloat(''12345'')  : ' + IIFS(IsFloat('12345'), 'True', 'False'));
       Add('IsFloat(''12345.6''): ' + IIFS(IsFloat('12345.6'), 'True', 'False'));
       Add(' ');

       Add('There are even more string routines available - check the documentation');
       Add('for details!');
       Add(' ');
       sTemp := 'Demo of date handling routines...';
       Add(sTemp);
       Add(Replicate('-', Length(sTemp)));

       Add('DToC(Date)        : ' + DToC(Date));
       Add('DToS(Date)        : ' + DToS(Date));
       Add(' ');
       Add('CDoW(Date)        : ' + CDoW(DoW(Date)));
       Add('CMonth(Date)      : ' + CMonth(Month(Date)));
       Add(' ');
       Add('DoW(Date)         : ' + IntToStr(DoW(Date)));
       Add('Month(Date)       : ' + IntToStr(Month(Date)));
       Add('Year(Date)        : ' + IntToStr(Year(Date)));
       Add(' ');
       Add('FirstOfMonth(Date): ' + FirstOfMonth(Date));
       Add('LastOfMonth(Date) : ' + LastOfMonth(Date));
       Add(' ');
       Add('Starting Seconds  : ' + IntToStr(wStart));
       { Had to add a delay that the compiler wouldn't optimize out...}
       for i := 1 to 2500 do  { W/O function call, compiler killed loop! }
           Seconds;
       wEnd := Seconds;
       Add('Ending Seconds    : ' + IntToStr(wEnd));
       Add('Elapsed Time      : ' + IntToStr(wEnd - wStart) + ' seconds');
       Add(' ');
    end;
end;

{ PrintScreen1's OnPrint event handler...}
procedure TForm1.PrintScreen1Print(Sender: TObject; var Op: TPSOperation);
begin
    { Note that the menuSel var and the case statement wouldn't normally be
      needed - you would either display a dialog to get user input, or simply
      print to the default printer.  The menuSel var is being used just for
      demonstration purposes, to show the various types of functionality
      available... If menuSel is set to -1, nothing happens...}
    case menuSel of
        0: begin { Allows user to cancel by selecting 'Cancel' button }
              if (MessageDlg('Print this screen to default printer?',
                           mtConfirmation, [mbOk, mbCancel], 0) = mrCancel) then
                  Op := psCancel
              else
                  Op := psPrinter;
           end;
        1: Op := psPrinter; { Sends directly to default printer due to AutoPrint True}
        2: Op := psClipBoard; { Copies image to clipboard - paste into Paint to view }
        3: Op := psFile;     { Displays 'SaveAs' dialog and saves to .BMP file }
    end;
end;

{ Handlers for menu selections.  Note that all actual functionality is handled
  in the PrintScreen OnPrint handler above... }

{ Handler for File|PrintScreen|Copy to Clipboard menu selection }
procedure TForm1.CopytoClipboard1Click(Sender: TObject);
begin
     menuSel := 2;
     PrintScreen;   { Note simple call to Clipper Functions routine... }
     menuSel := -1;
     ShowMessage('Copy to Windows Clipboard complete!');
end;

{ Handler for File|PrintScreen|Save to Bitmap menu selection}
procedure TForm1.SavetoBMPFile1Click(Sender: TObject);
begin
     menuSel := 3;
     PrintScreen;    { Note simple call to Clipper Functions routine... }
     menuSel := -1;
     ShowMessage('Save to Bitmap File complete!');
end;

{ Handler for File|PrintScreen|Print Screen menu selection }
procedure TForm1.Print_Screen_SelClick(Sender: TObject);
begin
     menuSel := 1;
     PrintScreen;    { Note simple call to Clipper Functions routine... }
     menuSel := -1;
end;

{ Handler for File|PrintScreen|Show Abort Dlg menu selection }
procedure TForm1.ShowAbortDlg1Click(Sender: TObject);
begin
     menuSel := 0;
     PrintScreen;     { Note simple call to Clipper Functions routine... }
     menuSel := -1;
end;

{ Handler for File|Exit menu selection }
procedure TForm1.Exit1Click(Sender: TObject);
begin
     Application.Terminate;
end;

{ This procedure checks the events received by the application (not just this
  form) for the hotkey we've assigned; if received, it sets menuSel to the
  psPrint flag, prints the screen, resets menuSel for the next time, and tells
  the default Application message handler that we've handled the event.  If
  the message received is NOT our hotkey (in this case F9), or it is not
  a keydown message, the message is automatically dispatched to the app's
  default handler (Handled is left as False).

  Also note that this handler, as currently written, does NOT work with
  CTRL/ALT/SHIFT key combinations.  Those combinations have to be handled
  as a series of keystrokes received in sucession, and this involves testing
  both the value of Msg.WParam and a bit set in Msg.LParam...}
procedure TForm1.CheckForHotKey( var Msg: TMsg; var Handled: Boolean);
begin
    Handled := False;
    { If this message is a KeyPress, check to see if it's our hotkey (F9) }
    if (Msg.Message = WM_KEYDOWN) then
      if (Msg.WParam = VK_F9) then begin
        menuSel := 1;
        PrintScreen;  { Note simple call to Clipper Functions routine... }
        menuSel := -1;
        Handled := True; { Tell default message handler to ignore...}
        { You'd handle CTRL/ALT/SHIFT combinations here with an else... }
     end;
end;

end.