
unit Porttest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, ComCtrls, Menus, TCOMM_32;



type
  TTestForm = class(TForm)
    Panel1: TPanel;
    Memo1: TMemo;
    bOpenComm: TButton;
    bClose: TButton;
    bCommWrite: TButton;
    SpeedButton2: TSpeedButton;
    Memo2: TMemo;
    bShowSettings: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Terminal1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    StatusBar1: TStatusBar;
    sbSysInfo: TSpeedButton;
    SysInfo1: TMenuItem;
    bFlushTX: TButton;
    bFlushRx: TButton;
    PanelMisc: TPanel;
    HangUp: TButton;
    liteRXD: TShape;
    liteCTS: TShape;
    lRxD: TLabel;
    lCTS: TLabel;
    lVersion: TLabel;
    liteDSR: TShape;
    liteRing: TShape;
    lDSR: TLabel;
    lRing: TLabel;
    lRLSD: TLabel;
    liteRLSD: TShape;
    liteTXD: TShape;
    lTxD: TLabel;
    CommPort1: TCommPort;
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure bOpenCommClick(Sender: TObject);
    procedure bCloseClick(Sender: TObject);
    procedure CommPort1Receive(bufptr: apBuffer; size: Integer);
    procedure FormCreate(Sender: TObject);
    procedure bShowSettingsClick(Sender: TObject);
    procedure sbSysInfoClick(Sender: TObject);
    procedure bFlushTXClick(Sender: TObject);
    procedure bFlushRxClick(Sender: TObject);
{    procedure CommPort1CTSChange(sender: TObject);}
    procedure HangUpClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UpdateLites;
  private
{    CommPort1:TCommPort;}
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TestForm  : TTestForm;
  ComName,
  Speed     : String;
  _Parity   : TParity;
  Stop_Bits : TStop;
  Byte_Size : TByte;
  IsParity  : Boolean;


implementation

uses Settings, sysinfo1;

{$R *.DFM}
{uses Settings;}

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.SpeedButton2Click(Sender: TObject);
begin
commport1.closecomm(commport1.WcomID);
application.processmessages;
close;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.SpeedButton6Click(Sender: TObject);
var
  I:Integer;
  DataToSend: apBuffer;
begin
 CommPort1.SetMCRTS(True);
 UpdateLites;
 LiteTxD.brush.color:=clRed;
 Refresh();
 Commport1.writeCommString(Memo2.Text);
 LiteTxD.brush.color:=clGreen;
 LiteTxD.refresh();
 UpdateLites;
 Refresh;
 CommPort1.SetMCRTS(False);

end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.bOpenCommClick(Sender: TObject);
begin
  try
    CommPort1.Open;
    StatusBar1.Panels.Items[1].Text := 'CommPort Opened';
    CommPort1.SetMCDTR(True);
    UpdateLites;
  except
    raise
  end;

  application.processmessages;
  lversion.caption:=commport1.version;

end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.bCloseClick(Sender: TObject);
begin
  UpdateLites;
  try
    Commport1.closecomm(CommPort1.WComID);
    application.processmessages;
    StatusBar1.Panels.Items[1].Text := 'CommPort Closed';
  except
    raise;
  end;
  commport1.SetMCDTR(False);
  CommPort1.SetMCRTS(False);
  UpdateLites
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.CommPort1Receive(bufptr: apBuffer; size: Integer);
var
  s              :String;
  I              :Integer;
begin
  s:= '';{}
  LiteRxD.brush.color:=clRed;
  LiteRxd.refresh();
  Refresh();
  for I:= 0 to size-1 do
    AppendStr( s, chr( bufptr[ i ] ) );
  Memo1.Text:=Memo1.text+s;
  Memo1.refresh;
  liteRxD.brush.color:=clGreen;
  liteRxD.Refresh();
  UpdateLites;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.FormCreate(Sender: TObject);
Var
_OSVERSIONINFO:TOSVersionInfo;
MajorVer,
MinorVer,
Numb:  dWORD;
Platform:String;
begin
{_OSVERSIONINFO.dwOSVersionInfoSize:=sizeof(_OSVERSIONINFO);
if GetVersionEx(_OSVERSIONINFO)then
begin
 MajorVer:=_OSVERSIONINFO.dwMajorVersion;
 MinorVer:=_OSVERSIONINFO.dwMinorVersion;
 Numb:=_OSVERSIONINFO.dwBuildNumber;
 if (_OSVERSIONINFO.dwPlatformId and VER_PLATFORM_WIN32_WINDOWS) <>0 THEN
   Platform:='Windows95';
 if (_OSVERSIONINFO.dwPlatformId and VER_PLATFORM_WIN32_NT) <>0 then
   Platform:='WindowsNT';
  showmessage(platform+' '+intTostr(MajorVer)+'.'+intTostr(MinorVer)+
  ', Build:'+inttostr(numb));
end;
}
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.bShowSettingsClick(Sender: TObject);
begin
 formSettings.showmodal;
end;

{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}
{><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><}

procedure TTestForm.sbSysInfoClick(Sender: TObject);
begin
  FormSysinfo.showmodal;
end;

procedure TTestForm.bFlushTXClick(Sender: TObject);
begin
  CommPort1.TxFlush;
  application.processmessages();
  UpdateLites;

end;

procedure TTestForm.bFlushRxClick(Sender: TObject);
begin
  CommPort1.RxFlush;
  application.processmessages();
  UpdateLites;
end;

{procedure TTestForm.CommPort1CTSChange(sender: TObject);
begin
  showmessage('Why am I here?');
  application.processmessages();
end;
}

procedure TTestForm.HangUpClick(Sender: TObject);
begin
{Hang Up Phone }
 Commport1.writeCommString('~~~+++~~~'+chr(13));
 Commport1.writeCommString('ATH0'+chr(13));
 application.processmessages;
 UpdateLites;

end;

procedure TTestForm.FormShow(Sender: TObject);
begin
  lversion.caption:=commport1.version;

  Testform.refresh();
  UpdateLites;
end;

procedure TTestForm.UpdateLites;
begin
 if commport1.MCTSOn then liteCTS.brush.color:=clRed else liteCTS.brush.color:=clGreen;
 if commport1.MRingOn then liteRing.brush.color:=clRed else liteRing.brush.color:=clGreen;
 if commport1.MRLSDOn then liteRLSD.brush.color:=clRed else liteRLSD.brush.color:=clGreen;
 if commport1.MDSROn then liteDSR.brush.color:=clRed else liteDSR.brush.color:=clGreen;
end;


end.
