{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Arrays4;

{$X+}

{ Sample program for accesing directly a standard object array }

uses Objects, Containr, ctArrays,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PWeatherInfo = ^TWeatherInfo;
  TWeatherInfo = object(TObject)
      Location : PString;
      Humidity : Integer;
      Rain : Integer;
    constructor Init(ALocation : string; AHumidity, ARain : Integer);
    destructor Done; virtual;
  end; { TWeatherInfo }

constructor TWeatherInfo.Init(ALocation : string; AHumidity, ARain : Integer);
begin
  Location := NewStr(ALocation);
  Humidity := AHumidity;
  Rain := ARain;
end;

destructor TWeatherInfo.Done;
begin
  DisposeStr(Location);
end;

procedure DisplayWeatherData(WeatherData : PSequence);
var
  i : Integer;
begin
  with WeatherData^ do
    for i := FirstIndex to LastIndex do
      with PWeatherInfo(At(i))^ do
        writeln('Hour: ', i:2, ':00', '':3, Location^, '':20 -
          Length(Location^), Humidity, '':5, Rain:5);
end;

procedure FindLowHumidityValue(WeatherData : PSequence);
var
  Item : Pointer;
  Index : LongInt;

  function HasLowHumidity(Item : PWeatherInfo) : Boolean; far;
  begin
    HasLowHumidity := (Item^.Humidity < 22);
  end;

begin
  Item := WeatherData^.FirstThat(@HasLowHumidity, Index);
  writeln ('First with low humidity (H < 22):');
  with PWeatherInfo(Item)^ do
    writeln('Hour: ', Index:2, ':00', '':3, Location^, '':20 -
      Length(Location^), Humidity, '':5, Rain:5);
end;

var
  MorningWeatherData : PStdObjectArray;

begin
  ClrScr;

  { Create the array }
  MorningWeatherData := New(PStdObjectArray, Init(7, 11,
    SizeOf(TWeatherInfo)));

  { Insert the items in the array }
  with MorningWeatherData^ do
  begin
    with PWeatherInfo(At(7))^ do
      Init('Miami', 34, 0);
    with PWeatherInfo(At(8))^ do
      Init('Helsinski', 23, 3);
    with PWeatherInfo(At(9))^ do
      Init('Canada', 26, 2);
    with PWeatherInfo(At(10))^ do
      Init('Berlin', 28, 5);
    with PWeatherInfo(At(11))^ do
      Init('Melbourne', 20, 0);
  end; { with }

  DisplayWeatherData(MorningWeatherData);
  writeln;
  FindLowHumidityValue(MorningWeatherData);

  { Dispose of the array }
  Dispose(MorningWeatherData, Done);
end.