{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Arrays9;

{$X+}

{ Sample program for using a stream object array }

uses Objects, Containr, ctArrays,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  String20 = string[20];

type
  PWeatherInfo = ^TWeatherInfo;
  TWeatherInfo = object(TObject)
      Location : PString;
      Humidity : Integer;
      Rain : Integer;
    constructor Init(ALocation : String20; AHumidity, ARain : Integer);
    constructor Load(var S: TStream);
    procedure Store(var S: TStream);
    destructor Done; virtual;
  end; { TWeatherInfo }

constructor TWeatherInfo.Init(ALocation : String20; AHumidity,
  ARain : Integer);
begin
  Location := NewStr(ALocation);
  Humidity := AHumidity;
  Rain := ARain;
end;

constructor TWeatherInfo.Load(var S: TStream);
begin
  Location := S.ReadStr;
  S.Read(Humidity, SizeOf(Humidity));
  S.Read(Rain, SizeOf(Rain));
end;

procedure TWeatherInfo.Store(var S: TStream);
begin
  S.WriteStr(Location);
  S.Write(Humidity, SizeOf(Humidity));
  S.Write(Rain, SizeOf(Rain));
end;

destructor TWeatherInfo.Done;
begin
  DisposeStr(Location);
end;

const
  RWeatherInfo : TStreamRec = (
    ObjType: 1000;
    VmtLink: Ofs(TypeOf(TWeatherInfo)^);
    Load:    @TWeatherInfo.Load;
    Store:   @TWeatherInfo.Store);

procedure DisplayWeatherData(WeatherData : PSequence);
var
  i : Integer;
  Item : Pointer;
begin
  with WeatherData^ do
    for i := FirstIndex to LastIndex do
    begin
      Item := At(i);
      with PWeatherInfo(Item)^ do
        writeln('Hour: ', i:2, ':00', '':3, Location^, '':20 -
          Length(Location^), Humidity, '':5, Rain:5);
      DoneItem(Item); { required }
    end; { for }
end;

procedure FindLowHumidityValue(WeatherData : PSequence);
var
  Item : Pointer;
  Index : LongInt;

  function HasLowHumidity(Item : PWeatherInfo) : Boolean; far;
  begin
    HasLowHumidity := (Item^.Humidity < 22);
  end;

begin
  Item := WeatherData^.FirstThat(@HasLowHumidity, Index);
  writeln ('First with low humidity (H < 22):');
  with PWeatherInfo(Item)^ do
    writeln('Hour: ', Index:2, ':00', '':3, Location^, '':20 -
      Length(Location^), Humidity, '':5, Rain:5);
  WeatherData^.DoneItem(Item);
end;

var
  MorningWeatherData : PEmsObjectArray;

begin
  ClrScr;

  { Create the array: data size must be equal to the maximum size of
    the data that will be stored in the array. }
  MorningWeatherData := New(PEmsObjectArray, Init(7, 11,
    SizeOf(String20) + (2 * SizeOf(Integer))));

  { Register the TWeatherInfo object }
  RegisterType(RWeatherInfo);

  { Insert the items in the array }
  with MorningWeatherData^ do
  begin
    AtInsert(7, New(PWeatherInfo, Init('Miami', 34, 0)));
    AtInsert(8, New(PWeatherInfo, Init('Helsinski', 23, 3)));
    AtInsert(9, New(PWeatherInfo, Init('Canada', 26, 2)));
    AtInsert(10, New(PWeatherInfo, Init('Berlin', 28, 5)));
    AtInsert(11, New(PWeatherInfo, Init('Melbourne', 20, 0)));
  end; { with }

  DisplayWeatherData(MorningWeatherData);
  writeln;
  FindLowHumidityValue(MorningWeatherData);

  { Dispose of the array }
  Dispose(MorningWeatherData, Done);
end.
